-- ExtraStaticGroundPS
-- Specialization for ExtraStaticGroundPS
--
--
--
--
--

local mod_directory = g_currentModDirectory;
source(Utils.getFilename("Scripts/StaticParticleSystem.lua", mod_directory));

ExtraStaticGroundPS = {};

function ExtraStaticGroundPS.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations); -- and SpecializationUtil.hasSpecialization(Foldable, specializations);
end;

function ExtraStaticGroundPS:load(xmlFile)
		
	self.staticGroundParticleSystems = {};
	local entry = {};
	entry.ps = {};
	--Utils.loadParticleSystem(xmlFile, entry.ps, "vehicle.staticGroundParticleSystem", self.components, false, nil, self.baseDirectory);
	StaticParticleSystem.loadParticleSystem(xmlFile, entry.ps, "vehicle.staticGroundParticleSystem", self.components, false, nil, self.baseDirectory);			
	if table.getn(entry.ps) > 0 then
		entry.isActive = false;
		table.insert(self.staticGroundParticleSystems, entry);
	end
	local i=0;
	while true do
		local baseName = string.format("vehicle.staticGroundParticleSystems.groundParticleSystem(%d)", i);
		if not hasXMLProperty(xmlFile, baseName) then
			break;
		end;
		local entry = {};
		entry.ps = {};
		--Utils.loadParticleSystem(xmlFile, entry.ps, baseName, self.components, false, nil, self.baseDirectory);
		StaticParticleSystem.loadParticleSystem(xmlFile, entry.ps, baseName, self.components, false, nil, self.baseDirectory);			
		if table.getn(entry.ps) > 0 then
			entry.isActive = false;
			entry.cuttingArea = i+1;
			table.insert(self.staticGroundParticleSystems, entry);
		end
		i = i+1;
	end;	
	
	self.lastStaticPSstate = false;
	
end;

function ExtraStaticGroundPS:delete()
	for _, entry in ipairs(self.staticGroundParticleSystems) do
		Utils.deleteParticleSystem(entry.ps);
		entry.isActive = false;
	end;
end;

function ExtraStaticGroundPS:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ExtraStaticGroundPS:keyEvent(unicode, sym, modifier, isDown)
end;

function ExtraStaticGroundPS:update(dt)
end;

function ExtraStaticGroundPS:updateTick(dt)
	
	if self.isClient then
		if self:getIsActive() then
			local isA = false;
			for i,e in pairs(self.groundParticleSystems) do
				if e.isActive == true then
					isA = true;
				end;
			end;
			if isA ~= self.lastStaticPSstate then
				self.lastStaticPSstate = isA;
				for i,e in pairs(self.staticGroundParticleSystems) do
					Utils.setEmittingState(e.ps, isA);
				end;
			end;
		else
			if self.lastStaticPSstate then
				for i,e in pairs(self.staticGroundParticleSystems) do
					Utils.setEmittingState(e.ps, false);
				end;
				self.lastStaticPSstate = false;
			end;
		end;
	end;
end;

function ExtraStaticGroundPS:draw()
end;

function ExtraStaticGroundPS:onAttach(attacherVehicle)

end;

function ExtraStaticGroundPS:onDetach()
end;

function ExtraStaticGroundPS:onLeave()
end;




