--
-- Implement depth control
-- Specialization to control implement depth.
--
-- @author  	PeterJ - FS_UK modteam
-- @version 	v1.0
-- @date  		07/11/2011
-- @version 	v1.1
-- @date  		13/11/2012
--

depthControl = {};

function depthControl.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations);
end;

function depthControl:load(xmlFile)

	self.setLoweredMax = SpecializationUtil.callSpecializationsFunction("setLoweredMax");
	self.LoweredMaxAnimation = getXMLString(xmlFile, "vehicle.loweredMax#animationName");
	self.LoweredMaxOn = false;
	self.firstTime = true;
	
end;

function depthControl:readStream(streamId, connection)
    self:setLoweredMax(streamReadBool(streamId), true);
end;

function depthControl:writeStream(streamId, connection)
	streamWriteBool(streamId, self.LoweredMax);
end;

function depthControl:delete()
end;

function depthControl:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local LoweredMax = getXMLBool(xmlFile, key.."#maxDepth");
	if LoweredMax ~= nil then
		self:setLoweredMax(LoweredMax);
		self.firstTime = false;
	end;
	return BaseMission.VEHICLE_LOAD_OK;
end;
  
function depthControl:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'maxDepth="'..tostring(self.isLoweredMaxOn)..'"';
	return attributes, nil;
end;

function depthControl:mouseEvent(posX, posY, isDown, isUp, button)
end;

function depthControl:keyEvent(unicode, sym, modifier, isDown)
end;

function depthControl:update(dt)
end;

function depthControl:updateTick(dt)
	if self:getIsActive() then
		if self:isLowered(false) then
			if self.lastMovedDistance > 0.1 then
				if self.movingDirection == -1 then
					if self.isLoweredMaxOn then
						self:setLoweredMax(not self.isLoweredMaxOn);
					end;
				else
					self:setLoweredMax(true);
				end;
			end;
		else
			if self.isLoweredMaxOn then
				self:setLoweredMax(not self.isLoweredMaxOn);	
			end;
		end;
	end;

	if self.firstTime then
		self:setLoweredMax(false);
		self.firstTime = false;
	end;
end;

function depthControl:draw()
end;

function depthControl:onAttach(attacherVehicle)
end;
 
function depthControl:onDetach()
end;

function depthControl:setLoweredMax(isLoweredMax,noEventSend)
	SetLoweredMaxEvent.sendEvent(self, isLoweredMax, noEventSend);
	-- Play LoweredMax animation --
	self.isLoweredMaxOn = isLoweredMax;
	if self.isLoweredMaxOn then
		if self.LoweredMaxAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.LoweredMaxAnimation, -1, nil, true);
			self.LoweredMax = true;
		end;
	else
		if self.LoweredMaxAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.LoweredMaxAnimation, 0.5, nil, true);
			self.LoweredMax = false;
		end;
	end;	
end;

SetLoweredMaxEvent = {};
SetLoweredMaxEvent_mt = Class(SetLoweredMaxEvent, Event);

InitEventClass(SetLoweredMaxEvent, "SetLoweredMaxEvent");

function SetLoweredMaxEvent:emptyNew()
    local self = Event:new(SetLoweredMaxEvent_mt);
    self.className="SetLoweredMaxEvent";
    return self;
end;

function SetLoweredMaxEvent:new(vehicle, isLoweredMax)
    local self = SetLoweredMaxEvent:emptyNew()
    self.vehicle = vehicle;
	self.isLoweredMax = isLoweredMax;
    return self;
end;

function SetLoweredMaxEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isLoweredMax = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetLoweredMaxEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isLoweredMax);
end;

function SetLoweredMaxEvent:run(connection)   
	self.vehicle:setLoweredMax(self.isLoweredMax, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetLoweredMaxEvent:new(self.vehicle, self.isLoweredMax), nil, connection, self.vehicle);
    end;
end;

function SetLoweredMaxEvent.sendEvent(vehicle, isLoweredMax, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetLoweredMaxEvent:new(vehicle, isLoweredMax), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetLoweredMaxEvent:new(vehicle, isLoweredMax));
		end;
	end;
end;
