--@ DIM_DIM [LSSA Modding Team]
--@ 21.01.13
--@ http://lssa.ru/

stock = {};


function stock:loadMap(name)

	self.numstations = 0;
	self.numfruits = 0;
	self.visible = {};
	self.showstat=false;
	self.farmtrigger = {};
	self.farmnum = 0;
	local i = 1;
	local cnt = true;
	local fruitcnt = 0;
	
	table.foreach(g_currentMission.tipTriggers,function (k)  
		if k.isFarmTrigger then
		
			for b=1, FruitUtil.NUM_FRUITTYPES do
				local c=k.acceptedFillTypes[b];
				if self.farmnum>=1 then
						for d=1, self.farmnum do
							if self.farmtrigger[d]~=b then
								fruitcnt=fruitcnt+1;
							end;	
						end;
					if fruitcnt==self.farmnum then
						fruitcnt=0;
						self.farmnum=self.farmnum+1;
						self.farmtrigger[self.farmnum]=b;
					else
						fruitcnt=0;
					end;	
				else
					self.farmnum=self.farmnum+1;
					self.farmtrigger[self.farmnum]=b;
				end;
			end;
		end;	
		i = i + 1;
	end)

	--local tmp=self.numfruits;
	--for a=1, self.numfruits do
		--if not self.visible[a] then
		  --tmp=tmp-1;
		--end;
	--end;
	
	--self.numfruits=tmp;
	self.HudInfoWidth=0.15/(self.numstations+2);
	self.subHudBack = Utils.getFilename("mods/Falumap_v3_edit_mj111/culture/HUD.dds", getUserProfileAppPath());
	self.subHudInfoPoxX = 0.03;
    --self.subHudInfoPoxY = 0.8; --   1.Zeichen von oben nach unten	
	self.subHudBackPoxX = 0.02;
	self.subHudBackWidth = 0.2; --
	self.subHudBackPoxY = 0.55-((0.105+(self.farmnum*0.026))/2); --0.55-((0.255+(self.numfruits*0.028))/2);
	self.subHudBackHeight = ((0.105+(self.farmnum*0.026)));  --((0.365+(self.numfruits*0.028)));
	self.subHudInfoPoxY = 0.55+((0.105+(self.farmnum*0.026))/2)-0.055;  --0.65+((0.305+(self.numfruits*0.028))/2)-0.055;

	stock.hud = Overlay:new("hud", self.subHudBack, stock.subHudBackPoxX, stock.subHudBackPoxY, stock.subHudBackWidth, stock.subHudBackHeight);

	self.loadedMap = name;
end;

function stock:deleteMap()
end;

function stock:update(dt)

	if InputBinding.hasEvent(InputBinding.TOGGLE_PDA) then 
		if not self.showstat then
			if g_currentMission.missionPDA.showPDA and g_currentMission.missionPDA.screen==5 then
				self.showstat = true;
				g_currentMission.missionPDA.showPDA = true;				
			end;
		else
			self.showstat = false;
			g_currentMission.missionPDA.showPDA = true;
		end;		
	end; 
end;

function stock:mouseEvent(posX, posY, isDown, isUp, button)
end;

function stock:keyEvent(unicode, sym, modifier, isDown) 
end;

function stock:draw()

	local fontsizecaption1= 0.03; --  
	local fontsize= 0.02; --  
	local linehigh=0.02; --   
	local line=0.026; --  

	if self.showstat then		
		self.hud:render();
		setTextBold(true);
		setTextColor(0,1,0,1);
		renderText(self.subHudInfoPoxX, self.subHudInfoPoxY , fontsizecaption1, g_i18n:getText("In_stock"));
		setTextBold(false);
		local linenum=0 ;
		for i=1, self.farmnum do
			if self.farmtrigger[i]~=nil then
				linenum=linenum+1;
				local j=self.farmtrigger[i];
				local fruitname = g_i18n:getText(FruitUtil.fruitIndexToDesc[i].name);
				local silofruit = Utils.getNoNil(g_currentMission.missionStats.farmSiloAmounts[FruitUtil.fruitTypeToFillType[i]],0);
				--
				setTextBold(false);
				setTextColor(1,1,1,1);
				renderText(self.subHudInfoPoxX, self.subHudInfoPoxY-linehigh-(line*linenum), fontsize,""..string.format("%s: ", fruitname).."");
				--
				renderText(self.subHudInfoPoxX+(1.3*self.HudInfoWidth), self.subHudInfoPoxY-linehigh-(line*linenum), fontsize,""..string.format("%.0f ", silofruit).." kg");
			end;	
		end;		
	end;
end;

function stock:delete()
	if self.hud ~= nil then
		self.hud:delete();
	end; 
end;

addModEventListener(stock);


