-- Rolltor
-- @author: grafik-edv
-- @date: 12.12.2012

   
  Rolltor = {};
  
  local Rolltor_mt = Class(Rolltor);
  
  function Rolltor.onCreate(id)
      g_currentMission:addUpdateable(Rolltor:new(id));
      --print("created tip trigger, id: ", id);
  end;
  
  function Rolltor:new(id, customMt)
  
      local instance = {};
      if customMt ~= nil then
          setmetatable(instance, customMt);
      else
          setmetatable(instance, Rolltor_mt);
      end;
  
      instance.triggerId = id;
      addTrigger(id, "triggerCallback", instance);
  
      instance.barriers = {};
      
      local num = getNumOfChildren(id);
      for i=0, num-1 do
          local childLevel1 = getChildAt(id, i);
          if childLevel1 ~= 0 and getNumOfChildren(id) >= 1 then
              local barrierId = getChildAt(childLevel1, 0);
              if barrierId ~= 0 then
                  table.insert(instance.barriers, barrierId);
              end;
          end;
      end;
  
      instance.isEnabled = true;
  
      self.count = 0;
  
      self.trans = 0;
      self.maxTrans = 14;
      self.minTrans = 0;
  
      return instance;
  end;
  
  function Rolltor:delete()
 
      removeTrigger(self.triggerId);
  end;
  
  function Rolltor:update(dt)
      
      local old = self.trans;
      if self.count > 0 then
          if self.trans < self.maxTrans then
              self.trans = self.trans + dt*0.010;    
          end;
     else
          if self.trans > self.minTrans then
              self.trans = self.trans - dt*0.005;    
          end;
      end;
      
      if old ~= self.trans then
          for i=1, table.getn(self.barriers) do
              setTranslation(self.barriers[i], self.trans, 0, 0);
          end;
      end;
      
  end;
  
  function Rolltor:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay)
  
      if onEnter and self.isEnabled then
          self.count = self.count + 1;
      elseif onLeave then
         self.count = self.count - 1;
      end; 
  end;
    
g_onCreateUtil.addOnCreateFunction("RolltorOnCreate", Rolltor.onCreate);




-- Tor_Kuhstall
-- @author: grafik-edv
-- @date: 12.12.2012

   
  Tor_Kuhstall = {};
  
  local Tor_Kuhstall_mt = Class(Tor_Kuhstall);
  
  function Tor_Kuhstall.onCreate(id)
      g_currentMission:addUpdateable(Tor_Kuhstall:new(id));
      --print("created tip trigger, id: ", id);
  end;
  
  function Tor_Kuhstall:new(id, customMt)
  
      local instance = {};
      if customMt ~= nil then
          setmetatable(instance, customMt);
      else
          setmetatable(instance, Tor_Kuhstall_mt);
      end;
  
      instance.triggerId = id;
      addTrigger(id, "triggerCallback", instance);
  
      instance.barriers = {};
      
      local num = getNumOfChildren(id);
      for i=0, num-1 do
          local childLevel1 = getChildAt(id, i);
          if childLevel1 ~= 0 and getNumOfChildren(id) >= 1 then
              local barrierId = getChildAt(childLevel1, 0);
              if barrierId ~= 0 then
                  table.insert(instance.barriers, barrierId);
              end;
          end;
      end;
  
      instance.isEnabled = true;
  
      self.count = 0;
  
      self.trans = 0;
      self.maxTrans = 4.1;
      self.minTrans = 0;
  
      return instance;
  end;
  
  function Tor_Kuhstall:delete()
 
      removeTrigger(self.triggerId);
  end;
  
  function Tor_Kuhstall:update(dt)
      
      local old = self.trans;
      if self.count > 0 then
          if self.trans < self.maxTrans then
              self.trans = self.trans + dt*0.003;    
          end;
     else
          if self.trans > self.minTrans then
              self.trans = self.trans - dt*0.003;    
          end;
      end;
      
      if old ~= self.trans then
          for i=1, table.getn(self.barriers) do
              setTranslation(self.barriers[i], self.trans, 0, 0);
          end;
      end;
      
  end;
  
  function Tor_Kuhstall:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay)
  
      if onEnter and self.isEnabled then
          self.count = self.count + 1;
      elseif onLeave then
         self.count = self.count - 1;
      end; 
  end;
    
g_onCreateUtil.addOnCreateFunction("Tor_KuhstallOnCreate", Tor_Kuhstall.onCreate);







-- Torklein_Kuhstall
-- @author: grafik-edv
-- @date: 12.12.2012

   
  Torklein_Kuhstall = {};
  
  local Torklein_Kuhstall_mt = Class(Torklein_Kuhstall);
  
  function Torklein_Kuhstall.onCreate(id)
      g_currentMission:addUpdateable(Torklein_Kuhstall:new(id));
      --print("created tip trigger, id: ", id);
  end;
  
  function Torklein_Kuhstall:new(id, customMt)
  
      local instance = {};
      if customMt ~= nil then
          setmetatable(instance, customMt);
      else
          setmetatable(instance, Torklein_Kuhstall_mt);
      end;
  
      instance.triggerId = id;
      addTrigger(id, "triggerCallback", instance);
  
      instance.barriers = {};
      
      local num = getNumOfChildren(id);
      for i=0, num-1 do
          local childLevel1 = getChildAt(id, i);
          if childLevel1 ~= 0 and getNumOfChildren(id) >= 1 then
              local barrierId = getChildAt(childLevel1, 0);
              if barrierId ~= 0 then
                  table.insert(instance.barriers, barrierId);
              end;
          end;
      end;
  
      instance.isEnabled = true;
  
      self.count = 0;
  
      self.trans = 0;
      self.maxTrans = 3.7;
      self.minTrans = 0;
  
      return instance;
  end;
  
  function Torklein_Kuhstall:delete()
 
      removeTrigger(self.triggerId);
  end;
  
  function Torklein_Kuhstall:update(dt)
      
      local old = self.trans;
      if self.count > 0 then
          if self.trans < self.maxTrans then
              self.trans = self.trans + dt*0.003;    
          end;
     else
          if self.trans > self.minTrans then
              self.trans = self.trans - dt*0.003;    
          end;
      end;
      
      if old ~= self.trans then
          for i=1, table.getn(self.barriers) do
              setTranslation(self.barriers[i], self.trans, 0, 0);
          end;
      end;
      
  end;
  
  function Torklein_Kuhstall:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay)
  
      if onEnter and self.isEnabled then
          self.count = self.count + 1;
      elseif onLeave then
         self.count = self.count - 1;
      end; 
  end;
    
g_onCreateUtil.addOnCreateFunction("Torklein_KuhstallOnCreate", Torklein_Kuhstall.onCreate);









































































PDAMod = {};

function PDAMod:consoleCommandPDAMod(newBool)
    --if newBool ~= nil then
        PDAMod.Stop = not PDAMod.Stop;
    --end;
    return "StopPDAMod = "..tostring(PDAMod.Stop);
end;
addConsoleCommand("StopPDAMod", "For debugging", "consoleCommandPDAMod", PDAMod);

function PDAMod:loadMap(name)
    PDAMod.mpStations = {};
    PDAMod.mpSellableFruits = {};
    PDAMod.stationOffset = 1;
    PDAMod.fruitOffset = 1;
    PDAMod.currentFruitSubPage = 1;
    PDAMod.numOfFruitSubPages = 0;
    PDAMod.fruitsPerPage = 9;
    --
    PDAMod.mpFarmSiloFillTypes = {};
    PDAMod.farmsiloOffset = 1;
    PDAMod.currentFarmsiloSubPage = 1;
    PDAMod.numOfFarmsiloSubPages = 0;
    PDAMod.farmsilosPerPage = 9;

    -- Determine what stations there are and what they accept. Also figure out what farm-triggers(silos) are available.
    local stations = {};
    local sellable = {};
    local farmsilo = {};
    for k,tipTrig in pairs(g_currentMission.tipTriggers) do
        if (tipTrig.appearsOnPDA) and (stations[tipTrig.stationName] ~= true) then   -- Make sure we do not include the same stationName again.
            for fruitIndex=1,  Fillable.NUM_FILLTYPES do
                if (tipTrig.acceptedFillTypes[fruitIndex]) then
                    sellable[fruitIndex] = true;
                end;
            end;
            stations[tipTrig.stationName] = true;
            table.insert(PDAMod.mpStations, tipTrig);
        end;
        if (tipTrig.isFarmTrigger) then
            for fruitIndex=1,  Fillable.NUM_FILLTYPES do
                if (tipTrig.acceptedFillTypes[fruitIndex]) then
                    farmsilo[fruitIndex] = true;
                end;
            end;
        end;
    end;
    -- Maybe not optimal sort-code, with all the g_i18n-calls, but this table.sort() probably is only called once when map is loaded.
    table.sort(PDAMod.mpStations, function(l,r)
        local lName = l.stationName;
        local rName = r.stationName;
        if (g_i18n:hasText(lName)) then lName = g_i18n:getText(lName); end;
        if (g_i18n:hasText(rName)) then rName = g_i18n:getText(rName); end;
        return (lName < rName);  -- TODO, need localization-comparsion.
        end
    );
    -- Only sellable types should be shown in the PDA, so we do not get any "blank lines".
    for fruitIndex,isSellable in pairs(sellable) do
        if isSellable then
            table.insert(PDAMod.mpSellableFruits, fruitIndex);
        end;
    end;
    --
    PDAMod.numOfFruitSubPages = math.ceil(table.getn(PDAMod.mpSellableFruits) / PDAMod.fruitsPerPage) * math.ceil(table.getn(PDAMod.mpStations) / 2);
	
	if g_languageShort == "de" then
		 g_i18n:setText("millet","Hirse")
		 g_i18n:setText("rye","Roggen")
		 g_i18n:setText("dinkel","Dinkel")
		 g_i18n:setText("oat","Hafer")
		 g_i18n:setText("sunflower","Sonnenblume")
	end
    --
    
end;

function PDAMod:deleteMap()
end;

function PDAMod:mouseEvent(posX, posY, isDown, isUp, button)
end;

function PDAMod:keyEvent(unicode, sym, modifier, isDown)
end;

function PDAMod:update(dt)
	
		
	if not PDAMod.hookPDA then
		PDAMod.hookPDA = true;
		
		if MissionPDA.draw ~= nil then
			local orgdraw = MissionPDA.draw;
			MissionPDA.draw = function(a, b, c, d)
				if (g_currentMission.missionPDA.screen ~= 4) or PDAMod.Stop then
					orgdraw(a, b, c, d);
				else
					g_currentMission.missionPDA.hudPDABackgroundOverlay:render();
					
					local y = g_currentMission.missionPDA.pdaHeadRow
					
					if (PDAMod.stationOffset > table.getn(PDAMod.mpStations)) then
						-- Draw the greatDemands
						setTextColor(1, 1, 1.0, 1.0);
						setTextAlignment(RenderText.ALIGN_LEFT);
						setTextBold(true);
						renderText(
							g_currentMission.missionPDA.pdaPricesCol[1],
							y,
							g_currentMission.missionPDA.pdaFontSize,
							g_i18n:getText("PDATitleGreatDemands")
						);
						y = y - (g_currentMission.missionPDA.pdaRowSpacing * 2);
						setTextBold(false);
						local greatDemands = g_currentMission.economyManager.greatDemands
						local find = false
						for i=1,table.getn(greatDemands) do
							if greatDemands[i].isRunning then
								find = true
								local stationName = greatDemands[i].stationName;
								if g_i18n:hasText(stationName) then
									stationName = g_i18n:getText(stationName);
								end;
								renderText(
									g_currentMission.missionPDA.pdaPricesCol[1],
									y,
									g_currentMission.missionPDA.pdaFontSize,
									stationName
								);
								local t = Fillable.fillTypeIndexToDesc[greatDemands[i].fillTypeIndex].nameI18N
								t = t..string.format(" x%.1f",greatDemands[i].demandMultiplier)
								renderText(
									g_currentMission.missionPDA.pdaPricesCol[2],
									y,
									g_currentMission.missionPDA.pdaFontSize,
									t
								);
								renderText(
									g_currentMission.missionPDA.pdaPricesCol[3],
									y,
									g_currentMission.missionPDA.pdaFontSize,
									string.format(g_i18n:getText("PDAGreatDemandTimeRemaining"),greatDemands[i].demandDuration)
								);
								y = y - g_currentMission.missionPDA.pdaRowSpacing;
							end
						end
						if not find then
							renderText(
								g_currentMission.missionPDA.pdaPricesCol[1],
								y,
								g_currentMission.missionPDA.pdaFontSize,
								g_i18n:getText("PDANoGreatDemands")
							);
						end
					else
						-- Draw the stations
						setTextColor(1, 1, 1.0, 1.0);
						setTextAlignment(RenderText.ALIGN_LEFT);
						setTextBold(true);
						local xCol=2;
						for j=PDAMod.stationOffset, math.min(PDAMod.stationOffset+1, table.getn(PDAMod.mpStations)) do
							local stationName = PDAMod.mpStations[j].stationName;
							if g_i18n:hasText(stationName) then
								stationName = g_i18n:getText(stationName);
							end;
							renderText(
								g_currentMission.missionPDA.pdaPricesCol[xCol],
								y,
								g_currentMission.missionPDA.pdaFontSize,
								stationName
							);
							xCol = xCol + 1;
						end;
						y = y - g_currentMission.missionPDA.pdaRowSpacing;

						-- Draw the fruits and their prices for the stations
						local factor = 4000;
						if g_currentMission.missionStats.difficulty>=3 then
							factor = 1000;
						elseif g_currentMission.missionStats.difficulty>=2 then
							factor = 2000;
						end;
						local pricePerTon = g_i18n:getText("PricePerTon");
						setTextBold(false);
						local PriceArrow = 1
						for i=PDAMod.fruitOffset, math.min(PDAMod.fruitOffset+(PDAMod.fruitsPerPage-1), table.getn(PDAMod.mpSellableFruits)) do
							local fruitIndex = PDAMod.mpSellableFruits[i];
							local fruitName = Fillable.fillTypeIndexToDesc[fruitIndex].name;
							if g_i18n:hasText(fruitName) then
								fruitName = g_i18n:getText(fruitName);
							else
								fruitName = Fillable.fillTypeIndexToDesc[fruitIndex].nameI18N
							end;
							fruitName = fruitName.." "..pricePerTon;
							setTextAlignment(RenderText.ALIGN_LEFT);
							renderText(
								g_currentMission.missionPDA.pdaPricesCol[1],
								y,
								g_currentMission.missionPDA.pdaFontSize,
								fruitName
							);
							xCol=2;
							local difficultyMultiplier = math.max(2 * (3 - g_currentMission.missionStats.difficulty), 1); -- 1  2  4
							local price = Fillable.fillTypeIndexToDesc[fruitIndex].pricePerLiter * difficultyMultiplier;
							for j=PDAMod.stationOffset, math.min(PDAMod.stationOffset+1, table.getn(PDAMod.mpStations)) do
								if PDAMod.mpStations[j].acceptedFillTypes[fruitIndex] then
									local greatDemands = g_currentMission.economyManager.greatDemands
									local price2 = price * PDAMod.mpStations[j].priceMultipliers[fruitIndex]
									for i=1,table.getn(greatDemands) do
										if greatDemands[i].isRunning then
											if greatDemands[i].fillTypeIndex == fruitIndex and greatDemands[i].stationName == PDAMod.mpStations[j].stationName then
												setTextColor(0.2, 1.0, 0.2, 1.0)
												price2 = price2 * greatDemands[i].demandMultiplier;
											end
										end
									end
									price2 = math.ceil(price2 * 1000)
									renderText(
										g_currentMission.missionPDA.pdaPricesCol[xCol], --+ 0.05,
										y,
										g_currentMission.missionPDA.pdaFontSize,
										string.format("%d", price2)
									);
									setTextColor(1.0, 1, 1, 1.0)
								end;
								xCol = xCol + 1;
							end;
							if (Fillable.fillTypeIndexToDesc[fruitIndex].pricePerLiter < Fillable.fillTypeIndexToDesc[fruitIndex].previousHourPrice) then
								g_currentMission.missionPDA.pdaPriceArrows[PriceArrow]:setImage(g_currentMission.missionPDA.priceArrowDown)
							elseif (Fillable.fillTypeIndexToDesc[fruitIndex].pricePerLiter > Fillable.fillTypeIndexToDesc[fruitIndex].previousHourPrice) then
								g_currentMission.missionPDA.pdaPriceArrows[PriceArrow]:setImage(g_currentMission.missionPDA.priceArrowUp)
							else
								g_currentMission.missionPDA.pdaPriceArrows[PriceArrow]:setImage(g_currentMission.missionPDA.priceArrowFlat)
							end;
							g_currentMission.missionPDA.pdaPriceArrows[PriceArrow].x = g_currentMission.missionPDA.pdaPricesCol[4]
							
							g_currentMission.missionPDA.pdaPriceArrows[PriceArrow]:render();
							PriceArrow = PriceArrow + 1
							
							y = y - g_currentMission.missionPDA.pdaRowSpacing;
						end;
					end
					-- Draw page#-of-pages
					setTextAlignment(RenderText.ALIGN_RIGHT)
					renderText(
						g_currentMission.missionPDA.pdaCoordsXPos + 0.004,
						g_currentMission.missionPDA.pdaCoordsYPos - 0.002,
						g_currentMission.missionPDA.pdaFontSize - 0.002,
						string.format("%d/%d", PDAMod.currentFruitSubPage, PDAMod.numOfFruitSubPages+1)
					);
					setTextAlignment(RenderText.ALIGN_LEFT);
					
					-- Render the frame
					g_currentMission.missionPDA.hudPDAFrameOverlay:render();

					-- Draw screen-title (with black shadow)
					setTextBold(true);
					setTextColor(0,0,0, 1); -- Black
					renderText(
						g_currentMission.missionPDA.pdaTitleX - 0.001,
						g_currentMission.missionPDA.pdaTitleY - 0.002,
						g_currentMission.missionPDA.pdaTitleTextSize,
						g_currentMission.missionPDA.textTitles[4]
					);
					setTextColor(1,1,1, 1); -- White
					renderText(
						g_currentMission.missionPDA.pdaTitleX,
						g_currentMission.missionPDA.pdaTitleY,
						g_currentMission.missionPDA.pdaTitleTextSize,
						g_currentMission.missionPDA.textTitles[4]
					);
					
					g_currentMission:addHelpButtonText(g_i18n:getText("PDAShowNextScreen"), InputBinding.TOGGLE_PDA);
					g_currentMission:addHelpButtonText(g_i18n:getText("PDAShowNextStations"), InputBinding.TOGGLE_PDA_ZOOM);
					
					if InputBinding.hasEvent(InputBinding.TOGGLE_PDA_ZOOM) then
						PDAMod.fruitOffset = PDAMod.fruitOffset + PDAMod.fruitsPerPage;
						PDAMod.currentFruitSubPage = PDAMod.currentFruitSubPage + 1;
						if (PDAMod.fruitOffset > table.getn(PDAMod.mpSellableFruits)) or PDAMod.currentFruitSubPage > PDAMod.numOfFruitSubPages+1 then
							PDAMod.fruitOffset = 1;
							PDAMod.stationOffset = PDAMod.stationOffset + 2;
							if (PDAMod.stationOffset > table.getn(PDAMod.mpStations)+2) then
								PDAMod.stationOffset = 1;
								PDAMod.currentFruitSubPage = 1;
							end;
						end;
						playSample(g_currentMission.missionPDA.pdaBeepSound, 1, 0.5, 0);
					end;
				end 
			end;
		end;
			
	end;
		
end;

function PDAMod:updateTick(dt)
end;

function PDAMod:draw()
end;

addModEventListener(PDAMod);
