--WaagePlaceable.lua
--
--@Autor: Alex2009(www.Alex2009.de)
--
--Modifizierung erst nach rcksprache mit mir(Alex2009) erlaubt.
--Modification allowed back only after consultation with me(Alex2009).

WaagePlaceable = {};
WaagePlaceable_mt = Class(WaagePlaceable, Placeable);
InitObjectClass(WaagePlaceable, "WaagePlaceable");

function WaagePlaceable:new(isServer, isClient, customMt)
    local self = Placeable:new(isServer, isClient, WaagePlaceable_mt);
    registerObjectClassName(self, "WaagePlaceable");
    return self;
end;

function WaagePlaceable:delete()
    removeTrigger(self.trigger);
    self.active = false;
    unregisterObjectClassName(self);
    WaagePlaceable:superClass().delete(self);
end;

function WaagePlaceable:deleteFinal()
    WaagePlaceable:superClass().deleteFinal(self);
end;

function WaagePlaceable:load(xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom)
    if not WaagePlaceable:superClass().load(self, xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom) then
        return false;
    end;
    self.active = false;
    if not moveMode then  
        self.active = true;
        self.trigger = Utils.indexToObject(self.nodeId,"0");
        addTrigger(self.trigger, "triggerCallback", self);
        
        self.masse = 0;
        self.WaageVehicles = {};
        self.WaageTrailer = {};
        
        local bb = Utils.indexToObject(self.nodeId,"1|3");
        local cc = Utils.indexToObject(self.nodeId,"1|2");
        local dd = Utils.indexToObject(self.nodeId,"1|1");
        local ee = Utils.indexToObject(self.nodeId,"1|0");
        self.Nummern = {};
        for ii = 0, 3, 1 do
            table.insert(self.Nummern,ii,{});
            for i = 0, 9, 1 do
                local object = bb;
                if ii == 0 then
                    object = bb;
                elseif ii == 1 then
                    object = cc;
                elseif ii == 2 then
                    object = dd;
                else
                    object = ee;
                end;
                table.insert(self.Nummern[ii],i,{Utils.indexToObject(object,tostring(i))});
                setVisibility(self.Nummern[ii][i][1],false);
            end;
        end;
    end;
    return true;
end;

function WaagePlaceable:update(dt)
    if self.active then
        local masse = string.format("%.2f",self.masse);
        if self.masse > 99.99 then
            masse = "99.99";
        end;
        if self.masse < 10 then
            masse = "0"..masse;
        end;
        local numbers = {"0","0","0","0"};
        for i = 1, 4, 1 do
            local ii = i;
            if(ii > 2) then
                ii = (ii+1)
            end;
            numbers[i] = string.sub(masse,ii,ii);
            
        end;
        for i = 0, 3, 1 do
            for ii = 0, 9, 1 do
                if (tostring(ii) == numbers[(i+1)]) then
                    setVisibility(self.Nummern[i][ii][1], true);
                else
                    setVisibility(self.Nummern[i][ii][1], false);
                end;
            end;
        end;
    end;
end;

function WaagePlaceable:triggerCallback(triggerId,otherId,onEnter,onLeave,onStay)
    if self.active then
        if onEnter then
            local vehicle = g_currentMission.nodeToVehicle[otherId];
            if vehicle ~= nil and self.WaageVehicles[vehicle] == nil then
                self.masse = self.masse + getMass(vehicle.components[1].node);
                self.WaageVehicles[vehicle] = 1;
            end;
            local trailer = g_currentMission.objectToTrailer[otherShapeId];
            if trailer ~= nil and self.WaageTrailer[trailer] == nil then
                if trailer.fillLevel ~= nil and (trailer.fillLevel/1000) ~= 0 then
                    self.masse = self.masse + (trailer.fillLevel/1000);
                end;
                self.WaageTrailer[trailer] = 1;
            end;
        elseif onLeave then
            local vehicle = g_currentMission.nodeToVehicle[otherId];
            if vehicle ~= nil and self.WaageVehicles[vehicle] ~= nil then
                self.masse = math.max((self.masse - getMass(vehicle.components[1].node)),0);
                self.WaageVehicles[vehicle] = nil;
            end;
            local trailer = g_currentMission.objectToTrailer[otherShapeId];
            if trailer ~= nil and self.WaageTrailer[trailer] ~= nil then
                if trailer.fillLevel ~= nil and (trailer.fillLevel/1000) ~= 0 then
                    self.masse = math.max((self.masse - (trailer.fillLevel/1000)),0);
                end;
                self.WaageTrailer[trailer] = nil;
            end;
        end;
    end;
end;
registerPlaceableType("WaagePlaceable", WaagePlaceable);