--
-- Agovi Transport Trailer
-- Class for all foldable drop bed trailer
--
-- @author  PeterJ - FS-UK modteam
-- @date  13/11/12
--
-- Copyright (C) FS-UK modteam, Confidential, All Rights Reserved.

AgoviTT = {};

function AgoviTT.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Foldable, specializations);
end;


function AgoviTT:load(xmlFile)

	self.setmoveSupport = SpecializationUtil.callSpecializationsFunction("setmoveSupport");
	self.MoveSupportAnimation = getXMLString(xmlFile, "vehicle.moveSupportDB#animationName");
	self.moveSupport = false;
	
end;

function AgoviTT:delete()
end;

function AgoviTT:readStream(streamId, connection)
	self:setmoveSupport(streamReadBool(streamId), true);	
end;

function AgoviTT:writeStream(streamId, connection)
	streamWriteBool(streamId, self.moveSupport);	
end;

function AgoviTT:mouseEvent(posX, posY, isDown, isUp, button)
end;

function AgoviTT:keyEvent(unicode, sym, modifier, isDown)
end;

function AgoviTT:update(dt)
end;

function AgoviTT:updateTick(dt)

	if self:getIsActive() and self.isClient then
		for i, jointDesc in pairs(self.componentJoints) do
		   setJointFrame(self.componentJoints[i].jointIndex, 0, self.componentJoints[i].jointNode);
		end;
	end;
	
	if self.attacherVehicle then
		for k, implement in pairs(self.attacherVehicle.attachedImplements) do
			if implement.object == self then
				local index = implement.jointDescIndex;
				self.attacherVehicleJoint = self.attacherVehicle.attacherJoints[index];
				setJointRotationLimit(self.attacherVehicleJoint.jointIndex, 2, true, Utils.degToRad(-20), Utils.degToRad(20));
			end;
		end;
	end;	
end;

function AgoviTT:draw()
end;

function AgoviTT:onDetach()
	self.isTurnedOn = false;

	if self.foldAnimTime < 0.1 then
		self:setmoveSupport(false);
	else
		self:setmoveSupport(true);		
	end;
end;

function AgoviTT:onAttach(attacherVehicle)
	self:setmoveSupport(true);
end;

function AgoviTT:validateAttacherJoint(implement, jointDesc, dt)
	return true;
end;

function AgoviTT:setmoveSupport(ismoveSupport,noEventSend)
	setmoveSupportEvent.sendEvent(self, ismoveSupport, noEventSend);
	-- Play moveSupport animation --
	self.ismoveSupportOn = ismoveSupport;
	if self.ismoveSupportOn then
		if self.MoveSupportAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.MoveSupportAnimation, -1, nil, true);
			self.moveSupport = true;
		end;
	else
		if self.MoveSupportAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.MoveSupportAnimation, 1, nil, true);
			self.moveSupport = false;
		end;
	end;	
end;


setmoveSupportEvent = {};
setmoveSupportEvent_mt = Class(setmoveSupportEvent, Event);

InitEventClass(setmoveSupportEvent, "setmoveSupportEvent");

function setmoveSupportEvent:emptyNew()
    local self = Event:new(setmoveSupportEvent_mt);
    self.className="setmoveSupportEvent";
    return self;
end;

function setmoveSupportEvent:new(vehicle, ismoveSupport)
    local self = setmoveSupportEvent:emptyNew()
    self.vehicle = vehicle;
	self.ismoveSupport = ismoveSupport;
    return self;
end;

function setmoveSupportEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.ismoveSupport = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function setmoveSupportEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.ismoveSupport);
end;

function setmoveSupportEvent:run(connection)   
	self.vehicle:setmoveSupport(self.ismoveSupport, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(setmoveSupportEvent:new(self.vehicle, self.ismoveSupport), nil, connection, self.vehicle);
    end;
end;

function setmoveSupportEvent.sendEvent(vehicle, ismoveSupport, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(setmoveSupportEvent:new(vehicle, ismoveSupport), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(setmoveSupportEvent:new(vehicle, ismoveSupport));
		end;
	end;
end;
