﻿--
-- MB Actros4
-- Specialization class for MB Actros4
--
-- @author  Repi
-- @date  16/09/2013
--
-- Copyright (C) by Repi @RM-Modding, All Rights Reserved.

Actros4 = {};

function Actros4.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Actros4:load(xmlFile)
	self.tanklight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.tanklight#index"));
	self.tank2light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.tanklight#index2"));
	self.tanklightActive = false;
	self.tankwarn = 100;

	local rotationPartNodeDrehzahl1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartDrehzahl1#index"));
    if rotationPartNodeDrehzahl1 ~= nil then
        self.rotationPartDrehzahl1 = {};
        self.rotationPartDrehzahl1.node = rotationPartNodeDrehzahl1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartDrehzahl1#minRot"));
        self.rotationPartDrehzahl1.minRot = {};
        self.rotationPartDrehzahl1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartDrehzahl1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartDrehzahl1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartDrehzahl1#maxRot"));
        self.rotationPartDrehzahl1.maxRot = {};
        self.rotationPartDrehzahl1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartDrehzahl1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartDrehzahl1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartDrehzahl1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartDrehzahl1#rotTime"), 2)*1000;
        self.rotationPartDrehzahl1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartDrehzahl1#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeDrehzahl2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartDrehzahl2#index"));
    if rotationPartNodeDrehzahl2 ~= nil then
        self.rotationPartDrehzahl2 = {};
        self.rotationPartDrehzahl2.node = rotationPartNodeDrehzahl2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartDrehzahl2#minRot"));
        self.rotationPartDrehzahl2.minRot = {};
        self.rotationPartDrehzahl2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartDrehzahl2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartDrehzahl2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartDrehzahl2#maxRot"));
        self.rotationPartDrehzahl2.maxRot = {};
        self.rotationPartDrehzahl2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartDrehzahl2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartDrehzahl2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartDrehzahl2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartDrehzahl2#rotTime"), 2)*1000;
        self.rotationPartDrehzahl2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartDrehzahl2#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeKmh1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartKmh1#index"));
    if rotationPartNodeKmh1 ~= nil then
        self.rotationPartKmh1 = {};
        self.rotationPartKmh1.node = rotationPartNodeKmh1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKmh1#minRot"));
        self.rotationPartKmh1.minRot = {};
        self.rotationPartKmh1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKmh1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKmh1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKmh1#maxRot"));
        self.rotationPartKmh1.maxRot = {};
        self.rotationPartKmh1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKmh1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKmh1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartKmh1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKmh1#rotTime"), 2)*1000;
        self.rotationPartKmh1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKmh1#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeKmh2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartKmh2#index"));
    if rotationPartNodeKmh2 ~= nil then
        self.rotationPartKmh2 = {};
        self.rotationPartKmh2.node = rotationPartNodeKmh2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKmh2#minRot"));
        self.rotationPartKmh2.minRot = {};
        self.rotationPartKmh2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKmh2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKmh2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKmh2#maxRot"));
        self.rotationPartKmh2.maxRot = {};
        self.rotationPartKmh2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKmh2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKmh2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartKmh2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKmh2#rotTime"), 2)*1000;
        self.rotationPartKmh2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKmh2#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeTanknadel = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartTanknadel#index"));
    if rotationPartNodeTanknadel ~= nil then
        self.rotationPartTanknadel = {};
        self.rotationPartTanknadel.node = rotationPartNodeTanknadel;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#minRot"));
        self.rotationPartTanknadel.minRot = {};
        self.rotationPartTanknadel.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#maxRot"));
        self.rotationPartTanknadel.maxRot = {};
        self.rotationPartTanknadel.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartTanknadel.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#rotTime"), 2)*1000;
        self.rotationPartTanknadel.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeTanknadel2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartTanknadel2#index"));
    if rotationPartNodeTanknadel2 ~= nil then
        self.rotationPartTanknadel2 = {};
        self.rotationPartTanknadel2.node = rotationPartNodeTanknadel2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel2#minRot"));
        self.rotationPartTanknadel2.minRot = {};
        self.rotationPartTanknadel2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel2#maxRot"));
        self.rotationPartTanknadel2.maxRot = {};
        self.rotationPartTanknadel2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartTanknadel2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel2#rotTime"), 2)*1000;
        self.rotationPartTanknadel2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel2#touchRotLimit"), 10));
    end;

	fuelwarningSoundFile = Utils.getFilename("Sounds/fuelwarning.wav", self.baseDirectory);
    self.fuelwarningSoundId = createSample("fuelwarningSound");
    loadSample(self.fuelwarningSoundId, fuelwarningSoundFile, false);
    self.fuelwarningPlaying = false;
	
	self.drivingShaft = {};
	self.drivingShaft.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.drivingShaft#index"));
	self.drivingShaft.speedFactor = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.drivingShaft#speedFactor"), 2);
	
	self.setHandBrakeState = SpecializationUtil.callSpecializationsFunction("setHandBrakeState");
    self.handbrakelight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.handbrakelight#index"));
	
	self.handbrake = true;
	self.cos = 20000;
	self.druckLevel = 0;
    
	handbrakeSoundFile = Utils.getFilename("Sounds/handbrake.wav", self.baseDirectory);
    self.handbrakeSoundId = createSample("handbrakeSound");
    loadSample(self.handbrakeSoundId, handbrakeSoundFile, false);
    self.handbrakePlaying = false;
	
	brakeSoundFile = Utils.getFilename("Sounds/brake2.wav", self.baseDirectory);
    self.brakeSoundId = createSample("brakeSound");
    loadSample(self.brakeSoundId, brakeSoundFile, false);
    self.brakePlaying = false;
	
	brakereleaseSoundFile = Utils.getFilename("Sounds/brake.wav", self.baseDirectory);
    self.brakereleaseSoundId = createSample("brakereleaseSound");
    loadSample(self.brakereleaseSoundId, brakereleaseSoundFile, false);
    self.brakereleasePlaying = false;
		
	compressorSoundFile = Utils.getFilename("Sounds/compressor.wav", self.baseDirectory);
    self.compressorSoundId = createSample("compressorSound");
    loadSample(self.compressorSoundId, compressorSoundFile, false);
    self.compressorPlaying = false;
	
	compressorstopSoundFile = Utils.getFilename("Sounds/compressorstop.wav", self.baseDirectory);
    self.compressorstopSoundId = createSample("compressorstopSound");
    loadSample(self.compressorstopSoundId, compressorstopSoundFile, false);
    self.compressorstopPlaying = false;
    self.BreakForceVal = 10000/self.motor.brakeForce;
    
    local breamsDrucknadelIndex = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.bremsDruckNadel#index"));
    if breamsDrucknadelIndex ~= nil then
        self.bremsDruckNadel = {};
        self.bremsDruckNadel.node = breamsDrucknadelIndex;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.bremsDruckNadel#minRot"));
        self.bremsDruckNadel.minRot = {};
        self.bremsDruckNadel.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.bremsDruckNadel.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.bremsDruckNadel.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.bremsDruckNadel#maxRot"));
        self.bremsDruckNadel.maxRot = {};
        self.bremsDruckNadel.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.bremsDruckNadel.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.bremsDruckNadel.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.bremsDruckNadel.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.bremsDruckNadel#rotTime"), 2)*1000;
        self.bremsDruckNadel.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.bremsDruckNadel#touchRotLimit"), 10));
    end;
    self.HandBrakeTurnOff = false;
	
	self.rotors = {};
    local i = 0;
    while true do
        local key = string.format("vehicle.rotors.rotor(%d)", i);
        if not hasXMLProperty(xmlFile, key) then
             break;
        end;
        local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
        local speed = Utils.getNoNil(getXMLFloat(xmlFile, key.."#speed"),0.003);
        if node ~= nil then
            table.insert(self.rotors, {node=node,speed=speed});
        end;
        i = i + 1;
    end;

end;

function Actros4:delete()

end;

function Actros4:mouseEvent(posX, posY, isDown, isUp, button)

end;

function Actros4:keyEvent(unicode, sym, modifier, isDown)
    if isDown and sym == Input.KEY_KP_7 then
        self:setHandBrakeState(not self.handbrake);
		if self.handbrake and self:getIsActiveForSound() then
			playSample(self.handbrakeSoundId,1,1,0);
		end;
	end;
end;

function Actros4:updateTick(dt)
    if self.isServer then
        if self.handbrake then
            if self.isServer then
                for k,wheel in pairs(self.wheels) do
                    setWheelShapeProps(wheel.node, wheel.wheelShape, 0, 999, 0);
                end;
            end;
        elseif not self.handbrake and self.HandBrakeTurnOff then
            if self.isServer then
                for k,wheel in pairs(self.wheels) do
                    setWheelShapeProps(wheel.node, wheel.wheelShape, 0, 0, 0);
                end;
            end;
            self.HandBrakeTurnOff = false;
        end;
    end;
	
	if self.isMotorStarted then
        for _,v in pairs(self.rotors) do
            if v.node ~= nil then
                rotate(v.node,v.speed*dt,0,0)
            end;
        end;
	end;
end;

function Actros4:update(dt)
	if self.rotationPartTanknadel ~= nil then
		local x, y, z = getRotation(self.rotationPartTanknadel.node);
		y = ((self.rotationPartTanknadel.maxRot[2] - self.rotationPartTanknadel.minRot[2]) / self.fuelCapacity) * self.fuelFillLevel + self.rotationPartTanknadel.minRot[2];
		setRotation(self.rotationPartTanknadel.node, x, y ,z);
	end;
	
	if self.rotationPartTanknadel2 ~= nil then
		local x, y, z = getRotation(self.rotationPartTanknadel2.node);
		y = ((self.rotationPartTanknadel2.maxRot[2] - self.rotationPartTanknadel2.minRot[2]) / self.fuelCapacity) * self.fuelFillLevel + self.rotationPartTanknadel2.minRot[2];
		setRotation(self.rotationPartTanknadel2.node, x, y ,z);
	end;

	local maxDrehzahl = 3900;
	if self.rotationPartDrehzahl1 ~= nil then
		local x, y, z = getRotation(self.rotationPartDrehzahl1.node);
		y = ((self.rotationPartDrehzahl1.maxRot[2] - self.rotationPartDrehzahl1.minRot[2]) / maxDrehzahl) * self.motor.lastMotorRpm + self.rotationPartDrehzahl1.minRot[2];
		setRotation(self.rotationPartDrehzahl1.node, x, y ,z);
	end;
	if self.rotationPartDrehzahl2 ~= nil then
		local x, y, z = getRotation(self.rotationPartDrehzahl2.node);
		y = ((self.rotationPartDrehzahl2.maxRot[2] - self.rotationPartDrehzahl2.minRot[2]) / maxDrehzahl) * self.motor.lastMotorRpm + self.rotationPartDrehzahl2.minRot[2];
		setRotation(self.rotationPartDrehzahl2.node, x, y ,z);
	end;
	
	local maxKmh = 55;
	if self.rotationPartKmh1 ~= nil then
		local x, y, z = getRotation(self.rotationPartKmh1.node);
		y = ((self.rotationPartKmh1.maxRot[2] - self.rotationPartKmh1.minRot[2]) / maxKmh) * self.lastSpeed*3600 + self.rotationPartKmh1.minRot[2];
		setRotation(self.rotationPartKmh1.node, x, y ,z);
	end;
	if self.rotationPartKmh2 ~= nil then
		local x, y, z = getRotation(self.rotationPartKmh2.node);
		y = ((self.rotationPartKmh2.maxRot[2] - self.rotationPartKmh2.minRot[2]) / maxKmh) * self.lastSpeed*3600 + self.rotationPartKmh2.minRot[2];
		setRotation(self.rotationPartKmh2.node, x, y ,z);
	end;

	if self.isEntered then
		if self.fuelFillLevel < 50 then
			self.tankwarn = self.tankwarn - dt;
			if self.tankwarn <= 0 then
				playSample(self.fuelwarningSoundId,1,1,0);
				self.tankwarn = 30000;
			end;
			self.tanklightActive = true;
		else
			self.tankwarn = 30000;
			self.tanklightActive = false;
		end;
		setVisibility(self.tanklight,self.tanklightActive);
		setVisibility(self.tank2light,self.tanklightActive);
	end;
	
	if self:getIsActive() then		
		local x,y,z = getRotation(self.wheels[1].driveNode);
		setRotation(self.drivingShaft.node, 0 ,0, x*self.drivingShaft.speedFactor);	
	end;
	
	if self.isMotorStarted then        
		if Input.isKeyPressed(Input.KEY_s) then
			if self.druckLevel >= 3500 then
				if not self.braking then
					if self.attachedTrailer then
						self.druckLevel = self.druckLevel -500;
					else
						self.druckLevel = self.druckLevel -300;
					end;
					self.braking = true;
				end;
				if not self.brakePlaying and self:getIsActiveForSound() then
					playSample(self.brakeSoundId,1,1,0);
					self.brakePlaying = true;
				end;
				self.brakereleasePlaying = false;				
			end;
		else
			self.brakePlaying = false;
			self.braking = false;
			if not self.brakereleasePlaying and self:getIsActiveForSound() then
				playSample(self.brakereleaseSoundId,1,1,0);
				self.brakereleasePlaying = true;
			end;
		end;

		if self.fuelFillLevel < 50 then
			self.cos = self.cos - dt;
			if self.cos <= 0 and self:getIsActiveForSound() then
				playSample(self.brakereleaseSoundId,1,1,0);
				self.cos = 20000;
			end;
		else
			self.cos = 20000;
		end;
			
		if self.druckLevel >= -1 and self.druckLevel <= 6100 then
			self.compressorStart = true;
		end;
		if self.druckLevel >= 9999 then
			self.compressorStart = false;
		end;
		if self.compressorStart == true then
			if not self.compressorSoundRunning and self:getIsActiveForSound() then
				playSample(self.compressorSoundId, 0, 1, 0);
				self.compressorSoundRunning = true;
			end;
			self.compressorstopSoundRunning = false;
			if self.druckLevel <= 10000 then
				self.druckLevel = self.druckLevel +(dt/3);
			end;
		end;
		if self.compressorStart == false then
			stopSample(self.compressorSoundId, 0, 1, 0);
			self.compressorSoundRunning = false;
			if not self.compressorstopSoundRunning and self:getIsActiveForSound() then
				playSample(self.compressorStopSoundId, 1, 1, 0);
				self.compressorstopSoundRunning = true;
			end;
			if self.druckLevel >= 6099 then
				self.druckLevel = self.druckLevel -(dt/40);
			end;
		end;
		if self.druckLevel <= 6000 then
			self.druckWarning = true;
			self.drucklightActive = true;
		else
			self.druckWarning = false;
			self.drucklightActive = false;
		end;
        self.motor.brakeForce = (self.druckLevel/self.BreakForceVal);

        if self.bremsDruckNadel ~= nil then
            local x, y, z = getRotation(self.bremsDruckNadel.node);
            y = ((self.bremsDruckNadel.maxRot[2] - self.bremsDruckNadel.minRot[2]) / 10000) * self.druckLevel + self.bremsDruckNadel.minRot[2];
            setRotation(self.bremsDruckNadel.node, x, y ,z);
        end;
	end;
end;

function Actros4:draw()
    if self.isEntered then
		if self.handbrake then
			setTextBold(true);
			setTextColor(1,0,0,1);
			if Input.isKeyPressed(Input.KEY_w) then
				setTextBold(true);
				setTextColor(1,0,0,1);
				renderText(0.74, 0.30, 0.02, "Handbremse lösen! - NUM 7 -");
			end;
			renderText(0.74, 0.26, 0.02, "(!) Handbremse aktiv (!)");	
		end;
		if self.druckWarning then
			setTextBold(true);
			setTextColor(1,0,0,1);
			renderText(0.74, 0.40, 0.02, "   Systemdruck zu gering.");
			renderText(0.74, 0.37, 0.02, "   Eingeschränkte Bremswirkung!");
		end;
	end;
end;

function Actros4:onEnter()
	
end;

function Actros4:onLeave()
    stopSample(self.compressorSoundId, 0, 1, 0);
    self.compressorSoundRunning = false;
end;

function Actros4:setHandBrakeState(state, noEventSend)
    GearEvent.sendEvent(self, state, noEventSend)
    self.handbrake = state;
    self.HandBrakeTurnOff = state;
    setVisibility(self.handbrakelight, state);
end;


GearEvent = {};
GearEvent_mt = Class(GearEvent, Event);

InitEventClass(GearEvent, "GearEvent");

function GearEvent:emptyNew()
    local self = Event:new(GearEvent_mt);
    self.className="GearEvent";
    return self;
end;

function GearEvent:new(object, state)
    local self = GearEvent:emptyNew()
	self.object = object;
	self.state = state;
	return self;
end;

function GearEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
    self.state = streamReadBool(streamId);
    self:run(connection);
end;

function GearEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.state);
end;

function GearEvent:run(connection)
	self.object:setHandBrakeState(self.state, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(GearEvent:new(self.object, self.state), nil, connection, self.object);
    end;	
end;

function GearEvent.sendEvent(vehicle, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(GearEvent:new(vehicle, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(GearEvent:new(vehicle, state));
		end;
	end;
end;
