--
-- schwenkFKH shift
--
-- author: upsidedown
-- date: 20.08.2013


schwenkFKH = {};

function schwenkFKH.prerequisitesPresent(specializations)
	return true; --SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function schwenkFKH:load(xmlFile)
	self.schwenkFKH = {};
	self.schwenkFKH.jointIndex = 2;
	
	
	self.schwenkFKH.currentOffset = 0;
	
	self.schwenkFKH.mode = 0; 
	
	--debug code:
	-- local object1 = Utils.indexToObject(self.components,"0>25|11")
	-- local object2 = Utils.indexToObject(self.components,"0>25|12")
	-- local x,y,z = getWorldTranslation(object1);
	-- local a,b,c = worldToLocal(object2,x,y,z)
	-- print(a)
	-- print(b)
	-- print(c)
	
	
end;

function schwenkFKH:delete()
	
end;

function schwenkFKH:mouseEvent(posX, posY, isDown, isUp, button)
end;

function schwenkFKH:keyEvent(unicode, sym, modifier, isDown)
end;

function schwenkFKH:update(dt)

	if self:getIsActiveForInput(true) then
		if InputBinding.hasEvent(InputBinding.schwenkFKHmode) then
			self.schwenkFKH.mode = self.schwenkFKH.mode + 1;
			if self.schwenkFKH.mode > 2 then
				self.schwenkFKH.mode = 0;
			end;
			
			--do event stuff..
			if g_server ~= nil then
				g_server:broadcastEvent(schwenkFKH_Event:new(self, self.schwenkFKH.mode), nil, nil, self);
			else
				g_client:getServerConnection():sendEvent(schwenkFKH_Event:new(self, self.schwenkFKH.mode));
			end;
			
		end;
	end;
	
end;

function schwenkFKH:updateTick(dt)
	if self:getIsActive() then
		if self.schwenkFKH.mode == 0 then --  starrer FKH
			self.schwenkFKH.currentOffset = 0;
		elseif self.schwenkFKH.mode == 1 then
			if self.steeringOffset ~= nil then
			
					--wheel.rotMax
					--self.schwenkFKH.currentOffset = math.rad(self.steeringOffset);
				self.schwenkFKH.currentOffset = -self.steeringOffset*math.deg(self.wheels[1].rotMax);
			
			else -- vehicle has no steering offset
				self.schwenkFKH.mode = 2; -- no event needed
			end
		elseif self.schwenkFKH.mode == 2 then --Lenkung folgen
			self.schwenkFKH.currentOffset = Utils.clamp(math.deg(self.wheels[1].steeringAngle),-15,15);
		end
	
	
	
		local jointDesc = self.attacherJoints[self.schwenkFKH.jointIndex];		
		
		if jointDesc.jointIndex > 0 then
			local dx = math.rad(self.schwenkFKH.currentOffset)-jointDesc.minRot[2]
			if math.abs(math.deg(dx)) > 0.01 then
				jointDesc.minRot[2] = jointDesc.minRot[2] + dt*0.003*(dx);
				jointDesc.maxRot[2] = jointDesc.minRot[2];
				
				local moveAlpha = Utils.getMovedLimitedValue(jointDesc.moveAlpha, jointDesc.lowerAlpha, jointDesc.upperAlpha, jointDesc.moveTime, dt, not jointDesc.moveDown);
				jointDesc.moveAlpha = moveAlpha;

				if jointDesc.rotationNode ~= nil then
					setRotation(jointDesc.rotationNode, Utils.vector3ArrayLerp(jointDesc.minRot, jointDesc.maxRot, jointDesc.moveAlpha));
				end
				if jointDesc.rotationNode2 ~= nil then
					setRotation(jointDesc.rotationNode2, Utils.vector3ArrayLerp(jointDesc.minRot2, jointDesc.maxRot2, jointDesc.moveAlpha));
				end
				jointDesc.jointFrameInvalid = true;
			end;
		end;
	end;
end;


function schwenkFKH:draw()

	-- todo
	local str = " ";
	if self.schwenkFKH.mode == 0 then
		str = "Schwenkhydraulik vorne: starr";
	elseif self.schwenkFKH.mode == 1 then
		str = "Schwenkhydraulik vorne: versetzt";
	elseif self.schwenkFKH.mode == 2 then
		str = "Schwenkhydraulik vorne: gelenkt";
	end;
	
	if self:getIsActiveForInput(true) then
		--g_currentMission:addHelpButtonText(g_i18n:getText("HorschSW3500S_2"), InputBinding.IMPLEMENT_EXTRA2); 
		--g_currentMission:addHelpButtonText(str, InputBinding.schwenkFKHmode);  --InputBinding.          getKeyNamesOfDigitalAction(InputBinding.piuRPM)
		g_currentMission:addExtraPrintText(str .. "  " .. InputBinding.getKeyNamesOfDigitalAction(InputBinding.schwenkFKHmode))
	else
		g_currentMission:addExtraPrintText(str)
		--g_currentMission:addHelpButtonText(str); 
	end;

	
end;


function schwenkFKH:onDeactivate()
	
end;




function schwenkFKH:writeStream(streamId, connection)
    streamWriteFloat32(streamId, self.schwenkFKH.mode);
end;


function schwenkFKH:readStream(streamId, connection)
    self.schwenkFKH.mode = streamReadFloat32(streamId);
end;






  schwenkFKH_Event = {};
  schwenkFKH_Event_mt = Class(schwenkFKH_Event, Event);
  
  InitEventClass(schwenkFKH_Event, "schwenkFKH_Event");
  
  function schwenkFKH_Event:emptyNew()
      local self = Event:new(schwenkFKH_Event_mt);
      return self;
  end;
  
  function schwenkFKH_Event:new(object, data)
      local self = schwenkFKH_Event:emptyNew()
      self.data = data;
	  
      self.object = object;
      return self;
  end;
  
  function schwenkFKH_Event:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.data = streamReadInt32(streamId);
      
	  
	  self.object = networkGetObject(id);
      self:run(connection);
  end;
  
  function schwenkFKH_Event:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
	  streamWriteInt32(streamId, self.data);

  end;
  
  function schwenkFKH_Event:run(connection)
	  self.object.schwenkFKH.mode = self.data;
	 
      if not connection:getIsServer() then
          g_server:broadcastEvent(schwenkFKH_Event:new(self.object, self.data), nil, connection, self.object);
      end;
  end;