--
-- easyCylinder
--
-- author: upsidedown
-- date: 19.08.2013

-- NO RELEASE CANDIDATE!


easyCylinder = {};

function easyCylinder.prerequisitesPresent(specializations)
	return true; --SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function easyCylinder:load(xmlFile)
	
	self.easyCylinders = {};
	local i=0;
    while true do
        local areaKey = string.format("vehicle.easyCylinder.cylinder(%d)", i);
        if not hasXMLProperty(xmlFile, areaKey) then			
            break;
        end
		
        local easyCylinder = {};
		easyCylinder.movingPart = Utils.indexToObject(self.components, getXMLString(xmlFile, areaKey .. "#movingPartIndex"));	
		easyCylinder.movingCylinder = Utils.indexToObject(self.components, getXMLString(xmlFile, areaKey .. "#movingCylinderIndex"));	
		easyCylinder.fixedCylinder = Utils.indexToObject(self.components, getXMLString(xmlFile, areaKey .. "#fixedCylinderIndex"));	

		local x,y,z = getWorldTranslation(easyCylinder.movingCylinder);
		
		local TG = createTransformGroup("cylinder_"..tostring(i+1))
		link(easyCylinder.movingPart,TG);
		Utils.setWorldTranslation(TG,x,y,z)
		
		link(TG,easyCylinder.movingCylinder)
		setTranslation(easyCylinder.movingCylinder,0,0,0)
		
		easyCylinder.TG = TG;
		
		local TG2 = createTransformGroup("cylinder2_"..tostring(i+1))
		link(getParent(easyCylinder.fixedCylinder),TG2);
		x,y,z = getWorldTranslation(easyCylinder.fixedCylinder);
		Utils.setWorldTranslation(TG2,x,y,z)
		easyCylinder.TG2 = TG2;
		
		local tx, ty, tz = Utils.getVectorFromString(getXMLString(xmlFile, areaKey .."#movingPartTrans"));
		if tx ~= nil and ty ~= nil and tz ~= nil then
			setTranslation(easyCylinder.movingPart,tx,ty,tz)
		end;
		
		local rx, ry, rz = Utils.getVectorFromString(getXMLString(xmlFile, areaKey .."#movingPartRot"));
		if rx ~= nil and ry ~= nil and rz ~= nil then
			setRotation(easyCylinder.movingPart,math.rad(rx),math.rad(ry),math.rad(rz))
		end;
		
		easyCylinder.doFix = Utils.getNoNil(getXMLBool(xmlFile, areaKey .. "#doFixCylinder"),true);
		easyCylinder.doMove = Utils.getNoNil(getXMLBool(xmlFile, areaKey .. "#doMoveCylinder"),true);
		
		rx, ry, rz = Utils.getVectorFromString(getXMLString(xmlFile, areaKey .."#movingCylRotOffset"));
		easyCylinder.doRotOffMove = rx ~= nil and ry ~= nil and rz ~= nil;
		if easyCylinder.doRotOffMove then
			easyCylinder.rotOffMove = {math.rad(rx), math.rad(ry), math.rad(rz)};
		end;
		
        i = i + 1;
		self.easyCylinders[i] = easyCylinder;		
    end
	
end;

function easyCylinder:delete()
	
end;

function easyCylinder:mouseEvent(posX, posY, isDown, isUp, button)
end;

function easyCylinder:keyEvent(unicode, sym, modifier, isDown)
end;

function easyCylinder:update(dt)
	
	
end;

function easyCylinder:updateTick(dt)
	if self:getIsActive() then
		for _,cylinder in pairs(self.easyCylinders) do
			if cylinder.doMove then
				local x,y,z = getWorldTranslation(cylinder.fixedCylinder) --part on moving side
				x,y,z = worldToLocal(cylinder.TG,x,y,z);
				setDirection(cylinder.movingCylinder,-x,-y,-z,0,1,0)
				if cylinder.doRotOffMove then
					local rx,ry,rz = getRotation(cylinder.movingCylinder)
					rx = rx + cylinder.rotOffMove[1];
					ry = ry + cylinder.rotOffMove[2];
					rz = rz + cylinder.rotOffMove[3];
					setRotation(cylinder.movingCylinder,rx,ry,rz)
				end
			end
			if cylinder.doFix then			
				x,y,z = getWorldTranslation(cylinder.TG) --part on fixed side
				x,y,z = worldToLocal(cylinder.TG2,x,y,z);
				setDirection(cylinder.fixedCylinder,x,y,z,0,1,0)
			end;
		end;
	end;
end;


function easyCylinder:draw()
	
end;


function easyCylinder:onDeactivate()
	
end;