--upsidedown 13.5.2013:
--smooth transition
--coupling with steershift and changeDirection
-- not MP ready  (??)

--edit 3.11.2013
--coupling with GPS

XerionSteer = {};

function XerionSteer.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Steerable, specializations)
end;

function XerionSteer:load(xmlFile)
    self.changeSteer = SpecializationUtil.callSpecializationsFunction("changeSteer");	
	self.isSelectable = true;
	self.XSmode = 2;
	self.XS_LR = 0;
	self.XS_OFFSET = .75581062231384;
	self.XS_OFFSET_CORR = 0.75;
	self.crabSteerSync = true;
	self.CrabSteerTrailerPing = 0;
	
	self.XSall = {}
	self.XSall.Min = {}
	self.XSall.Max = {}
	
	self.XSfront = {}
	self.XSfront.Min = {}
	self.XSfront.Max = {}
	
	self.XSback = {}
	self.XSback.Min = {}
	self.XSback.Max = {}

	self.XSforwardLeft = {}
	self.XSforwardLeft.Min = {}
	self.XSforwardLeft.Max = {}
	
	self.XSbackwardLeft = {}
	self.XSbackwardLeft.Min = {}
	self.XSbackwardLeft.Max = {}
	
	self.XSforwardRight = {}
	self.XSforwardRight.Min = {}
	self.XSforwardRight.Max = {}
	
	self.XSbackwardRight = {}
	self.XSbackwardRight.Min = {}
	self.XSbackwardRight.Max = {}
	
	self.XSmajorCrab = {}
	self.XSmajorCrab.Min = {}
	self.XSmajorCrab.Max = {}
	self.XSmajorCrab.WheelSpeed = {}
	
	self.XSwheelSpeed = {}
	
	
	local maxSteer = 0;
	for k, wheel in pairs(self.wheels) do
		self.XSall.Max[k] = wheel.rotMax
		if math.abs(self.XSall.Max[k]) > maxSteer then
			maxSteer = math.abs(self.XSall.Max[k]);
		end
		self.XSall.Min[k] = wheel.rotMin	
		if math.abs(self.XSall.Min[k]) > maxSteer then
			maxSteer = math.abs(self.XSall.Min[k]);
		end
		self.XSwheelSpeed[k] = wheel.rotSpeed;	
	end
	
	self.XSmaxSteer = maxSteer;
	
	for k, wheel in pairs(self.wheels) do
		if k < 3 then --vorderrder
			self.XSfront.Max[k] = maxSteer; 
			self.XSfront.Min[k] = -maxSteer;
			self.XSback.Max[k] = 0;         
			self.XSback.Min[k] = 0;
			
			self.XSforwardLeft.Max[k] = maxSteer; 
			self.XSforwardLeft.Min[k] = -maxSteer;
			self.XSforwardRight.Max[k] = maxSteer; 
			self.XSforwardRight.Min[k] = -maxSteer;
			
			self.XSbackwardLeft.Max[k] = maxSteer*self.XS_OFFSET; 
			self.XSbackwardLeft.Min[k] = maxSteer*self.XS_OFFSET; 
			self.XSbackwardRight.Max[k] = -maxSteer*self.XS_OFFSET; 
			self.XSbackwardRight.Min[k] = -maxSteer*self.XS_OFFSET; 
			
			self.XSmajorCrab.Min[k] = -maxSteer;
			self.XSmajorCrab.Max[k] = maxSteer;
			self.XSmajorCrab.WheelSpeed[k] = self.XSwheelSpeed[k]
			
		else --hinterrder
			self.XSfront.Max[k] = 0;
			self.XSfront.Min[k] = 0;
			self.XSback.Max[k] = maxSteer;
			self.XSback.Min[k] = -maxSteer;

			self.XSforwardLeft.Max[k] = maxSteer*self.XS_OFFSET;
			self.XSforwardLeft.Min[k] = maxSteer*self.XS_OFFSET;
			self.XSforwardRight.Max[k] = -maxSteer*self.XS_OFFSET;
			self.XSforwardRight.Min[k] = -maxSteer*self.XS_OFFSET;

			self.XSbackwardLeft.Max[k] = maxSteer; 
			self.XSbackwardLeft.Min[k] = -maxSteer;
			self.XSbackwardRight.Max[k] = maxSteer; 
			self.XSbackwardRight.Min[k] = -maxSteer;
			
			self.XSmajorCrab.Min[k] = -maxSteer;
			self.XSmajorCrab.Max[k] = maxSteer;
			self.XSmajorCrab.WheelSpeed[k] = -self.XSwheelSpeed[k]

		end
	end
	
	if self.isRealistic then
		self.realTyreGripFxBackup = self.realTyreGripFx;
	end;
	self.bunkerSiloCompactingScaleBackup = Utils.getNoNil(self.bunkerSiloCompactingScale, 1)
	
end;

function XerionSteer:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)  
   if not resetVehicles then
       self.XSmode = Utils.getNoNil(getXMLFloat(xmlFile, key.."#steermode"),2);
end;
    return BaseMission.VEHICLE_LOAD_OK;
end;

function XerionSteer:getSaveAttributesAndNodes(nodeIdent)
   local attributes = ' steermode="'..tonumber(self.XSmode)..'"';
   return attributes, nil;
end;

function XerionSteer:mouseEvent(posX, posY, isDown, isUp, button)
end;

function XerionSteer:keyEvent(unicode, sym, modifier, isDown)
end;

function XerionSteer:update(dt)
	
	if self:getIsActiveForInput(false) then
			
		local needPushEvent = false;
		if InputBinding.hasEvent(InputBinding.XerionSteer_Up,true) then
		    self.XSmode = self.XSmode + 1;
			if self.XSmode > 3 then --add new steering modes here
				self.XSmode = 3; --add new steering modes here
			end;			
			needPushEvent = true;
		end;
		if InputBinding.hasEvent(InputBinding.XerionSteer_Down,true) then
		    self.XSmode = self.XSmode - 1;
			if self.XSmode < 1 then
				self.XSmode = 1;
			end;
			needPushEvent = true;
		end;
		if self.CrabSteerTrailerPing > 0 then
			self.CrabSteerTrailerPing = self.CrabSteerTrailerPing -1;
		end
		
		if self.CrabSteerTrailerPing == 0 then
		
			if InputBinding.hasEvent(InputBinding.XerionSteer_Left,true) then
				needPushEvent = true;
				self.XS_LR = self.XS_LR - 1;
				if self.XS_LR < -1 then
					self.XS_LR = -1;
				end;			
			end;
			
			if InputBinding.hasEvent(InputBinding.XerionSteer_Right,true) then
				needPushEvent = true;
				self.XS_LR = self.XS_LR + 1;
				if self.XS_LR > 1 then
					self.XS_LR = 1;
				end;			
			end;
			if InputBinding.hasEvent(InputBinding.XerionSteer_Center,true) then
				needPushEvent = true;
				self.XS_LR = 0
			end;		
		end
		
		if needPushEvent then		
			if g_server ~= nil then
				g_server:broadcastEvent(xerionSteer_Event:new(self, self.XS_LR,self.XSmode), nil, nil, self);
			else
				g_client:getServerConnection():sendEvent(xerionSteer_Event:new(self, self.XS_LR,self.XSmode));
			end;	
		end

		
	end	
	
	if self:getIsActive() then
		
		local steeringPoint = self.rotatedTime/self.maxRotTime;
				
		local isInverted = self.invertedDrivingDirection==true or self.newInvertedDrivingDirection==true or self.ddIsInverted==true;
		if isInverted then
			steeringPoint = -steeringPoint;
		end;
		
		--local wheel1 = self.wheels[1].steeringAngle/self.wheels[1].rotMax;
		--print(tostring(steeringPoint).." "..tostring(self.steeringOffset).." "..tostring(wheel1))
				
				--print(tostring(1 - steeringPoint/wheel1))

			
		if self.XS_LR == 1 then
			self.steeringOffset = self.XS_OFFSET;
			if not isInverted then				
		
				local newSteer = self.XSmaxSteer * (-self.steeringOffset - (1+math.abs(self.XS_OFFSET_CORR))/(1-math.abs(self.XS_OFFSET_CORR))*(steeringPoint+self.steeringOffset))
		
				newSteer = Utils.clamp(newSteer,-self.XSmaxSteer,self.XSmaxSteer);
				
				self.XSforwardRight.Min[3] = newSteer;
				self.XSforwardRight.Min[4] = newSteer;
				self.XSforwardRight.Max[3] = newSteer;
				self.XSforwardRight.Max[4] = newSteer;
				
				self:changeSteer(self.XSforwardRight.Min,self.XSforwardRight.Max,1,self.XSwheelSpeed)
				self.GPSangleOffSet = newSteer;
			else
				local newSteer = self.XSmaxSteer * (-self.steeringOffset - (1+math.abs(self.XS_OFFSET_CORR))/(1-math.abs(self.XS_OFFSET_CORR))*(steeringPoint+self.steeringOffset))
				newSteer = Utils.clamp(newSteer,-self.XSmaxSteer,self.XSmaxSteer);
				
				self.XSbackwardRight.Min[1] = newSteer;
				self.XSbackwardRight.Min[2] = newSteer;
				self.XSbackwardRight.Max[1] = newSteer;
				self.XSbackwardRight.Max[2] = newSteer;
				
				self:changeSteer(self.XSbackwardRight.Min,self.XSbackwardRight.Max,1,self.XSwheelSpeed)
				self.GPSangleOffSet = newSteer;		
			end	
		elseif self.XS_LR == -1 then
			self.steeringOffset = -self.XS_OFFSET;
			if not isInverted then	
				local newSteer = self.XSmaxSteer * (-self.steeringOffset - (1+math.abs(self.XS_OFFSET_CORR))/(1-math.abs(self.XS_OFFSET_CORR))*(steeringPoint+self.steeringOffset))
				
				newSteer = Utils.clamp(newSteer,-self.XSmaxSteer,self.XSmaxSteer);
				
				self.XSforwardLeft.Min[3] = newSteer;
				self.XSforwardLeft.Min[4] = newSteer;
				self.XSforwardLeft.Max[3] = newSteer;
				self.XSforwardLeft.Max[4] = newSteer;
			
			
				self:changeSteer(self.XSforwardLeft.Min,self.XSforwardLeft.Max,1,self.XSwheelSpeed)
				self.GPSangleOffSet = newSteer;
			else
				local newSteer = self.XSmaxSteer * (-self.steeringOffset - (1+math.abs(self.XS_OFFSET_CORR))/(1-math.abs(self.XS_OFFSET_CORR))*(steeringPoint+self.steeringOffset))
				newSteer = Utils.clamp(newSteer,-self.XSmaxSteer,self.XSmaxSteer);
				
				self.XSbackwardLeft.Min[1] = newSteer;
				self.XSbackwardLeft.Min[2] = newSteer;
				self.XSbackwardLeft.Max[1] = newSteer;
				self.XSbackwardLeft.Max[2] = newSteer;			
			
				self:changeSteer(self.XSbackwardLeft.Min,self.XSbackwardLeft.Max,1,self.XSwheelSpeed)
				self.GPSangleOffSet = newSteer;
			end
		elseif self.XS_LR == -2 or self.XS_LR == 2 then --inactive
			self.steeringOffset = 0;
			self.GPSangleOffSet = 0;
			if not isInverted then	
				self:changeSteer(self.XSmajorCrab.Min,self.XSmajorCrab.Max,1,self.XSmajorCrab.WheelSpeed)			
			else
				self:changeSteer(self.XSmajorCrab.Min,self.XSmajorCrab.Max,-1,self.XSmajorCrab.WheelSpeed)			
			end		
		else --normal steering
			self.GPSangleOffSet = 0;
			self.steeringOffset = 0;
			if self.XSmode == 1 then
				if not isInverted then	
					self:changeSteer(self.XSback.Min,self.XSback.Max,1,self.XSwheelSpeed)	
				else
					self:changeSteer(self.XSfront.Min,self.XSfront.Max,1,self.XSwheelSpeed)						
				end			
			elseif self.XSmode == 2 then
				if not isInverted then	
					self:changeSteer(self.XSall.Min,self.XSall.Max,1,self.XSwheelSpeed)	
				else
					self:changeSteer(self.XSall.Min,self.XSall.Max,1,self.XSwheelSpeed)	
				end

			elseif self.XSmode == 3 then
				if not isInverted then	
					self:changeSteer(self.XSfront.Min,self.XSfront.Max,1,self.XSwheelSpeed)	
				else
					self:changeSteer(self.XSback.Min,self.XSback.Max,1,self.XSwheelSpeed)	
				end
			else
				print("Error: invalid XS steering mode")
			end			
			
		end;
		
		if self.isRealistic then
			if math.abs(self.XS_LR) > 0 then				
				self.realTyreGripFx = 1.5*self.realTyreGripFxBackup;					 
			else
				self.realTyreGripFx = self.realTyreGripFxBackup;
			end;
		end;
				
		if math.abs(self.XS_LR) > 0 then
			self.bunkerSiloCompactingScale = 1.5*self.bunkerSiloCompactingScaleBackup;		
		else
			self.bunkerSiloCompactingScale = 1.0*self.bunkerSiloCompactingScaleBackup;
		end;

		local K_const = 0.004;--0.004;
		
		local k
		local x
		local y
		local dy
		for k, wheel in pairs(self.wheels) do
			x = wheel.rotMax;		
			y = wheel.rotMaxSoll;
			
			dy = y-x;
			if (dy)^2 > 0.00001 then
				wheel.rotMax = x + (dy)*K_const*dt;
			else
				wheel.rotMax = wheel.rotMaxSoll;
			end;
		
			x = wheel.rotMin;		
			y = wheel.rotMinSoll;
			
			dy = y-x;
			if (dy)^2 > 0.00001 then
				wheel.rotMin = x + (dy)*K_const*dt;
			else
				wheel.rotMin = wheel.rotMinSoll;
			end;
		end;
		
	end	
	
end;

function XerionSteer:draw()
	
	if self.XS_LR == 1 then
		g_currentMission:addExtraPrintText(g_i18n:getText("Steer_right"));
	elseif self.XS_LR == -1 then
		g_currentMission:addExtraPrintText(g_i18n:getText("Steer_left"));
	elseif self.XSmode == 1 then
		g_currentMission:addExtraPrintText(g_i18n:getText("Steer_back"));
	elseif self.XSmode == 2 then
		g_currentMission:addExtraPrintText(g_i18n:getText("Steer_all"));
	elseif self.XSmode == 3 then
		g_currentMission:addExtraPrintText(g_i18n:getText("Steer_front"));
	end;
	
end;

function XerionSteer:changeSteer(wheelMin,wheelMax,direction,wheelSpeed)
	local direcFactor = 1.0;
	local isInverted = self.invertedDrivingDirection==true or self.newInvertedDrivingDirection==true or self.ddIsInverted==true;
	if isInverted then
		direcFactor = -1.0;
	end
	
	for k, wheel in pairs(self.wheels) do
		wheel.rotMinSoll = wheelMin[k];
		wheel.rotMaxSoll = wheelMax[k];
		wheel.rotSpeed = direction*direcFactor*wheelSpeed[k];
	end       
end;

function XerionSteer:delete()
end;


function XerionSteer:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.XS_LR);
	streamWriteInt8(streamId, self.XSmode);
end;


function XerionSteer:readStream(streamId, connection)
	self.XS_LR = streamReadInt8(streamId);
	self.XSmode = streamReadInt8(streamId);
end;




xerionSteer_Event = {};
  xerionSteer_Event_mt = Class(xerionSteer_Event, Event);
 
  InitEventClass(xerionSteer_Event, "xerionSteer_Event");
  
  function xerionSteer_Event:emptyNew()
      local self = Event:new(xerionSteer_Event_mt);
      return self;
  end;
  
  function xerionSteer_Event:new(object, lr,mode)
      local self = xerionSteer_Event:emptyNew()
      self.lr = lr;
	  self.mode = mode;
	  
      self.object = object;
      return self;
  end;
  
  function xerionSteer_Event:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.lr = streamReadInt8(streamId);
	  self.mode = streamReadInt8(streamId);

  
	  self.object = networkGetObject(id);
      self:run(connection);
  end;
  
  function xerionSteer_Event:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
	  streamWriteInt8(streamId, self.lr);
	  streamWriteInt8(streamId, self.mode);

  end;
  
  function xerionSteer_Event:run(connection)
	  self.object.XS_LR = self.lr;
	  self.object.XSmode = self.mode;
	  
      if not connection:getIsServer() then
          g_server:broadcastEvent(xerionSteer_Event:new(self.object, self.lr, self.mode), nil, connection, self.object);
      end;
  end;