-- @ Autor  Tobias F. (John Deere 6930)
-- @ Last Edit  02/11/2011
-- @ history:
		--01/08/2011 - initializing Specialization
		--02/11/2011 - fixing multiplayererror
-- InvertDrivingDirection
-- Specialization to invert the DrivingDirection
--[[XML Data:
<invertSteering rootNode="" clip="" speedScale=""/> ]]

-- Edit 08 2013 by upsidedown:
-- removed all but animation code
-- remade MP-code from scratch
-- remade inverting from scratch without causing the "even number of xerions"-bug
-- CHANGED COMMUNICATING VARIABLE from self.invertedDrivingDirection to self.newInvertedDrivingDirection to avoid complications from mods with old function replacement code

-- 06 14 added MR code
 
InvertDrivingDirection = {};

function InvertDrivingDirection.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function InvertDrivingDirection:load(xmlFile)
	self.invertSteering = InvertDrivingDirection.invertSteering;
	self.newInvertedDrivingDirection = false;
	self.lastAcceleration = 0;
	self.invertTimeOut = 0;
	self.showWarningTime = 0;
	self.invertSteeringAnimation = {};
	self.invertSteeringAnimation.animRootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.invertSteering#rootNode"));
	if self.invertSteeringAnimation.animRootNode ~= nil and self.invertSteeringAnimation.animRootNode ~= 0 then
		self.invertSteeringAnimation.animCharSet = getAnimCharacterSet(self.invertSteeringAnimation.animRootNode);
		if self.invertSteeringAnimation.animCharSet ~= 0 then
			local clip = getAnimClipIndex(self.invertSteeringAnimation.animCharSet, getXMLString(xmlFile, "vehicle.invertSteering#clip"));
			assignAnimTrackClip(self.invertSteeringAnimation.animCharSet, 0, clip);
			setAnimTrackLoopState(self.invertSteeringAnimation.animCharSet, 0, false);
			self.invertSteeringAnimation.animSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.invertSteering#speedScale"), 1);
			self.invertSteeringAnimation.animDuration = getAnimClipDuration(self.invertSteeringAnimation.animCharSet, clip);
		end;
	end;
	
	
	
end;

function InvertDrivingDirection:postLoad(xmlFile)
	if WheelsUtil.newInvertDrivingInserted == nil then
		if self.isRealistic then
			self.realUpdateDriveAxisInput = Utils.overwrittenFunction(self.realUpdateDriveAxisInput,InvertDrivingDirection.realUpdateDriveAxisInput);
			
		else
			WheelsUtil.updateWheelsPhysics = Utils.overwrittenFunction(
				WheelsUtil.updateWheelsPhysics,
				InvertDrivingDirection.updateVehiclePhysics);
		end;
		WheelsUtil.newInvertDrivingInserted = true;
		print("newInvertDriving mod inserted into WheelsUtil (should happen only once!)")
		
	end;
end;

function InvertDrivingDirection:delete()
end;

function InvertDrivingDirection:mouseEvent(posX, posY, isDown, isUp, button)
end;

function InvertDrivingDirection:keyEvent(unicode, sym, modifier, isDown)
end;

function InvertDrivingDirection:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.INVERTDRIVINGDIRECTION) and self.invertTimeOut <= self.time then
			self:invertSteering(not self.newInvertedDrivingDirection);
			if g_server ~= nil then
				g_server:broadcastEvent(InvertDrivingDirection_Event:new(self, self.newInvertedDrivingDirection), nil, nil, self);
			else
				g_client:getServerConnection():sendEvent(InvertDrivingDirection_Event:new(self, self.newInvertedDrivingDirection));
			end;
		end;
	end;
	if self:getIsActive() then
		if self.invertTimeOut > self.time then
			local animCharSet = self.invertSteeringAnimation.animCharSet;
			if self.newInvertedDrivingDirection then
			
			if animCharSet ~= 0 then
				    if getAnimTrackTime(animCharSet, 0) < 0.0 then
						setAnimTrackTime(animCharSet, 0, 0.0);
					end;
					setAnimTrackSpeedScale(animCharSet, 0, self.invertSteeringAnimation.animSpeedScale);
					enableAnimTrack(animCharSet, 0);
				end;	
			else

			if animCharSet ~= 0 then
					if getAnimTrackTime(animCharSet, 0) > self.invertSteeringAnimation.animDuration then
						setAnimTrackTime(animCharSet, 0, self.invertSteeringAnimation.animDuration);
					end;
					setAnimTrackSpeedScale(animCharSet, 0, -self.invertSteeringAnimation.animSpeedScale);
					enableAnimTrack(animCharSet, 0);
				end;	
			end;		
			
		end;
		
		if self.newInvertedDrivingDirection then
			if self.isHired and self.dismiss ~= nil and self.stopAITractor ~= nil then
				self:dismiss();
				self:stopAITractor();
				self.showWarningTime = self.time + 3000;
			end;
		end;	
	end;
end;

function InvertDrivingDirection:readStream(streamId, connection)
    local invertedDrivingDirection = streamReadBool(streamId);
	if invertedDrivingDirection ~= self.newInvertedDrivingDirection then
		self:invertSteering(invertedDrivingDirection, true);
	end;
end;

function InvertDrivingDirection:writeStream(streamId, connection)
    streamWriteBool(streamId, self.newInvertedDrivingDirection);
end;

function InvertDrivingDirection:draw()
	if self.showWarningTime > self.time then
		g_currentMission:addWarning(g_i18n:getText("warning_ai_active"), 0, 0.03);
	end;
	if not self.newInvertedDrivingDirection  then
		g_currentMission:addHelpButtonText(g_i18n:getText("ACTIVATE_INVERTDRIVING"), InputBinding.INVERTDRIVINGDIRECTION);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("DEACTIVATE_INVERTDRIVING"), InputBinding.INVERTDRIVINGDIRECTION);
	end;
end;

function InvertDrivingDirection:invertSteering(steeringIsInverted, noEventSend)
	
	
	self.invertTimeOut = self.time+100+self.invertSteeringAnimation.animDuration;
	self.newInvertedDrivingDirection = steeringIsInverted;
	self.steeringSpeed = -self.steeringSpeed;
end;



function InvertDrivingDirection:realUpdateDriveAxisInput(oldFunc)
	
	--print("invert insert successfull!")
	oldFunc(self);
	
	if self.newInvertedDrivingDirection  then
		self.axisForward = - self.axisForward;
		self.axisSide = - self.axisSide;
	end;
	
	-- local offset = Utils.getNoNil(self.steeringOffset,0);
	--print(offset)
	-- self.axisSide = self.axisSide + offset;
	
	-- if offset ~= 0 then
		-- self.axisSideIsAnalog = true;
	-- end;
	
end;


function InvertDrivingDirection:updateVehiclePhysics(oldFunc, dt, currentSpeed, acceleration, doHandbrake, requiredDriveMode)	
	
	local accelerationValue = acceleration;
	--if isAlreadyInverted == nil or isAlreadyInverted == false then
		if self.newInvertedDrivingDirection ~= nil then
			if self.newInvertedDrivingDirection == true then
				accelerationValue = -accelerationValue;
			end;
		end;
	--end;

	oldFunc(self, dt, currentSpeed, accelerationValue, doHandbrake, requiredDriveMode, isAlreadyInverted);

end;


InvertDrivingDirection_Event = {};
  InvertDrivingDirection_Event_mt = Class(InvertDrivingDirection_Event, Event);
 
  InitEventClass(InvertDrivingDirection_Event, "InvertDrivingDirection_Event");
  
  function InvertDrivingDirection_Event:emptyNew()
      local self = Event:new(InvertDrivingDirection_Event_mt);
      return self;
  end;
  
  function InvertDrivingDirection_Event:new(object, invert)
      local self = InvertDrivingDirection_Event:emptyNew()
      self.invert = invert;
	  
	  
      self.object = object;
      return self;
  end;
  
  function InvertDrivingDirection_Event:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.invert = streamReadBool(streamId);
	 

  
	  self.object = networkGetObject(id);
      self:run(connection);
  end;
  
  function InvertDrivingDirection_Event:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
	  streamWriteBool(streamId, self.invert);
	 

  end;
  
  function InvertDrivingDirection_Event:run(connection)
	  self.object.newInvertedDrivingDirection = self.invert;
	  self.object.invertTimeOut = self.object.time+100+self.object.invertSteeringAnimation.animDuration;
	
	  
      if not connection:getIsServer() then
          g_server:broadcastEvent(InvertDrivingDirection_Event:new(self.object, self.invert), nil, connection, self.object);
      end;
  end;