--
-- Wischer
-- This is the specialization for Claas- Wiper
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
--
-- Edited for Wiper by mavwitch

wiper = {};

function wiper.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function wiper:load(xmlFile)
    
		self.wiper = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wiper#index"));
	
end;

function wiper:update(dt)
	if self:getIsActive() then
		if g_currentMission.environment.lastRainScale <= 0.02 and g_currentMission.environment.timeSinceLastRain > 20 then
				setRotation(self.wiper, 0, 0, 0);
			else
				rotate(self.wiper, 0, 0, dt*0.005);
		end;
	end;
end;

function wiper:mouseEvent(posX, posY, isDown, isUp, button)
end;

function wiper:keyEvent(unicode, sym, modifier, isDown)
end;

function wiper:draw()  
end;

function wiper:delete()
end;