-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

EasyFlowGrassForceGrassEvent = {};
EasyFlowGrassForceGrassEvent_mt = Class(EasyFlowGrassForceGrassEvent, Event);

InitEventClass(EasyFlowGrassForceGrassEvent, "EasyFlowGrassForceGrassEvent");

function EasyFlowGrassForceGrassEvent:emptyNew()
    local self = Event:new(EasyFlowGrassForceGrassEvent_mt);
    return self;
end;

function EasyFlowGrassForceGrassEvent:new(object, enabled)
    local self = EasyFlowGrassForceGrassEvent:emptyNew()
    self.object = object;
    self.enabled = enabled;
    return self;
end;

function EasyFlowGrassForceGrassEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.enabled = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function EasyFlowGrassForceGrassEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
    streamWriteBool(streamId, self.enabled);
end;

function EasyFlowGrassForceGrassEvent:run(connection)
    self.object:changeGrassForceGrass(self.enabled, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(EasyFlowGrassForceGrassEvent:new(self.object, self.enabled), nil, connection, self.object);
    end;
end;
