
Leds = {};

function Leds.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Leds:load(xmlFile)
    self.ledCabine = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.ledCabine#index"));
    self.ledLuzCano = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.ledLuzCano#index"));
    self.ledFrontwork = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.ledFrontwork#index"));
    self.ledLampeggiante = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.ledLampeggiante#index"));
    self.ventoina = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.ventoina#index"));
	end;

function Leds:delete()
end;
function Leds:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Leds:keyEvent(unicode, sym, modifier, isDown)
end;

function Leds:update(dt)
    if self.isMotorStarted then
         		rotate(self.ventoina, dt*0.01,0, 0, 0 );		
	end;
end;
function Leds:updateTick(dt)
	if self.ledCabine ~= nil then
			local i = 4
			if self.B3.work[i].a then
				setVisibility(self.ledCabine, true);
			else
				setVisibility(self.ledCabine, false);
			end;
		end;
	if self.ledLuzCano ~= nil then
			local i = 3
			if self.B3.work[i].a then
				setVisibility(self.ledLuzCano, true);
			else
				setVisibility(self.ledLuzCano, false);
			end;
		end;
    if self.ledFrontwork ~= nil then
		 local i = 1
		 if self.B3.work[i].a then
			setVisibility(self.ledFrontwork, true);
		else
			setVisibility(self.ledFrontwork, false);
		end;
	end;
    if self.ledLampeggiante ~= nil then
		 if self.beaconLightsActive then
		    setVisibility(self.ledLampeggiante, true);
		 else
		   setVisibility(self.ledLampeggiante, false);
		end;
	end;
end;
function Leds:draw()
end;