--
-- Fortschritt T088
--
-- @author		Burner
-- @date		22.05.2012
--
 
T088 = {};
  
function T088.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(ManureSpreader, specializations);
end;

function T088:load(xmlFile)
	self.changePlane = SpecializationUtil.callSpecializationsFunction("changePlane");
	self.loading = true;
	
	self.fillLevelBackup = self.fillLevel;
	
	self.loadingPlanes = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.loadingPlanes.loadingPlane(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;
		local planeNode = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
		local v = getXMLString(xmlFile, key .. "#type");
		local fillType = Fillable.fillTypeNameToInt[v];
		if planeNode ~= nil and fillType ~= nil then
			table.insert(self.loadingPlanes, {node=planeNode, fillType=fillType});
		end;
		i = i + 1;
	end;
	
	self.unloadingPlanes = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.unloadingPlanes.unloadingPlane(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;
		local planeNode = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
		local v = getXMLString(xmlFile, key .. "#type");
		local fillType = Fillable.fillTypeNameToInt[v];
		if planeNode ~= nil and fillType ~= nil then
			table.insert(self.unloadingPlanes, {node=planeNode, fillType=fillType});
		end;
		i = i + 1;
	end;
	
	self.particleSystemMist = {};
    local i = 0;
    while true do
        local system5i = string.format("vehicle.particleSystemMist.system(%d)", i);
		local index5i = Utils.indexToObject(self.components, getXMLString(xmlFile, system5i .. "#index"));
		if index5i == nil then
			break;
		end;
		StaticParticleSystem.loadParticleSystem(xmlFile, self.particleSystemMist, system5i, index5i, false, nil, self.baseDirectory);	
		i = i +1;		
    end;
	
	self.manureSpreaderUVScrollParts = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.manureSpreaderUVScrollParts.manureSpreaderUVScrollPart(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;
		local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
		local speed = Utils.getVectorNFromString(getXMLString(xmlFile, key.."#speed"), 2);
		if node ~= nil and speed then
			table.insert(self.manureSpreaderUVScrollParts, {node=node, speed=speed, currentLength=0});
		end;
		i = i +1;
	end;
	
	--self.powerShaftNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerShaft#rootNode"));
	
	self.firstRun = true;
end;

function T088:delete()
	Utils.deleteParticleSystem(self.particleSystemMist);
end;

function T088:mouseEvent(posX, posY, isDown, isUp, button)
end;

function T088:keyEvent(unicode, sym, modifier, isDown)
end;
 
function T088:update(dt)
	if self.firstRun then	
		self:changePlane(true);
		self.firstRun = false;
	end;
	Utils.setEmittingState(self.particleSystemMist, (self.fillLevel > 0 and self.currentFillType == Fillable.FILLTYPE_MANURE));
	
	self.allowTipDischarge = (self.varBody.activeIdx ~= 1);
	
	if self.varBody.activeIdx ~= 1 or self.tipState == Trailer.TIPSTATE_OPENING or self.tipState == Trailer.TIPSTATE_OPEN then
		self.isTurnedOn = false;
	end;
	
	if self.isTurnedOn or self.tipState == Trailer.TIPSTATE_OPENING or self.tipState == Trailer.TIPSTATE_OPEN then
		for k, part in pairs(self.manureSpreaderUVScrollParts) do
			part.currentLength = part.currentLength + 1;
			setShaderParameter(part.node, "UVPlaySpeed", part.currentLength*part.speed[1], part.currentLength*part.speed[2], 0, 0, false);
		end;
		self.rotatingPartsAnimTime = self.rotatingPartsAnimTime + dt;
		for _, rotatingPart in ipairs(self.rotatingParts) do
			setRotation(rotatingPart.node, 0 , rotatingPart.speed*self.rotatingPartsAnimTime, 0);
		end;
		if self.currentFillType == Fillable.FILLTYPE_MANURE and self.fillLevel > 0 then
			for k,sprayValve in pairs(self.sprayValves) do
				Utils.setEmittingState(sprayValve.particleSystems, true);
			end;
		else
			for k,sprayValve in pairs(self.sprayValves) do
				Utils.setEmittingState(sprayValve.particleSystems, false);
			end;
		end;
		if self.isClient then
			if not self.spraySoundEnabled and self:getIsActiveForSound() then
				playSample(self.spraySound, 0, self.spraySoundVolume, 0);
				setSamplePitch(self.spraySound, self.spraySoundPitchOffset);
				self.spraySoundEnabled = true;
			end;
		end;
	else
		for k,sprayValve in pairs(self.sprayValves) do
			Utils.setEmittingState(sprayValve.particleSystems, false);
		end;
		if self.isClient then
			if self:getIsActiveForSound() and self.spraySoundEnabled then
				stopSample(self.spraySound);
				self.spraySoundEnabled = false;
			end;
		end;
	end;
	
	--if self.powerShaftNode ~= nil and (self.isTurnedOn or self.tipState == Trailer.TIPSTATE_OPENING or self.tipState == Trailer.TIPSTATE_OPEN) then
		--rotate(self.powerShaftNode, 0, 0, 0.4);
	--end;
	
	if self.fillLevelBackup < self.fillLevel then
		self.fillLevelBackup = self.fillLevel;
		--if not self.loading then
			self:changePlane(true);
		--end;
	end;
	--if self:getIsActive() then
		if self.isTurnedOn or self.tipState == Trailer.TIPSTATE_OPENING or self.tipState == Trailer.TIPSTATE_OPEN then
			self.fillLevelBackup = self.fillLevel;
			if self.loading then
				self:changePlane(false);
			end;
		end;
	--end;
end;

function T088:updateTick(dt)
end;
 
function T088:draw()
end;
 
function T088:onDetach()	
	if self.deactivateOnLeave then
		T088.onDeactivate(self);
	else
		T088.onDeactivateSounds(self)
	end;
end;

function T088:onLeave()
	if self.deactivateOnLeave then
		T088.onDeactivate(self);
	else
		T088.onDeactivateSounds(self)
	end;
end;
 
function T088:onDeactivate()
end;
  
function T088:onDeactivateSounds()
end;

function T088:changePlane(bool)
	if bool ~= nil then	
		self.loading = bool;

		if bool then
			for _, loadingPlane in pairs(self.loadingPlanes) do
				if loadingPlane.fillType == self.currentFillType then
					setVisibility(loadingPlane.node, true);
				end;
			end;
			for _, unloadingPlane in pairs(self.unloadingPlanes) do
				setVisibility(unloadingPlane.node, false);
			end;
		else
			for _, loadingPlane in pairs(self.loadingPlanes) do
				setVisibility(loadingPlane.node, false);
			end;
			for _, unloadingPlane in pairs(self.unloadingPlanes) do
				if unloadingPlane.fillType == self.currentFillType then
					setVisibility(unloadingPlane.node, true);
				end;
			end;
		end;
	else
		self:changePlane(not self.loading);
	end;
end;