-- KabSounds.lua
-- Script for K744R4
--
-- Author ALUHA74RUS
-- 22.01.2018

KabSounds = {};

function KabSounds.prerequisitesPresent(specializations)
    return true;
end;

function KabSounds:load(savegame)
	
	self.soundAdj = {};
	local i=0;
    while true do
        local key = string.format("vehicle.indoorsoundAdjustment.animation(%d)", i);
        if not hasXMLProperty(self.xmlFile, key) then
            break;
        end;
        local animName = getXMLString(self.xmlFile, key.."#name");
        local lowpassGain = Utils.getNoNil(getXMLFloat(self.xmlFile, key.."#lowpassGain"), 0.5);
        local volumeFactor = Utils.getNoNil(getXMLFloat(self.xmlFile, key.."#volumeFactor"), 0.5);
		self.soundAdj[i] = {};
		self.soundAdj[i].animName = animName;
		self.soundAdj[i].volumeFactor = volumeFactor;
		self.soundAdj[i].lowpassGain = lowpassGain;
        i = i +1;
    end;
	
	if self.isClient then
		self.sampleOpenDoorL = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.openDoorSound", "sounds/OpenDoor.wav", self.baseDirectory, self.components[1].node);
		self.sampleCloseDoorL = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.closeDoorSound", "sounds/CloseDoor.wav", self.baseDirectory, self.components[1].node);
		self.sampleOpenSwetTop = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.openDoorSound", "sounds/KlawVkl.wav", self.baseDirectory, self.components[1].node);
		self.sampleCloseSwetTop = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.closeDoorSound", "sounds/KlawVikl.wav", self.baseDirectory, self.components[1].node);
		self.sampleOpenSwetTop1 = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.openDoorSound", "sounds/KlawVkl.wav", self.baseDirectory, self.components[1].node);
		self.sampleCloseSwetTop1 = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.closeDoorSound", "sounds/KlawVikl.wav", self.baseDirectory, self.components[1].node);
		self.sampleOpenSwetKab = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.openDoorSound", "sounds/KlawVkl.wav", self.baseDirectory, self.components[1].node);
		self.sampleCloseSwetKab = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.closeDoorSound", "sounds/KlawVikl.wav", self.baseDirectory, self.components[1].node);
	end;
end;
--function KabSounds:postLoad(savegame)
--	for k,v in pairs(self.sampleMotor) do print(k,v) end
--end;
function KabSounds:delete()
	if self.sampleOpenDoorL ~= nil then
		SoundUtil.deleteSample(self.sampleOpenDoorL);
	end;
	if self.sampleOpenSwetTop ~= nil then
		SoundUtil.deleteSample(self.sampleOpenSwetTop);
	end;
	if self.sampleOpenSwetTop1 ~= nil then
		SoundUtil.deleteSample(self.sampleOpenSwetTop1);
	end;
	if self.sampleOpenSwetKab ~= nil then
		SoundUtil.deleteSample(self.sampleOpenSwetKab);
	end;
	if self.sampleCloseSwetTop ~= nil then
		SoundUtil.deleteSample(self.sampleCloseSwetTop);
	end;
	if self.sampleCloseSwetTop1 ~= nil then
		SoundUtil.deleteSample(self.sampleCloseSwetTop1);
	end;
	if self.sampleCloseDoorL ~= nil then
		SoundUtil.deleteSample(self.sampleCloseDoorL);
	end;
	if self.sampleCloseSwetKab ~= nil then
		SoundUtil.deleteSample(self.sampleCloseSwetKab);
	end;
end;
function KabSounds:mouseEvent(posX, posY, isDown, isUp, button)
end;
function KabSounds:keyEvent(unicode, sym, modifier, isDown)
end;
function KabSounds:update(dt)

    if self:getIsActive() and self.isClient then
		if self.isEntered then
			if self:getIsAnimationPlaying("leftDoor") and self:getIsActiveForSound() then
				if self.animations["leftDoor"].currentSpeed > 0 and self.animations["leftDoor"].currentTime < 50 then
					if not SoundUtil.isSamplePlaying(self.sampleOpenDoorL, 1.5*dt) then
						SoundUtil.playSample(self.sampleOpenDoorL,1,1,nil);
					end;
				elseif self.animations["leftDoor"].currentSpeed < 0 and self.animations["leftDoor"].currentTime > 50 then
					if not SoundUtil.isSamplePlaying(self.sampleCloseDoorL, 1.5*dt) then
						SoundUtil.playSample(self.sampleCloseDoorL,1,1,nil);
					end;
				end;
			end;
			if self:getIsAnimationPlaying("rightDoor") and self:getIsActiveForSound() then
				if self.animations["rightDoor"].currentSpeed > 0 and self.animations["rightDoor"].currentTime < 50 then
					if not SoundUtil.isSamplePlaying(self.sampleOpenDoorL, 1.5*dt) then
						SoundUtil.playSample(self.sampleOpenDoorL,1,1,nil);
					end;
				elseif self.animations["rightDoor"].currentSpeed < 0 and self.animations["rightDoor"].currentTime > 50 then
					if not SoundUtil.isSamplePlaying(self.sampleCloseDoorL, 1.5*dt) then
						SoundUtil.playSample(self.sampleCloseDoorL,1,1,nil);
					end;
				end;
			end;
			if self:getIsAnimationPlaying("SwetTop") and self:getIsActiveForSound() then
				if self.animations["SwetTop"].currentSpeed > 0 and self.animations["SwetTop"].currentTime < 50 then
					if not SoundUtil.isSamplePlaying(self.sampleOpenSwetTop, 1.5*dt) then
						SoundUtil.playSample(self.sampleOpenSwetTop,1,1,nil);
					end;
				elseif self.animations["SwetTop"].currentSpeed < 0 and self.animations["SwetTop"].currentTime < 100 then
					if not SoundUtil.isSamplePlaying(self.sampleCloseSwetTop, 1.5*dt) then
						SoundUtil.playSample(self.sampleCloseSwetTop,1,1,nil);
					end;
				end;
			end;
			if self:getIsAnimationPlaying("SwetTop1") and self:getIsActiveForSound() then
				if self.animations["SwetTop1"].currentSpeed > 0 and self.animations["SwetTop1"].currentTime < 50 then
					if not SoundUtil.isSamplePlaying(self.sampleOpenSwetTop1, 1.5*dt) then
						SoundUtil.playSample(self.sampleOpenSwetTop1,1,1,nil);
					end;
				elseif self.animations["SwetTop1"].currentSpeed < 0 and self.animations["SwetTop1"].currentTime < 100 then
					if not SoundUtil.isSamplePlaying(self.sampleCloseSwetTop1, 1.5*dt) then
						SoundUtil.playSample(self.sampleCloseSwetTop1,1,1,nil);
					end;
				end;
			end;
			if self:getIsAnimationPlaying("SwetKab") and self:getIsActiveForSound() then
				if self.animations["SwetKab"].currentSpeed > 0 and self.animations["SwetKab"].currentTime < 50 then
					if not SoundUtil.isSamplePlaying(self.sampleOpenSwetKab, 1.5*dt) then
						SoundUtil.playSample(self.sampleOpenSwetKab,1,1,nil);
					end;
				elseif self.animations["SwetKab"].currentSpeed < 0 and self.animations["SwetKab"].currentTime < 100 then
					if not SoundUtil.isSamplePlaying(self.sampleCloseSwetKab, 1.5*dt) then
						SoundUtil.playSample(self.sampleCloseSwetKab,1,1,nil);
					end;
				end;
			end;
			local sound=false;
			for i=0, #self.soundAdj do
				if self.animations[self.soundAdj[i].animName] ~= nil and self.animations[self.soundAdj[i].animName].currentTime > 500 then
					self.sampleMotor.indoorVolumeFactor = math.max(self.soundAdj[i].volumeFactor, self.sampleMotor.indoorVolumeFactor);
					self.sampleMotor.indoorLowpassGain = math.max(self.soundAdj[i].lowpassGain, self.sampleMotor.indoorLowpassGain);
					self.sampleMotorStart.indoorVolumeFactor = math.max(self.soundAdj[i].volumeFactor, self.sampleMotorStart.indoorVolumeFactor);
					self.sampleMotorStart.indoorLowpassGain = math.max(self.soundAdj[i].lowpassGain, self.sampleMotorStart.indoorLowpassGain);
					self.sampleMotorStop.indoorVolumeFactor = math.max(self.soundAdj[i].volumeFactor, self.sampleMotorStop.indoorVolumeFactor);
					self.sampleMotorStop.indoorLowpassGain = math.max(self.soundAdj[i].lowpassGain, self.sampleMotorStop.indoorLowpassGain);
					
					self.sampleMotorRun.indoorVolumeFactor = math.max(self.soundAdj[i].volumeFactor, self.sampleMotorRun.indoorVolumeFactor);
					self.sampleMotorRun.indoorLowpassGain = math.max(self.soundAdj[i].lowpassGain, self.sampleMotorRun.indoorLowpassGain);
					sound=true;
				else
					if not sound then
						self.sampleMotor.indoorVolumeFactor = 0.55;
						self.sampleMotor.indoorLowpassGain = 0.2;
						self.sampleMotorStart.indoorVolumeFactor = 0.55;
						self.sampleMotorStart.indoorLowpassGain = 0.2;
						self.sampleMotorStop.indoorVolumeFactor = 0.55;
						self.sampleMotorStop.indoorLowpassGain = 0.2;
						
						self.sampleMotorRun.indoorVolumeFactor = 0.6;
						self.sampleMotorRun.indoorLowpassGain = 0.2;
					end;
				end;
			end;
			SoundUtil.onCameraSwitched(self.activeCamera.isInside);
		end;
    end;
end;
function KabSounds:updateTick(dt)
end;
function KabSounds:draw()    
end;