--
-- PlayerCamera
--
-- MOD Author:  Slavo LS Modding
-- MOD date: 25.11.2018
--
-- Copyright (C) Slavo LS Modding
--


PlayerCamera = {};

function PlayerCamera:loadMap(name)
    if self.initialized then
        return;
    end;

    self.initialized = true;
    self.step = 0.2;
    self.minFovY = 0.005;
    self.maxFovY = 2.2;

end;

function PlayerCamera:deleteMap()
    self.initialized = false;
end;

function PlayerCamera:delete()
end;

function PlayerCamera:update(dt)

	if self.cameraId and self.finalFovY ~= nil then
		self.nowFovY = getFovY(self.cameraId);

		if self.updateFovY == "zoomPlus" then
			if self.finalFovY < self.nowFovY then
				setFovY(self.cameraId, self.nowFovY - 0.01);
			else
				self.updateFovY = false;
			end;
		end;

		if self.updateFovY == "zoomMinus" then
			if self.finalFovY > self.nowFovY then
				setFovY(self.cameraId, self.nowFovY + 0.01);
			else
				self.updateFovY = false;
			end;
		end;

	end;

	if self.cameraId and self.finalCamY ~= nil then

		self.nowCamY = g_currentMission.player.camY;

		if self.updateCamY == "posUp" then
			if self.finalCamY > self.nowCamY then
				g_currentMission.player.camY = self.nowCamY + 0.01;
			else
				self.updateCamY = false;
			end;
		end;

		if self.updateCamY == "posDown" then
			if self.finalCamY < self.nowCamY then
				g_currentMission.player.camY = self.nowCamY - 0.01;
			else
				self.updateCamY = false;
			end;
		end;

	end;

end;

function PlayerCamera:mouseEvent(posX, posY, isDown, isUp, button)

	if g_currentMission.controlledVehicle then

		self.cameraId = getCamera();

	else

		if g_currentMission.controlPlayer then
			if(g_currentMission.player ~= nil)then
				
				self.cameraId = g_currentMission.player.cameraNode;

				if self.defaultFovY == nil then
					self.defaultFovY = getFovY(self.cameraId);
				end;

				if self.defaultCamY == nil then
					self.defaultCamY = g_currentMission.player.camY;
				end;

			end;
		end;

	end;

	if self.cameraId ~= nil then

		self.newFovy = getFovY(self.cameraId);		

		if Input.isMouseButtonPressed(Input.MOUSE_BUTTON_RIGHT) then
			if Input.isMouseButtonPressed(Input.MOUSE_BUTTON_WHEEL_UP) then
				self.finalFovY = self.newFovy - self.step;
				if(self.finalFovY > self.minFovY) then
					self.updateFovY = "zoomPlus";
				else
					self.updateFovY = false;
					self.finalFovY = self.minFovY;
				end;
			end;

			if Input.isMouseButtonPressed(Input.MOUSE_BUTTON_WHEEL_DOWN) then		
				self.finalFovY = self.newFovy + self.step;
				if(self.finalFovY < self.maxFovY) then
					self.updateFovY = "zoomMinus";
				else
					self.updateFovY = false;
					self.finalFovY = self.maxFovY;
				end;
			end;
		end;

		if Input.isMouseButtonPressed(Input.MOUSE_BUTTON_MIDDLE) then

			self.finalFovY = self.defaultFovY;
			if(self.finalFovY > self.newFovy) then
				self.updateFovY = "zoomMinus";
			end;
			if(self.finalFovY < self.newFovy) then
				self.updateFovY = "zoomPlus";
			end;

			self.finalCamY = self.defaultCamY;
			if(self.finalCamY > g_currentMission.player.camY) then
				self.updateCamY = "posUp";
			end;
			if(self.finalCamY < g_currentMission.player.camY) then
				self.updateCamY = "posDown";
			end;

		end;

	end;

	if not Input.isMouseButtonPressed(Input.MOUSE_BUTTON_RIGHT) then
		if g_currentMission.controlPlayer then
			if Input.isMouseButtonPressed(Input.MOUSE_BUTTON_WHEEL_UP) then
				self.finalCamY = g_currentMission.player.camY + self.step * 3;
				self.updateCamY = "posUp";
			end;
			if Input.isMouseButtonPressed(Input.MOUSE_BUTTON_WHEEL_DOWN) and g_currentMission.player.camY > 0 then		
				self.finalCamY = g_currentMission.player.camY - self.step * 3;
				self.updateCamY = "posDown";
			end;
		end;
	end;

end;

function PlayerCamera:keyEvent(unicode, sym, modifier, isDown)
end;

function PlayerCamera:draw()
end;

addModEventListener(PlayerCamera);

