--
-- PlayerCamera
--
-- MOD Author:  Slavo LS Modding
-- MOD date: 28.10.2016
--
-- > Copyright (C) Slavo LS Modding < --
--

print("  Loaded: PlayerCamera -- Slavo LS Modding --");

PlayerCamera = {};

function PlayerCamera:loadMap(name)
    if self.initialized then
        return;
    end;
	self.fovAngle = 60;
    self.newFovy = 60;
    self.zrychlenie = 0.5;
    self.step = 5;
    self.initialized = true;
    self.uf = false;

    self.updateSlnko = true;
    self.NasobicSlnka = 3;
	self.slnkoID = g_currentMission.environment.sunLightId;
end;

function PlayerCamera:deleteMap()
    self.initialized = false;
end;

function PlayerCamera:delete()
end;

function PlayerCamera:update(dt)

	if(self.uf == true) then
		--self.fovAngle = getFovy(self.cameraId);
		if(self.hore == true) then
			if(self.fovAngle > self.newFovy) then
				if(self.CameraPlayer == false) then
					self.fovAngle = getFovy(self.cameraId);
					setFovy(self.cameraId, self.fovAngle-self.zrychlenie);
				else 
					self.fovAngle = getFovy(self.playerCamera);
					setFovy(self.playerCamera, self.fovAngle-self.zrychlenie);
				end;
			else
				self.uf = false;
			end;
		else
			if(self.fovAngle < self.newFovy) then
				if(self.CameraPlayer == false) then
					self.fovAngle = getFovy(self.cameraId);
					setFovy(self.cameraId, self.fovAngle+self.zrychlenie);
				else
					self.fovAngle = getFovy(self.playerCamera);
					setFovy(self.playerCamera, self.fovAngle+self.zrychlenie);
				end;
			else
				self.uf = false;
			end;
		end;
	end;

    if(self.updateSlnko) then
    	local r,g,b = getLightColor(self.slnkoID);
		local dayMinutes = g_currentMission.environment.dayTime/(60000);
		local den = (dayMinutes > (10*60) and dayMinutes < (18*60));
    	if (den) then 
    		setLightColor(self.slnkoID, r*self.NasobicSlnka, g*self.NasobicSlnka-0.3, b*self.NasobicSlnka-1);
    	end;

    end;
end;

function PlayerCamera:mouseEvent(posX, posY, isDown, isUp, button)

	if g_currentMission.controlledVehicle then
		self.CameraPlayer = false;
		self.cameraId = getCamera();
		self.newFovy = getFovy(self.cameraId);
		if self.cameraId ~= nil then
			if Input.isMouseButtonPressed(Input.MOUSE_BUTTON_RIGHT) then

				--self.updateSlnko = not self.updateSlnko;

				self.uf = true;
				self.fovAngle = getFovy(self.cameraId);
				
				if Input.isMouseButtonPressed(Input.MOUSE_BUTTON_WHEEL_UP) and self.fovAngle > 2 then
					self.hore = true;
					--setFovy(self.cameraId, self.fovAngle-0.5);
					self.newFovy = self.fovAngle-self.step;
				end;
				if Input.isMouseButtonPressed(Input.MOUSE_BUTTON_WHEEL_DOWN) and self.fovAngle < 178 then		
					self.hore = false;
					--setFovy(self.cameraId, self.fovAngle+0.5);
					self.newFovy = self.fovAngle+self.step;
				end;
			end;
		else
			self.uf = false;
		end;
	end;

	if g_currentMission.controlPlayer then
		if(g_currentMission.player ~= nil)then
			self.CameraPlayer = true;

			self.playerCamera = g_currentMission.player.cameraNode;
			self.newFovy = getFovy(self.playerCamera);
			if Input.isMouseButtonPressed(Input.MOUSE_BUTTON_RIGHT) then
				self.uf = true;
				self.fovAngle = getFovy(self.playerCamera);
				
				if Input.isMouseButtonPressed(Input.MOUSE_BUTTON_WHEEL_UP) and self.fovAngle > 2 then
					self.hore = true;
					self.newFovy = self.fovAngle-self.step;
				end;
							
				if Input.isMouseButtonPressed(Input.MOUSE_BUTTON_WHEEL_DOWN) and self.fovAngle < 178 then		
					self.hore = false;
					self.newFovy = self.fovAngle+self.step;
				end;	
				
				--if Input.isMouseButtonPressed(Input.MOUSE_BUTTON_MIDDLE) then	
				--	setFovy(self.playerCamera, self.fovAngleBackup)		
				--end;			
			else
				if Input.isMouseButtonPressed(Input.MOUSE_BUTTON_WHEEL_UP) and g_currentMission.player.camY > -0.7 then
					g_currentMission.player.camY = g_currentMission.player.camY-0.4;
				end;
				
				if Input.isMouseButtonPressed(Input.MOUSE_BUTTON_WHEEL_DOWN) then		
					g_currentMission.player.camY = g_currentMission.player.camY+0.4;
				end;
				
				--if Input.isMouseButtonPressed(Input.MOUSE_BUTTON_MIDDLE) then
				--	g_currentMission.player.camY = self.playerCamYBackup;			
				--end;
			end;
		end;
	end;

end;

function PlayerCamera:keyEvent(unicode, sym, modifier, isDown)
end;

function PlayerCamera:draw()
end;

addModEventListener(PlayerCamera);

