--
-- weight
-- LS UK Modteam
--
-- author Henly20
-- date  20/11/2010
--

weight = {};

function weight.prerequisitesPresent(specializations)
    return true;
end;

function weight:load(savegame)

    self.setWeightVisibility = SpecializationUtil.callSpecializationsFunction("setWeightVisibility");

      self.weightShows = {};
      local i = 0;
      while true do
          local key = string.format("vehicle.weightShows.weightShow(%d)", i);
          if not hasXMLProperty(xmlFile, key) then
              break;
          end;
          local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
          if node ~= nil then
              setVisibility(node, true);
              table.insert(self.weightShows, {node=node});
          end;
          i = i + 1;
      end;
      

end;

function weight:delete()

end;

function weight:readStream(streamId, connection)
    self.isLoading = true;
    local visibility = streamReadBool(streamId);
    self:setWeightVisibility(visibility, true);

    
end;

function weight:writeStream(streamId, connection)
    streamWriteBool(streamId, self.weightShowsActive);

    
end;

function weight:mouseEvent(posX, posY, isDown, isUp, button)
end;

function weight:keyEvent(unicode, sym, modifier, isDown)
end;

function weight:update(dt)

      if self:getIsActiveForInput() and self.isClient then
          if InputBinding.hasEvent(InputBinding.WEIGHT) then
              self:setWeightVisibility(not self.weightShowsActive);
          end;
    end;
end;

function weight:updateTick(dt)



end;

function weight:onLeave()

end;

function weight:draw()

end;

function weight:setWeightVisibility(visibility, noEventSend)
      if visibility ~= self.weightShowsActive then
  
          if noEventSend == nil or noEventSend == false then
              if g_server ~= nil then
                  g_server:broadcastEvent(SetWeightEvent:new(self, visibility), nil, nil, self);
              else
                  g_client:getServerConnection():sendEvent(SetWeightEvent:new(self, visibility));
              end;
          end;
  
          self.weightShowsActive = visibility;
  
          for _, weightShow in pairs(self.weightShows) do
             setVisibility(weightShow.node, visibility);
          end;
          for _,v in pairs(self.specializations) do
              if v.setWeightVisibility ~= nil then
                 v.setWeightVisibility(self, visibility);
              end;
          end;
      end;
end;