--
-- manualIgnition
-- Specialization for manual Motor Ignition
--
-- @author  Templaer
-- @date  01/05/09
--
-- Modifikationen erst nach Rcksprache
-- Do not edit without my permission
--
-- Edited by Henly20 (ls-uk modteam) Made MP compatible

manualIgnition = {};

function manualIgnition.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function manualIgnition:load(savegame)
    -- Booleans
    self.ignitionKey = false;
    self.allowedIgnition = false;                                                  
    
    
      local aiMotorSound  = getXMLString(xmlFile, "vehicle.aiMotorSound#file");
      if aiMotorSound  ~= nil and aiMotorSound  ~= "" then
          aiMotorSound  = Utils.getFilename(aiMotorSound, self.baseDirectory);
          self.aiMotorSoundRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.aiMotorSound#radius"), 50);
          self.aiMotorSoundInnerRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.aiMotorSound#innerRadius"), 10);
          self.aiMotorSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.aiMotorSound#volume"), 1);
          self.aiMotorSound = createAudioSource("aiMotorSound", aiMotorSound, self.aiMotorSoundRadius, self.aiMotorSoundInnerRadius, self.aiMotorSoundVolume, 0);
          link(self.components[1].node, self.aiMotorSound);
          setVisibility(self.aiMotorSound, false);
      end;

    
    -- Backup Stop Sound volume
    self.motorStopSoundVolume2 = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorStopSound#volume"), 1.0);

    self.setIgnition = SpecializationUtil.callSpecializationsFunction("setIgnition");

    self.isMotorStarted = false;
    self.ignitionMode = 0;    

end;

function manualIgnition:delete()
end;

function manualIgnition:readStream(streamId, connection)
    self:setIgnition(streamReadInt8(streamId), true);
end;

function manualIgnition:writeStream(streamId, connection)
    streamWriteInt8(streamId, ignition);    
end;

function manualIgnition:mouseEvent(posX, posY, isDown, isUp, button)
end;

function manualIgnition:keyEvent(unicode, sym, modifier, isDown)
end;

function manualIgnition:update(dt)

    if self:getIsActiveForInput() then
        
            if InputBinding.hasEvent(InputBinding.IGNITIONKEY) then
                if self.ignitionMode > 1 then
                    self.ignitionMode = 0;
                end;
                self:setIgnition(math.abs(self.ignitionMode + 1));

            end;
      end;

end;

function manualIgnition:updateTick(dt)

    acceleration = -InputBinding.getAnalogInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
    if InputBinding.isAxisZero(acceleration) then
        acceleration = -InputBinding.getDigitalInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
    end;
    -- Does not execute when AI is activated
    if not self.isHired then
        -- Handles ignition key input
        -- Mutes stop sound when engine is off
        if not self.ignitionKey or not self.deactivateOnLeave then
            self.motorStopSoundVolume = 0;
        else
            self.motorStopSoundVolume = self.motorStopSoundVolume2;
        end;
                                
        if self.ignitionKey and self.allowedIgnition then    
            self:startMotor(true);
            self.allowedIgnition = false;
            self.deactivateOnLeave = false;
            self.steeringEnabled = true;
            Utils.setEmittingState(self.exhaustParticleSystems, true)
        elseif not self.ignitionKey and self.allowedIgnition then
            if self.motorStopSoundVolume == 0 then
                self.motorStopSoundVolume = self.motorStopSoundVolume2;
            end;
            
            self:stopMotor(true);
            self.allowedIgnition = false;
            self.steeringEnabled = false;
            self.deactivateOnLeave = true;
            setVisibility(self.aiMotorSound, false);
            
            -- Brakes the wheels upon turning off the engine
            for k,wheel in pairs(self.wheels) do
                setWheelShapeProps(wheel.node, wheel.wheelShape, 0, self.motor.brakeForce, 0);
            end;
            self:onDeactivateAttachements();
        end;
        
    -- Prevents the AI from driving when engine is off
    elseif not self.ignitionKey and not self.deactivateOnLeave then
        WheelsUtil.updateWheelsPhysics(self, dt, self.lastSpeed, 0, false, 0);
    end;


end;

function manualIgnition:onLeave()
    if not self.deactivateOnLeave then
        Utils.setEmittingState(self.exhaustParticleSystems, true)
        self.allowedIgnition = false;
        self.isMotorStarted = true;
        self.ignitionKey = true; 
        self.steeringEnabled = false;
        setVisibility(self.aiMotorSound, true);
        
        -- Brakes the wheels upon turning off the engine
          self.lastAcceleration = 0;
          if self.isServer then
              for k,wheel in pairs(self.wheels) do
                  setWheelShapeProps(wheel.node, wheel.wheelShape, 0, self.motor.brakeForce, 0);
              end;
          end;
    else
        self.allowedIgnition = false;
        self.ignitionKey = false;
    end;    
end;

function manualIgnition:onEnter()
    -- Prevents the engine from starting upon entering
    if not self.ignitionKey then
        self.isMotorStarted = false;
        Motorized.stopSounds(self);
        self.steeringEnabled = false;
        Utils.setEmittingState(self.exhaustParticleSystems, false)
        setVisibility(self.aiMotorSound, false);
    else
        self.steeringEnabled = true;
    setVisibility(self.aiMotorSound, true);
    end;
    
    setVisibility(self.aiMotorSound, false);
end;

function manualIgnition:draw()
end;

function manualIgnition:setIgnition(ignition, noEventSend)
    IgnitionEvent.sendEvent(self, ignition, noEventSend);

    self.ignitionMode = ignition;
    
    self.ignitionKey = false;
    self:stopMotor(true);
    self.allowedIgnition = false;
    self.steeringEnabled = false;
    self.deactivateOnLeave = true;
    setVisibility(self.aiMotorSound, false);
    self.lastAcceleration = 0;
    if self.isServer then
          for k,wheel in pairs(self.wheels) do
               setWheelShapeProps(wheel.node, wheel.wheelShape, 0, self.motor.brakeForce, 0);
          end;
    end;

    if self.ignitionMode == 0 then
        self.ignitionKey = false;
        self.allowedIgnition = false;  
        self.isMotorStarted = false;
    end;
    if self.ignitionMode == 1 then
        self.allowedIgnition = true;
        self.ignitionKey = true;
    end;
    if self.ignitionMode > 1 then
        self.ignitionMode = 0;
    end;

        if self.ignitionKey and self.allowedIgnition then    
            self:startMotor(true);
            self.allowedIgnition = false;
            self.deactivateOnLeave = false;
            self.steeringEnabled = true;
            Utils.setEmittingState(self.exhaustParticleSystems, true)
        elseif not self.ignitionKey and self.allowedIgnition then
            if self.motorStopSoundVolume == 0 then
                self.motorStopSoundVolume = self.motorStopSoundVolume2;
            end;
            
            self:stopMotor(true);
            self.allowedIgnition = false;
            self.steeringEnabled = false;
            self.deactivateOnLeave = true;
            setVisibility(self.aiMotorSound, false);
            
            -- Brakes the wheels upon turning off the engine
            for k,wheel in pairs(self.wheels) do
                setWheelShapeProps(wheel.node, wheel.wheelShape, 0, self.motor.brakeForce, 0);
            end;
            self:onDeactivateAttachements();
        end;
end;

IgnitionEvent = {};
IgnitionEvent_mt = Class(IgnitionEvent, Event);

InitEventClass(IgnitionEvent, "IgnitionEvent");

function IgnitionEvent:emptyNew()
    local self = Event:new(IgnitionEvent_mt);
    self.className="IgnitionEvent";
    return self;
end;

function IgnitionEvent:new(vehicle, ignition)
    local self = IgnitionEvent:emptyNew()
    self.vehicle = vehicle;
    self.ignition = ignition;
    return self;
end;

function IgnitionEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.ignition = streamReadInt8(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function IgnitionEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));    
    streamWriteInt8(streamId, self.ignition);    
end;

function IgnitionEvent:run(connection)
    self.vehicle:setIgnition(self.ignition, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(IgnitionEvent:new(self.vehicle, self.ignition), nil, connection, self.object);
    end;
end;
function IgnitionEvent.sendEvent(vehicle, ignition, noEventSend)
    if noEventSend == nil or noEventSend == false then
        if g_server ~= nil then
            g_server:broadcastEvent(IgnitionEvent:new(vehicle, ignition), nil, nil, vehicle);
        else
            g_client:getServerConnection():sendEvent(IgnitionEvent:new(vehicle, ignition));
        end;
    end;
end;

