														-- Konwert do FS17: RomeG --
															  -- 26.11.2016 -- 
															-- Zapraszam na: --
							-- http://fb.com/RomeGTV http://hitbox.tv/RomeG oraz http://farming-simulator.eu --
							
gaz = {};

function gaz.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;
	    
function gaz:load(selfxmlFile) 
    local rotationPartNodepedalgazu = Utils.indexToObject(self.rootNode, getXMLString(self.xmlFile, "vehicle.pedal_gazu#index"));
    if rotationPartNodepedalgazu ~= nil then
		self.rotationPartpedalgazu = {};
        self.rotationPartpedalgazu.node = rotationPartNodepedalgazu;
 
        local x, y, z = Utils.getVectorFromString(getXMLString(self.xmlFile, "vehicle.pedal_gazu#minRot"));
        self.rotationPartpedalgazu.minRot = {};
        self.rotationPartpedalgazu.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartpedalgazu.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartpedalgazu.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
 
        x, y, z = Utils.getVectorFromString(getXMLString(self.xmlFile, "vehicle.pedal_gazu#maxRot"));
        self.rotationPartpedalgazu.maxRot = {};
        self.rotationPartpedalgazu.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartpedalgazu.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartpedalgazu.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
 
        self.rotationPartpedalgazu.rotTime = Utils.getNoNil(getXMLString(self.xmlFile, "vehicle.pedal_gazu#rotTime"), 2)*1000;
        self.rotationPartpedalgazu.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(self.xmlFile, "vehicle.pedal_gazu#touchRotLimit"), 10));
    end;
end;
function gaz:delete()
end;

function gaz:mouseEvent(posX, posY, isDown, isUp, button)
end;

function gaz:keyEvent(unicode, sym, modifier, isDown) 
end;
 
function gaz:update(dt)  
	if self.isMotorStarted then
        if Input.isKeyPressed(Input.KEY_w) or Input.isKeyPressed(Input.KEY_s) then
            self.rotationMaxpedalgazu = true;
        else
            self.rotationMaxpedalgazu = false;
		end;
		if self.rotationPartpedalgazu ~= nil then
            local x, y, z = getRotation(self.rotationPartpedalgazu.node);
            local rot = {x,y,z};
            local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartpedalgazu.maxRot, self.rotationPartpedalgazu.minRot, 3, self.rotationPartpedalgazu.rotTime, dt, not self.rotationMaxpedalgazu);
            setRotation(self.rotationPartpedalgazu.node, unpack(newRot));
		end;            
	end;      
end;
function gaz:draw()
end;