   --<Attribute name="onCreate" type="scriptCallback" value="modOnCreate.MapSpeedTriggerOnCreate"/>


ModEventSpeedTrigger = {};

ModEventSpeedTrigger.speedTrigger = {};

function ModEventSpeedTrigger:loadMap(name)
end;

function ModEventSpeedTrigger:deleteMap()	
	ModEventSpeedTrigger.speedTrigger = {};
end;

function ModEventSpeedTrigger:delete()
end;

function ModEventSpeedTrigger:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ModEventSpeedTrigger:keyEvent(unicode, sym, modifier, isDown)
end;

function ModEventSpeedTrigger:update(dt)
end;

function ModEventSpeedTrigger:draw()
	for i=1, table.getn(ModEventSpeedTrigger.speedTrigger) do
		ModEventSpeedTrigger.speedTrigger[i]:draw();
	end;
end;
addModEventListener(ModEventSpeedTrigger);

----
MapSpeedTrigger ={};

local MapSpeedTrigger_mt = Class(MapSpeedTrigger, Object);
function MapSpeedTrigger.onCreate(id)
    local speedt = MapSpeedTrigger:new(g_server ~= nil, g_client ~= nil);
    local index = g_currentMission:addOnCreateLoadedObject(speedt);
    speedt:load(id);
    speedt:register(true);
	table.insert(ModEventSpeedTrigger.speedTrigger, speedt);
end;



function MapSpeedTrigger:new(isServer, isClient)
    local self = Object:new(isServer, isClient, MapSpeedTrigger_mt);
    self.className = "MapSpeedTrigger";
    return self;
end;

function MapSpeedTrigger:load(id)
	self.id = id;
	self.maxAllowedkmh = getUserAttribute(id, "maxAllowedkmh");
	self.toFastPrize = getUserAttribute(id, "prizePerkmhToFast");
	self.triggerId = id;
	addTrigger(self.triggerId, "TriggerCallback", self);
	self.drawKnoellchen = false;
	self.lastPrize = 0;
	self.myTimer = 0;
	self.myTimerBackup = 3500;
	self.toFast = 0;
end;

function MapSpeedTrigger:mouseEvent(posX, posY, isDown, isUp, button)
end;

function MapSpeedTrigger:keyEvent(unicode, sym, modifier, isDown)
end;

function MapSpeedTrigger:deleteMap()
end;

function MapSpeedTrigger:delete()
    removeTrigger(self.triggerId);
end;

function MapSpeedTrigger:TriggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	if onEnter then
		local vehicle = g_currentMission.nodeToVehicle[otherShapeId];
		if vehicle ~= nil then
			if vehicle.isEntered and vehicle.motor ~= nil then
				local kmh = math.min(100, math.max(0, vehicle.lastSpeed*vehicle.speedDisplayScale*3600));
				if kmh > self.maxAllowedkmh then
					local toFast = kmh - self.maxAllowedkmh;
					self.toFast = math.floor(toFast);
					self.lastPrize = toFast * self.toFastPrize;
					if g_server ~= nil then
						g_currentMission:addSharedMoney(-self.lastPrize);
					end;
					if g_currentMission.controlledVehicle == vehicle then
						self.drawKnoellchen = true;
						self.myTimer = self.myTimerBackup;
					end;
				end;
			end;
		end;
	end;
end;

function MapSpeedTrigger:update(dt)
	if self.myTimer > 0 then
		self.myTimer = self.myTimer - dt;
		if self.myTimer <= 0 then
			self.drawKnoellchen = false;
		end; 
	end;
end;

function MapSpeedTrigger:draw()
	if self.drawKnoellchen then
		g_currentMission:showBlinkingWarning(g_i18n:getText("youWereToFast").." "..tostring(self.toFast)..g_i18n:getText("andHaveToPay").." "..tostring(math.floor(self.lastPrize))..g_i18n:getText("euro"),3000); 
	end;
end;

g_onCreateUtil.addOnCreateFunction("MapSpeedTriggerOnCreate", MapSpeedTrigger.onCreate);