-- 
-- customLivestockTrailer 07/11/2016
-- Giants/(edit)Neurotek
-- 





function LivestockTrailer:load(savegame)
	
	    self.setUnitFillLevel = Utils.overwrittenFunction(self.setUnitFillLevel, LivestockTrailer.setUnitFillLevel);
	    self.getCapacity = Utils.overwrittenFunction(self.getCapacity, LivestockTrailer.getCapacity);
	
	    self.livestockTrailer = {};
	    self.livestockTrailer.fillUnitIndex = Utils.getNoNil(getXMLInt(self.xmlFile, "vehicle.livestockTrailer#fillUnitIndex"), 1);
	
	    self:setUnitCapacity(self.livestockTrailer.fillUnitIndex, 0);
	    self.animalPlaces = {};
	
	    local i=0;
	    while true do
	        local key = string.format("vehicle.liveStockTrailer.animal(%d)", i);
	        if not hasXMLProperty(self.xmlFile, key) then
	            break;
	        end
	        local animalName = getXMLString(self.xmlFile, key .. "#type");
	        local animalDesc = AnimalUtil.animals[animalName];
	        if animalDesc == nil then
	            print("Warning: animal type '"..tostring(animalName) .. "' could not be found!");
	            break;
	        end
	
	        local filename = getXMLString(self.xmlFile, key .. "#filename");
	        if filename == nil then
	            if animalName == "pig" then
	                filename = "$dataS2/character/pig/pigLoaded.i3d";
	            elseif animalName == "sheep" then
	                filename = "$dataS2/character/sheep/sheepLoaded.i3d";
	            elseif animalName == "cow" then
	                filename = "$dataS2/character/cow/cowLoaded.i3d";
	            end
	        end
	        local i3dNode = Utils.loadSharedI3DFile(filename, self.baseDirectory, false, false, false);
	        local node;
	        if i3dNode == 0 then
	            print("Warning: Could not load file '"..tostring(filename).."' for animal type '"..tostring(animalName).."'");	        else
	            node = getChildAt(i3dNode, 0);
	        end
	
	        local places = {};
	        local parent = Utils.indexToObject(self.components, getXMLString(self.xmlFile, key .. "#index"));
	        local numChildren = getNumOfChildren(parent);
	        for i=0,numChildren-1 do
	            local child = getChildAt(parent, i);
	            if node ~= nil then
	                local animal = clone(node, false, false, false);
	                link(child, animal);
	            end
	            setVisibility(child, false);
	            table.insert(places, {node=child, used=false});
	        end
	        self:setUnitCapacity(self.livestockTrailer.fillUnitIndex, math.max(self:getUnitCapacity(self.livestockTrailer.fillUnitIndex), table.getn(places)));
	
	        self.animalPlaces[animalDesc.fillType] = places;
	        i=i+1;
	    end
	
	    -- needed to make network sync. functions in Fillable.lua work correctly
	    self.synchronizeFullFillLevel = true;
	
	    self.animalTrigger = nil
	
	    self.LivestockTrailerDirtyFlag = self:getNextDirtyFlag();
	end

function LivestockTrailer:postLoad(savegame)
	    if savegame ~= nil then
	        if hasXMLProperty(savegame.xmlFile, savegame.key.."#fillLevels") and hasXMLProperty(savegame.xmlFile, savegame.key.."#fillTypes") then
	            local fillLevels = { Utils.getVectorFromString(Utils.getNoNil(getXMLString(savegame.xmlFile, savegame.key.."#fillLevels"), "")) };
	            local fillTypes = Utils.splitString(" ", Utils.getNoNil(getXMLString(savegame.xmlFile, savegame.key.."#fillTypes"), ""));
	
	            local i = self.livestockTrailer.fillUnitIndex;
	            if fillTypes[i] ~= nil and fillLevels[i] ~= nil then
	                local fillType = FillUtil.fillTypeNameToInt[ fillTypes[i] ];
	                self:setFillLevel(0, fillType, true, nil);  -- call function twice to make animal nodes visible
                self:setFillLevel(fillLevels[i], fillType, true, nil);
            end
	        end
	    end
	
	end

function LivestockTrailer:delete()
	    if self.animalTrigger ~= nil then
	        self.animalTrigger:setLoadingTrailer(nil)
	    end
	end

function LivestockTrailer:setUnitFillLevel(superFunc, fillUnitIndex, fillLevel, fillType, force, fillInfo)
	
	    if fillUnitIndex ~= self.livestockTrailer.fillUnitIndex then
	        superFunc(self, fillUnitIndex, fillLevel, fillType, force, fillInfo)
	    else
	
	        -- first, let's empty the trailer completely
	        for fillType,places in pairs(self.animalPlaces) do
	            for j=1,table.getn(places) do
	                places[j].used = false;
	                setVisibility(places[j].node, false);
	            end
	        end
	
	        -- now, let's fill the trailer
	        if self.animalPlaces[fillType] ~= nil then
	            self:setUnitCapacity(self.livestockTrailer.fillUnitIndex, table.getn(self.animalPlaces[fillType]));

            local places = self.animalPlaces[fillType];
	
	            for i=1,fillLevel do
	                local index = math.random(1, self:getUnitCapacity(self.livestockTrailer.fillUnitIndex));
	                if not places[index].used then
	                    places[index].used = true;
	                    setVisibility(places[index].node, true);
                    local animalNode = getChildAt(places[index].node, 0);
                    setShaderParameter(animalNode, "RDT", 1, math.random(), 20, 20, false);
	                    setShaderParameter(animalNode, "mirrorScaleAndOffsetUV", 0.5, 0.5, math.random(0, 1), math.random(0, 1), false);
	                    setShaderParameter(animalNode, "atlasInvSizeAndOffsetUV", 1, 1, 0, 0, false);
	                else
	                    for j=1,table.getn(places) do
                        index = index + 1;
                        if index > table.getn(places) then
                            index = 1;
                        end
	                        if not places[index].used then
	                            places[index].used = true;
	                            setVisibility(places[index].node, true);
	                            local animalNode = getChildAt(places[index].node, 0);
	                            setShaderParameter(animalNode, "RDT", 1, math.random(), 20, 20, false);
	                            setShaderParameter(animalNode, "mirrorScaleAndOffsetUV", 0.5, 0.5, math.random(0, 1), math.random(0, 1), false);
	                            setShaderParameter(animalNode, "atlasInvSizeAndOffsetUV", 1, 1, 0, 0, false);
	                            break;
	                        end
	                    end
	                end
	            end
        end
	
	        superFunc(self, fillUnitIndex, fillLevel, fillType, force, fillInfo);
	
	    end
	end

function LivestockTrailer:getCapacity(superFunc, fillType)
	    if self.animalPlaces[fillType] ~= nil then
	        return table.getn(self.animalPlaces[fillType]);
	    else
	        return superFunc(self);
	    end
	end
