--
-- ManureCultivator
-- Class for all ManureCultivators
--
-- @author  Stefan Geiger
-- @date  04/02/08
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

ManureCultivator = {};

function ManureCultivator.prerequisitesPresent(specializations)
    return true;
end;

function ManureCultivator:load(savegame)


    local numCuttingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.sprayCuttingAreas#count"), 0);
    self.sprayCuttingAreas = {}
    for i=1, numCuttingAreas do
        self.sprayCuttingAreas[i] = {};
        local areanamei = string.format("vehicle.sprayCuttingAreas.cuttingArea%d", i);
        self.sprayCuttingAreas[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
        self.sprayCuttingAreas[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
        self.sprayCuttingAreas[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
    end;

end;

function ManureCultivator:delete()
end;

function ManureCultivator:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ManureCultivator:keyEvent(unicode, sym, modifier, isDown)
end;

function ManureCultivator:update(dt)
end;

function ManureCultivator:draw()
end;