-- fendtvarioxSeries.lua
-- Script for Fendt 1000 Vario
--
-- Author Steph33
-- 23.11.2016
-- Version 1.0 @23.11.2016
	--> indoorsound change when door/roof/box/windows are open

fendtvarioxSeries = {};

function fendtvarioxSeries.prerequisitesPresent(specializations)
    return true;
end;

function fendtvarioxSeries:load(savegame)
	self.soundAdj = {};
	local i=0;
    while true do
        local key = string.format("vehicle.indoorsoundAdjustment.animation(%d)", i);
        if not hasXMLProperty(self.xmlFile, key) then
            break;
        end;
        local animName = getXMLString(self.xmlFile, key.."#name");
        local lowpassGain = Utils.getNoNil(getXMLFloat(self.xmlFile, key.."#lowpassGain"), 0.5);
        local volumeFactor = Utils.getNoNil(getXMLFloat(self.xmlFile, key.."#volumeFactor"), 0.5);
		self.soundAdj[i] = {};
		self.soundAdj[i].animName = animName;
		self.soundAdj[i].volumeFactor = volumeFactor;
		self.soundAdj[i].lowpassGain = lowpassGain;
        i = i +1;
    end;
	
	if self.isClient then
		self.sampleOpenDoorL = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.openDoorSound", "Sounds/tuer_auf.wav", self.baseDirectory, self.components[1].node);
		self.sampleCloseDoorL = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.closeDoorSound", "Sounds/tuer_zu2.wav", self.baseDirectory, self.components[1].node);
		self.sampleOpenDoorR = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.openDoorSound", "Sounds/tuer_auf.wav", self.baseDirectory, self.components[1].node);
		self.sampleCloseDoorR = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.closeDoorSound", "Sounds/tuer_zu2.wav", self.baseDirectory, self.components[1].node);
		self.sampleOpenRoof = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.openRoofSound", "Sounds/tuer_auf.wav", self.baseDirectory, self.components[1].node);
		self.sampleCloseRoof = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.closeRoofSound", "Sounds/tuer_zu2.wav", self.baseDirectory, self.components[1].node);
		self.sampleOpenBox = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.openBoxSound", "Sounds/tuer_zu.wav", self.baseDirectory, self.components[1].node);
		self.sampleCloseBox = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.closeBoxSound", "Sounds/tuer_zu2.wav", self.baseDirectory, self.components[1].node);
		self.sampleOpenSeat = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.openSeatSound", "Sounds/seat.wav", self.baseDirectory, self.components[1].node);
		self.sampleCloseSeat = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.closeSeatSound", "Sounds/seat.wav", self.baseDirectory, self.components[1].node);
		self.sampleOpenSunvisor = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.openSunvisorSound", "Sounds/store.wav", self.baseDirectory, self.components[1].node);
		self.sampleCloseSunvisor = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.closeSunvisorSound", "Sounds/store.wav", self.baseDirectory, self.components[1].node);
		self.sampleOpenDaschboard = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.openDaschboardSound", "Sounds/daschboard.wav", self.baseDirectory, self.components[1].node);
		self.sampleCloseDaschboard = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.closeDaschboardSound", "Sounds/daschboard.wav", self.baseDirectory, self.components[1].node);
	end;
end;
--function fendtvarioxSeries:postLoad(savegame)
--	for k,v in pairs(self.sampleMotor) do print(k,v) end
--end;
function fendtvarioxSeries:delete()
	if self.sampleOpenDoorL ~= nil then
		SoundUtil.deleteSample(self.sampleOpenDoorL);
	end;
	if self.sampleOpenDoorR ~= nil then
		SoundUtil.deleteSample(self.sampleOpenDoorR);
	end;
	if self.sampleOpenRoof ~= nil then
		SoundUtil.deleteSample(self.sampleOpenRoof);
	end;
	if self.sampleOpenBox ~= nil then
		SoundUtil.deleteSample(self.sampleOpenBox);
	end;
	if self.sampleOpenSeat ~= nil then
		SoundUtil.deleteSample(self.sampleOpenSeat);
	end;
	if self.sampleOpenSunvisor ~= nil then
		SoundUtil.deleteSample(self.sampleOpenSunvisor);
	end;
	if self.sampleOpenDaschboard ~= nil then
		SoundUtil.deleteSample(self.sampleOpenDaschboard);
	end;
	if self.sampleCloseDoorL ~= nil then
		SoundUtil.deleteSample(self.sampleCloseDoorL);
	end;
	if self.sampleCloseDoorR ~= nil then
		SoundUtil.deleteSample(self.sampleCloseDoorR);
	end;
	if self.sampleCloseRoof ~= nil then
		SoundUtil.deleteSample(self.sampleCloseRoof);
	end;
	if self.sampleCloseBox ~= nil then
		SoundUtil.deleteSample(self.sampleCloseBox);
	end;
	if self.sampleCloseSeat ~= nil then
		SoundUtil.deleteSample(self.sampleCloseSeat);
	end;
	if self.sampleCloseSunvisor ~= nil then
		SoundUtil.deleteSample(self.sampleCloseSunvisor);
	end;
	if self.sampleCloseDaschboard ~= nil then
		SoundUtil.deleteSample(self.sampleCloseDaschboard);
	end;
end;
function fendtvarioxSeries:mouseEvent(posX, posY, isDown, isUp, button)
end;
function fendtvarioxSeries:keyEvent(unicode, sym, modifier, isDown)
end;
function fendtvarioxSeries:update(dt)
    if self:getIsActive() and self.isClient then
		if self.isEntered then
			if self:getIsAnimationPlaying("doorLeftSource") and self:getIsActiveForSound() then
				if self.animations["doorLeftSource"].currentSpeed > 0 and self.animations["doorLeftSource"].currentTime < 50 then
					if not SoundUtil.isSamplePlaying(self.sampleOpenDoorL, 1.5*dt) then
						SoundUtil.playSample(self.sampleOpenDoorL,1,1,nil);
					end;
				elseif self.animations["doorLeftSource"].currentSpeed < 0 and self.animations["doorLeftSource"].currentTime < 100 then
					if not SoundUtil.isSamplePlaying(self.sampleCloseDoorL, 1.5*dt) then
						SoundUtil.playSample(self.sampleCloseDoorL,1,1,nil);
					end;
				end;
			end;
			if self:getIsAnimationPlaying("doorRightSource") and self:getIsActiveForSound() then
				if self.animations["doorRightSource"].currentSpeed > 0 and self.animations["doorRightSource"].currentTime < 50 then
					if not SoundUtil.isSamplePlaying(self.sampleOpenDoorR, 1.5*dt) then
						SoundUtil.playSample(self.sampleOpenDoorR,1,1,nil);
					end;
				elseif self.animations["doorRightSource"].currentSpeed < 0 and self.animations["doorRightSource"].currentTime < 100 then
					if not SoundUtil.isSamplePlaying(self.sampleCloseDoorR, 1.5*dt) then
						SoundUtil.playSample(self.sampleCloseDoorR,1,1,nil);
					end;
				end;
			end;
			if self:getIsAnimationPlaying("roofSource") and self:getIsActiveForSound() then
				if self.animations["roofSource"].currentSpeed > 0 and self.animations["roofSource"].currentTime < 50 then
					if not SoundUtil.isSamplePlaying(self.sampleOpenRoof, 1.5*dt) then
						SoundUtil.playSample(self.sampleOpenRoof,1,1,nil);
					end;
				elseif self.animations["roofSource"].currentSpeed < 0 and self.animations["roofSource"].currentTime < 100 then
					if not SoundUtil.isSamplePlaying(self.sampleCloseRoof, 1.5*dt) then
						SoundUtil.playSample(self.sampleCloseRoof,1,1,nil);
					end;
				end;
			end;
			if self:getIsAnimationPlaying("boxSource") and self:getIsActiveForSound() then
				if self.animations["boxSource"].currentSpeed > 0 and self.animations["boxSource"].currentTime < 50 then
					if not SoundUtil.isSamplePlaying(self.sampleOpenBox, 1.5*dt) then
						SoundUtil.playSample(self.sampleOpenBox,1,1,nil);
					end;
				elseif self.animations["boxSource"].currentSpeed < 0 and self.animations["boxSource"].currentTime < 100 then
					if not SoundUtil.isSamplePlaying(self.sampleCloseBox, 1.5*dt) then
						SoundUtil.playSample(self.sampleCloseBox,1,1,nil);
					end;
				end;
			end;
			if self:getIsAnimationPlaying("seatSource") and self:getIsActiveForSound() then
				if self.animations["seatSource"].currentSpeed > 0 and self.animations["seatSource"].currentTime < 50 then
					if not SoundUtil.isSamplePlaying(self.sampleOpenSeat, 1.5*dt) then
						SoundUtil.playSample(self.sampleOpenSeat,1,1,nil);
					end;
				elseif self.animations["seatSource"].currentSpeed < 0 and self.animations["seatSource"].currentTime > 50 then
					if not SoundUtil.isSamplePlaying(self.sampleCloseSeat, 1.5*dt) then
						SoundUtil.playSample(self.sampleCloseSeat,1,1,nil);
					end;
				end;
			end;
			if self:getIsAnimationPlaying("sunvisorSource") and self:getIsActiveForSound() then
				if self.animations["sunvisorSource"].currentSpeed > 0 and self.animations["sunvisorSource"].currentTime < 50 then
					if not SoundUtil.isSamplePlaying(self.sampleOpenSunvisor, 1.5*dt) then
						SoundUtil.playSample(self.sampleOpenSunvisor,1,1,nil);
					end;
				elseif self.animations["sunvisorSource"].currentSpeed < 0 and self.animations["sunvisorSource"].currentTime > 50 then
					if not SoundUtil.isSamplePlaying(self.sampleCloseSunvisor, 1.5*dt) then
						SoundUtil.playSample(self.sampleCloseSunvisor,1,1,nil);
					end;
				end;
			end;
			if self:getIsAnimationPlaying("daschboardSource") and self:getIsActiveForSound() then
				if self.animations["daschboardSource"].currentSpeed > 0 and self.animations["daschboardSource"].currentTime < 50 then
					if not SoundUtil.isSamplePlaying(self.sampleOpenDaschboard, 1.5*dt) then
						SoundUtil.playSample(self.sampleOpenDaschboard,1,1,nil);
					end;
				elseif self.animations["daschboardSource"].currentSpeed < 0 and self.animations["daschboardSource"].currentTime > 50 then
					if not SoundUtil.isSamplePlaying(self.sampleCloseDaschboard, 1.5*dt) then
						SoundUtil.playSample(self.sampleCloseDaschboard,1,1,nil);
					end;
				end;
			end;
			local sound=false;
			for i=0, #self.soundAdj do
				if self.animations[self.soundAdj[i].animName] ~= nil and self.animations[self.soundAdj[i].animName].currentTime > 500 then
					self.sampleMotor.indoorVolumeFactor = math.max(self.soundAdj[i].volumeFactor, self.sampleMotor.indoorVolumeFactor);
					self.sampleMotor.indoorLowpassGain = math.max(self.soundAdj[i].lowpassGain, self.sampleMotor.indoorLowpassGain);
					self.sampleMotorStart.indoorVolumeFactor = math.max(self.soundAdj[i].volumeFactor, self.sampleMotorStart.indoorVolumeFactor);
					self.sampleMotorStart.indoorLowpassGain = math.max(self.soundAdj[i].lowpassGain, self.sampleMotorStart.indoorLowpassGain);
					self.sampleMotorStop.indoorVolumeFactor = math.max(self.soundAdj[i].volumeFactor, self.sampleMotorStop.indoorVolumeFactor);
					self.sampleMotorStop.indoorLowpassGain = math.max(self.soundAdj[i].lowpassGain, self.sampleMotorStop.indoorLowpassGain);
					
					self.sampleMotorRun.indoorVolumeFactor = math.max(self.soundAdj[i].volumeFactor, self.sampleMotorRun.indoorVolumeFactor);
					self.sampleMotorRun.indoorLowpassGain = math.max(self.soundAdj[i].lowpassGain, self.sampleMotorRun.indoorLowpassGain);
					self.sampleMotorLoad.indoorVolumeFactor = math.max(self.soundAdj[i].volumeFactor, self.sampleMotorLoad.indoorVolumeFactor);
					self.sampleMotorLoad.indoorLowpassGain = math.max(self.soundAdj[i].lowpassGain, self.sampleMotorLoad.indoorLowpassGain);
					sound=true;
				else
					if not sound then
						self.sampleMotor.indoorVolumeFactor = 0.55;
						self.sampleMotor.indoorLowpassGain = 0.2;
						self.sampleMotorStart.indoorVolumeFactor = 0.55;
						self.sampleMotorStart.indoorLowpassGain = 0.2;
						self.sampleMotorStop.indoorVolumeFactor = 0.55;
						self.sampleMotorStop.indoorLowpassGain = 0.2;
						
						self.sampleMotorRun.indoorVolumeFactor = 0.6;
						self.sampleMotorRun.indoorLowpassGain = 0.2;
						self.sampleMotorLoad.indoorVolumeFactor = 0.6;
						self.sampleMotorLoad.indoorLowpassGain = 0.2;
					end;
				end;
			end;
			SoundUtil.onCameraSwitched(self.activeCamera.isInside);
		end;
    end;
end;
function fendtvarioxSeries:updateTick(dt)
end;
function fendtvarioxSeries:draw()    
end;