-- MBtrac.lua
-- Original-Script for Fendt Farmer 310/312 LSA by Rival
-- renamed for MB tracs by Unguided
--
-- Author Rival | renamed Unguided
-- 05.01.2016 | 19.11.2016
-- Version 1.1 @26.10.2016
	--> converted to FS17
-- Version 1.2 @05.11.2016
	--> added indoorsound change when door/windows are open

MBtrac = {};

function MBtrac.prerequisitesPresent(specializations)
    return true;
end;

function MBtrac:load(savegame)
    self.blinkerLight0 = Utils.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.MBtracDisplay.blinkerLight#index0"));
    self.blinkerLight1 = Utils.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.MBtracDisplay.blinkerLight#index1"));
    self.blinkerLight2 = Utils.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.MBtracDisplay.blinkerLight#index2"));
    self.warnBlinkLight = Utils.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.MBtracDisplay.warnBlinkLight#index"));
    setVisibility(self.blinkerLight0, false);
    setVisibility(self.blinkerLight1, false);
    setVisibility(self.blinkerLight2, false);
    self.hasAttachedTrailers = 0;
	
	self.soundAdj = {};
	local i=0;
    while true do
        local key = string.format("vehicle.indoorsoundAdjustment.animation(%d)", i);
        if not hasXMLProperty(self.xmlFile, key) then
            break;
        end;
        local animName = getXMLString(self.xmlFile, key.."#name");
        local lowpassGain = Utils.getNoNil(getXMLFloat(self.xmlFile, key.."#lowpassGain"), 0.5);
        local volumeFactor = Utils.getNoNil(getXMLFloat(self.xmlFile, key.."#volumeFactor"), 0.5);
		self.soundAdj[i] = {};
		self.soundAdj[i].animName = animName;
		self.soundAdj[i].volumeFactor = volumeFactor;
		self.soundAdj[i].lowpassGain = lowpassGain;
        i = i +1;
    end;
end;
--function MBtrac:postLoad(savegame)
--	for k,v in pairs(self.sampleMotor) do print(k,v) end
--end;
function MBtrac:delete()
	if self.sampleOpenDoorL ~= nil then
		SoundUtil.deleteSample(self.sampleOpenDoorL);
	end;
	if self.sampleOpenDoorR ~= nil then
		SoundUtil.deleteSample(self.sampleOpenDoorR);
	end;
	if self.sampleCloseDoorL ~= nil then
		SoundUtil.deleteSample(self.sampleCloseDoorL);
	end;
	if self.sampleCloseDoorR ~= nil then
		SoundUtil.deleteSample(self.sampleCloseDoorR);
	end;
end;
function MBtrac:mouseEvent(posX, posY, isDown, isUp, button)
end;
function MBtrac:keyEvent(unicode, sym, modifier, isDown)
end;
function MBtrac:update(dt)
    if self:getIsActive() and self.isClient then
        if table.getn(self.attachedImplements) > 0 or self.hasAttachedTrailers > 0 then
            self.hasAttachedTrailers = 0;
            for i=1, table.getn(self.attachedImplements) do  
                if self.attachedImplements[i].object.hasTurnLights and self.attachedImplements[i].object.hasTurnLights then 
                    self.hasAttachedTrailers = self.hasAttachedTrailers + 1;
                end;
                if table.getn(self.attachedImplements[i].object.attachedImplements) > 0 then
                    for r=1, table.getn(self.attachedImplements[i].object.attachedImplements) do
                        if self.attachedImplements[i].object.attachedImplements[r].object.hasTurnLights and self.attachedImplements[i].object.attachedImplements[r].object.hasTurnLights then
                            self.hasAttachedTrailers = self.hasAttachedTrailers + 1;
                        end;
                    end;
                end;
            end;
        end;
        if self.hasAttachedTrailers == 0 then
            setVisibility(self.blinkerLight0, self.turnLightState ~= Lights.TURNLIGHT_OFF);
            setVisibility(self.blinkerLight1, false);
            setVisibility(self.blinkerLight2, false);
        elseif self.hasAttachedTrailers == 1 then
            setVisibility(self.blinkerLight0, self.turnLightState ~= Lights.TURNLIGHT_OFF);
            setVisibility(self.blinkerLight1, self.turnLightState ~= Lights.TURNLIGHT_OFF);
            setVisibility(self.blinkerLight2, false);
        elseif self.hasAttachedTrailers == 2 then
            setVisibility(self.blinkerLight0, self.turnLightState ~= Lights.TURNLIGHT_OFF);
            setVisibility(self.blinkerLight1, self.turnLightState ~= Lights.TURNLIGHT_OFF);
            setVisibility(self.blinkerLight2, self.turnLightState ~= Lights.TURNLIGHT_OFF);
        end;
        if self.turnLightState == Lights.TURNLIGHT_HAZARD then
            setVisibility(self.warnBlinkLight, true);
        else
            setVisibility(self.warnBlinkLight, false);
        end;
		if self.isEntered then
			local sound=false;
			for i=0, #self.soundAdj do
				if self.animations[self.soundAdj[i].animName] ~= nil and self.animations[self.soundAdj[i].animName].currentTime > 500 then
					self.sampleMotor.indoorVolumeFactor = math.max(self.soundAdj[i].volumeFactor, self.sampleMotor.indoorVolumeFactor);
					self.sampleMotor.indoorLowpassGain = math.max(self.soundAdj[i].lowpassGain, self.sampleMotor.indoorLowpassGain);
					self.sampleMotorStart.indoorVolumeFactor = math.max(self.soundAdj[i].volumeFactor, self.sampleMotorStart.indoorVolumeFactor);
					self.sampleMotorStart.indoorLowpassGain = math.max(self.soundAdj[i].lowpassGain, self.sampleMotorStart.indoorLowpassGain);
					self.sampleMotorStop.indoorVolumeFactor = math.max(self.soundAdj[i].volumeFactor, self.sampleMotorStop.indoorVolumeFactor);
					self.sampleMotorStop.indoorLowpassGain = math.max(self.soundAdj[i].lowpassGain, self.sampleMotorStop.indoorLowpassGain);
					
					self.sampleMotorRun.indoorVolumeFactor = math.max(self.soundAdj[i].volumeFactor, self.sampleMotorRun.indoorVolumeFactor);
					self.sampleMotorRun.indoorLowpassGain = math.max(self.soundAdj[i].lowpassGain, self.sampleMotorRun.indoorLowpassGain);
					self.sampleMotorLoad.indoorVolumeFactor = math.max(self.soundAdj[i].volumeFactor, self.sampleMotorLoad.indoorVolumeFactor);
					self.sampleMotorLoad.indoorLowpassGain = math.max(self.soundAdj[i].lowpassGain, self.sampleMotorLoad.indoorLowpassGain);
					sound=true;
				else
					if not sound then
						self.sampleMotor.indoorVolumeFactor = 0.55;
						self.sampleMotor.indoorLowpassGain = 0.2;
						self.sampleMotorStart.indoorVolumeFactor = 0.55;
						self.sampleMotorStart.indoorLowpassGain = 0.2;
						self.sampleMotorStop.indoorVolumeFactor = 0.55;
						self.sampleMotorStop.indoorLowpassGain = 0.2;
						
						self.sampleMotorRun.indoorVolumeFactor = 0.6;
						self.sampleMotorRun.indoorLowpassGain = 0.2;
						self.sampleMotorLoad.indoorVolumeFactor = 0.6;
						self.sampleMotorLoad.indoorLowpassGain = 0.2;
					end;
				end;
			end;
			SoundUtil.onCameraSwitched(self.activeCamera.isInside);
		end;
    end;
end;
function MBtrac:updateTick(dt)
end;
function MBtrac:draw()    
end;