--
-- ManualAttaching specialization register
-- author: Burner
-- date: 15.07.2015
--

SpecializationUtil.registerSpecialization("manualAttaching", "ManualAttaching", g_currentModDirectory.."ManualAttaching.lua")
g_isManualAttachingFunctionLoaded = false;
g_modDir = g_currentModDirectory;

ManualAttachingFunction = {};

function ManualAttachingFunction:loadMap(name)
	if not g_isManualAttachingFunctionLoaded then	
		for _, vehicleType in pairs(VehicleTypeUtil.vehicleTypes) do
			if vehicleType ~= nil then
				local loadManualAttachingSpecialization = false;
				for i = 1, table.maxn(vehicleType.specializations) do
					local specialization = vehicleType.specializations[i];
					if specialization ~= nil and (specialization == SpecializationUtil.getSpecialization("steerable") or specialization == SpecializationUtil.getSpecialization("attachable")) then
						loadManualAttachingSpecialization = true;				
					end;
				end;
			
				if loadManualAttachingSpecialization then
					table.insert(vehicleType.specializations, SpecializationUtil.getSpecialization("manualAttaching"));
				end;
				
			end;	
		end;

		g_i18n.globalI18N.texts['PTO_Attach'] = g_i18n:getText('PTO_Attach');
		g_i18n.globalI18N.texts['PTO_Detach'] = g_i18n:getText('PTO_Detach');
		g_i18n.globalI18N.texts['PTO_Attach_Warning'] = g_i18n:getText('PTO_Attach_Warning');

		ManualAttaching.modDir = g_modDir;
		g_isManualAttachingFunctionLoaded = true;
	end;
end;

function ManualAttachingFunction:deleteMap()
end;

function ManualAttachingFunction:keyEvent(unicode, sym, modifier, isDown)
end;

function ManualAttachingFunction:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ManualAttachingFunction:update(dt)
end;

function ManualAttachingFunction:draw()
end;

addModEventListener(ManualAttachingFunction);