--
-- keyboardSteerMogli
-- This is the specialization for keyboardSteerMogli
--

if mogliBase == nil or mogliBase.version == nil or mogliBase.version < 1.0 then
	source(Utils.getFilename("mogliBase.lua", g_currentModDirectory))
end
keyboardSteerMogli = mogliBase.newSubclass()

function keyboardSteerMogli.globalsReset( createIfMissing )
	KSMGlobals                   = {}
	KSMGlobals.cameraRotFactor     = 0
	KSMGlobals.cameraRotFactorRev  = 0
	KSMGlobals.cameraRotTime       = 0 --deprecated
	KSMGlobals.cameraRotTimeMax    = 0
	KSMGlobals.cameraRotTimeInc    = 0
	KSMGlobals.speedFxPoint1       = 0
	KSMGlobals.speedFxPoint2       = 0
	KSMGlobals.autoRotateBackFx0   = 0
	KSMGlobals.autoRotateBackFx1   = 0
	KSMGlobals.autoRotateBackFx2   = 0
	KSMGlobals.autoRotateBackFxMax = 0
	KSMGlobals.axisSideFx0         = 0
	KSMGlobals.axisSideFx1         = 0
	KSMGlobals.axisSideFx2         = 0
	KSMGlobals.axisSideFxMax       = 0
	KSMGlobals.maxRotTimeFx0       = 0
	KSMGlobals.maxRotTimeFx1       = 0
	KSMGlobals.maxRotTimeFx2       = 0
	KSMGlobals.maxRotTimeFxMax     = 0
  KSMGlobals.maxSpeed4Fx	       = 0
  KSMGlobals.timer4Reverse       = 0
  KSMGlobals.minSpeed4Fx	       = 0
  KSMGlobals.speedFxInc          = 0
	
-- defaults	
  KSMGlobals.ksmSteeringIsOn  = false
  KSMGlobals.ksmCameraIsOn    = false
  KSMGlobals.ksmDrawIsOn      = false
	
	local file
	file = keyboardSteerMogli.baseDirectory.."keyboardSteerMogliConfig.xml"
	if fileExists(file) then	
		keyboardSteerMogli.globalsLoad( file, "KSMGlobals", KSMGlobals )	
	else
		print("ERROR: NO GLOBALS IN "..file)
	end
	
	file = keyboardSteerMogli.modsDirectory.."keyboardSteerMogliConfig.xml"
	if fileExists(file) then	
		keyboardSteerMogli.globalsLoad( file, "KSMGlobals", KSMGlobals )	
	elseif createIfMissing then
		keyboardSteerMogli.globalsCreate()
	end
	
-- compatibility	
	if KSMGlobals.cameraRotTimeMax == 0 and KSMGlobals.cameraRotTime > 0 then
		KSMGlobals.cameraRotTimeMax = KSMGlobals.cameraRotTime * 33
	end
	
	KSMGlobals.autoRotateBackFx = AnimCurve:new(linearInterpolator1)
	KSMGlobals.axisSideFx       = AnimCurve:new(linearInterpolator1)
	KSMGlobals.maxRotTimeFx     = AnimCurve:new(linearInterpolator1)
	
	KSMGlobals.autoRotateBackFx:addKeyframe({v=KSMGlobals.autoRotateBackFx0, time = 0})
	KSMGlobals.autoRotateBackFx:addKeyframe({v=KSMGlobals.autoRotateBackFx1, time = KSMGlobals.speedFxPoint1/KSMGlobals.maxSpeed4Fx})
	KSMGlobals.autoRotateBackFx:addKeyframe({v=KSMGlobals.autoRotateBackFx2, time = KSMGlobals.speedFxPoint2/KSMGlobals.maxSpeed4Fx})
	KSMGlobals.autoRotateBackFx:addKeyframe({v=KSMGlobals.autoRotateBackFxMax, time = 1})
	
	KSMGlobals.axisSideFx:addKeyframe({v=KSMGlobals.axisSideFx0, time = 0})
	KSMGlobals.axisSideFx:addKeyframe({v=KSMGlobals.axisSideFx1, time = KSMGlobals.speedFxPoint1/KSMGlobals.maxSpeed4Fx})
	KSMGlobals.axisSideFx:addKeyframe({v=KSMGlobals.axisSideFx2, time = KSMGlobals.speedFxPoint2/KSMGlobals.maxSpeed4Fx})
	KSMGlobals.axisSideFx:addKeyframe({v=KSMGlobals.axisSideFxMax, time = 1})

	KSMGlobals.maxRotTimeFx:addKeyframe({v=KSMGlobals.maxRotTimeFx0, time = 0})
	KSMGlobals.maxRotTimeFx:addKeyframe({v=KSMGlobals.maxRotTimeFx1, time = KSMGlobals.speedFxPoint1/KSMGlobals.maxSpeed4Fx})
	KSMGlobals.maxRotTimeFx:addKeyframe({v=KSMGlobals.maxRotTimeFx2, time = KSMGlobals.speedFxPoint2/KSMGlobals.maxSpeed4Fx})
	KSMGlobals.maxRotTimeFx:addKeyframe({v=KSMGlobals.maxRotTimeFxMax, time = 1})
		
	print("keyboardSteerMogli initialized");
end

keyboardSteerMogli.globalsReset(false)

function keyboardSteerMogli:load(xmlFile)
	self.ksmScaleFx       = keyboardSteerMogli.scaleFx

	mogliBase.registerState( self, "ksmSteeringIsOn", false )
	mogliBase.registerState( self, "ksmCameraIsOn"  , false, keyboardSteerMogli.ksmOnSetCamera )
	mogliBase.registerState( self, "ksmCamFwd"      , true , keyboardSteerMogli.ksmOnSetCamFwd )
	mogliBase.registerState( self, "ksmExponent"    , 0    , keyboardSteerMogli.ksmOnSetFactor )
	mogliBase.registerState( self, "ksmWarningText" , ""   , keyboardSteerMogli.ksmOnSetWarningText )
	
	self.ksmSpeedFx       = 0
	self.ksmFactor        = 1
	self.ksmSpeedFxMin    = KSMGlobals.minSpeed4Fx / ( KSMGlobals.maxSpeed4Fx - KSMGlobals.minSpeed4Fx )
	self.ksmSpeedFxFactor = 3600 / ( KSMGlobals.maxSpeed4Fx - KSMGlobals.minSpeed4Fx )
	self.reverseTimer     = KSMGlobals.timer4Reverse
	self.ksmMovingDir     = 0
	self.ksmWarningTimer  = 0
	self.ksmLCtrlPressed  = false
	self.ksmLShiftPressed = false
	
--self:mbSetState( "ksmSteeringIsOn", KSMGlobals.ksmSteeringIsOn,true )
	if KSMGlobals.ksmSteeringIsOn then
		self:mbSetState( "ksmSteeringIsOn", "true",true )
	end
	if not SpecializationUtil.hasSpecialization(Combine, self.specializations) then
		self:mbSetState( "ksmCameraIsOn", KSMGlobals.ksmCameraIsOn,  true ) 
	end
end

function keyboardSteerMogli:update(dt)
	if self.isEntered and self.isClient and self:getIsActiveForInput(false) then
		if     InputBinding.hasEvent(InputBinding.ksmPLUS) then
			self:mbSetState( "ksmExponent", self.ksmExponent +1 )
			self:mbSetState( "ksmWarningText", string.format("Sensitivity %3.0f %%", 100 * self.ksmFactor, true ) )
		elseif InputBinding.hasEvent(InputBinding.ksmMINUS) then
			self:mbSetState( "ksmExponent", self.ksmExponent -1 )
			self:mbSetState( "ksmWarningText", string.format("Sensitivity %3.0f %%", 100 * self.ksmFactor, true ) )
		elseif InputBinding.hasEvent(InputBinding.ksmENABLE) then		
			self:mbSetState( "ksmSteeringIsOn", not self.ksmSteeringIsOn )
		elseif InputBinding.hasEvent(InputBinding.ksmCAMERA) then
			self:mbSetState( "ksmCameraIsOn", not self.ksmCameraIsOn )
		end
	end

	if self:getIsActive() and self.isServer then
		local deltaFx      = math.max( self.lastSpeed * self.ksmSpeedFxFactor - self.ksmSpeedFxMin, 0 )  - self.ksmSpeedFx
		self.ksmSpeedFx    = math.min( self.ksmSpeedFx + KSMGlobals.speedFxInc * deltaFx, 1 )

		if     ( self.movingDirection > 0.1 and self.ksmMovingDir > 0.1 ) 
				or ( self.movingDirection < 0.1 and self.ksmMovingDir < 0.1 ) then
			if self.reverseTimer > 0 then 
				self.reverseTimer = math.max( 0, self.reverseTimer - dt )
			end
		else
			self.reverseTimer = KSMGlobals.timer4Reverse
		end
			
		self.ksmMovingDir = self.movingDirection
			
		if self.reverseTimer <= 0 and math.abs( self.movingDirection ) >  0.1 then
			local newCamFwd = not ( self.movingDirection < -0.1 )
			if self.ksmCamFwd ~= newCamFwd then
				self:mbSetState( "ksmCamFwd", newCamFwd )
			end
		end
	end
		
	if self.ksmSteeringIsOn and not ( keyboardSteerMogli_prepended ) then
		keyboardSteerMogli_prepended = true
		Drivable.updateVehiclePhysics = Utils.overwrittenFunction( Drivable.updateVehiclePhysics, keyboardSteerMogli.newUpdateVehiclePhysics )
	--print( "Drivable.updateVehiclePhysics overwritten" )
	end
	
	if      self:getIsActive() 
			and self.ksmCameraIsOn 
			and self.cameras ~= nil 
			and self.camIndex ~= nil 
			and self.cameras[self.camIndex] ~= nil 
			and self.cameras[self.camIndex].isRotatable then
		
		local diff = self.cameras[self.camIndex].rotY - self.ksmRotY[self.camIndex].last
		self.ksmRotY[self.camIndex].zero   = self.ksmRotY[self.camIndex].zero   + diff
		self.ksmRotY[self.camIndex].smooth = self.ksmRotY[self.camIndex].smooth + diff
			
		local newRotY = self.ksmRotY[self.camIndex].zero
		if self.ksmCamFwd then
			newRotY = newRotY + self:ksmScaleFx( KSMGlobals.cameraRotFactor, 0.1, 3 ) * self.rotatedTime			
		else
			newRotY = newRotY - self:ksmScaleFx( KSMGlobals.cameraRotFactorRev, 0.1, 3 ) * self.rotatedTime
		end		

		diff = newRotY - self.ksmRotY[self.camIndex].smooth
	--diff = Utils.clamp( diff, -KSMGlobals.cameraRotTime*dt, KSMGlobals.cameraRotTime*dt )

		self.ksmRotY[self.camIndex].smooth = self.ksmRotY[self.camIndex].smooth + KSMGlobals.cameraRotTimeInc * diff
		
		diff = self.ksmRotY[self.camIndex].smooth - self.cameras[self.camIndex].rotY
		diff = Utils.clamp( diff, -KSMGlobals.cameraRotTimeMax*dt, KSMGlobals.cameraRotTimeMax*dt )
		
		self.cameras[self.camIndex].rotY = self.cameras[self.camIndex].rotY + diff
		self.ksmRotY[self.camIndex].last = self.cameras[self.camIndex].rotY
	end	

	if      self:getIsActive()
			and self.ksmWarningText ~= nil
			and self.ksmWarningText ~= "" then
		if self.time < self.ksmWarningTimer then
			g_currentMission:addWarning(self.ksmWarningText, 0.018, 0.033)
		else
			self.ksmWarningText = ""
		end
	end
end

function keyboardSteerMogli:readStream(streamId, connection)

  self.ksmSteeringIsOn = streamReadBool(streamId) 
  self.ksmCameraIsOn   = streamReadBool(streamId) 
  self.ksmCamFwd       = streamReadBool(streamId) 
	self.ksmExponent     = streamReadInt16(streamId)     
	
end

function keyboardSteerMogli:writeStream(streamId, connection)

	streamWriteBool(streamId, self.ksmSteeringIsOn )
	streamWriteBool(streamId, self.ksmCameraIsOn )
	streamWriteBool(streamId, self.ksmCamFwd )     
	streamWriteInt16(streamId,self.ksmExponent )     

end

function keyboardSteerMogli:keyEvent(unicode, sym, modifier, isDown)
	if isDown and sym == Input.KEY_lctrl then
		self.ksmLCtrlPressed = true
	else
		self.ksmLCtrlPressed = false
	end
	if isDown and sym == Input.KEY_lshift then
		self.ksmLShiftPressed = true
	else
		self.ksmLShiftPressed = false
	end
end


function keyboardSteerMogli:draw()	
	if KSMGlobals.ksmDrawIsOn or self.ksmLShiftPressed then
		if self.ksmSteeringIsOn then
			g_currentMission:addHelpButtonText(keyboardSteerMogli.getText("ksmENABLE_ON"),  InputBinding.ksmENABLE)
		else
			g_currentMission:addHelpButtonText(keyboardSteerMogli.getText("ksmENABLE_OFF"), InputBinding.ksmENABLE)
		end
		if self.ksmCameraIsOn then
			g_currentMission:addHelpButtonText(keyboardSteerMogli.getText("ksmCAMERA_ON"),  InputBinding.ksmCAMERA)
		else
			g_currentMission:addHelpButtonText(keyboardSteerMogli.getText("ksmCAMERA_OFF"), InputBinding.ksmCAMERA)
		end
	end
	if KSMGlobals.ksmDrawIsOn or self.ksmLCtrlPressed then
		g_currentMission:addHelpButtonText(keyboardSteerMogli.getText("ksmPLUS"),  InputBinding.ksmPLUS)
		g_currentMission:addHelpButtonText(keyboardSteerMogli.getText("ksmMINUS"), InputBinding.ksmMINUS)
	end  
end  
       
function keyboardSteerMogli:getSaveAttributesAndNodes(nodeIdent)
	local attributes = ""
	if self.ksmSteeringIsOn ~= nil and self.ksmSteeringIsOn ~= KSMGlobals.ksmSteeringIsOn then
		attributes = attributes.." ksmSteeringIsOn=\""  .. tostring(self.ksmSteeringIsOn) .. "\""
	end
	if self.ksmCameraIsOn ~= nil and self.ksmCameraIsOn ~= KSMGlobals.ksmCameraIsOn then
		attributes = attributes.." ksmCameraIsOn=\""  .. tostring(self.ksmCameraIsOn) .. "\""
	end
	if self.ksmExponent ~= nil and math.abs( self.ksmExponent - 1 ) > 1E-3 then
		attributes = attributes.." ksmExponent=\""  .. tostring(self.ksmExponent) .. "\""
	end

	return attributes
end;

function keyboardSteerMogli:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local b = getXMLBool(xmlFile, key .. "#ksmSteeringIsOn" )
	if b ~= nil then
		self:mbSetState( "ksmSteeringIsOn", b,  true ) 
	end
	b = getXMLBool(xmlFile, key .. "#ksmCameraIsOn" )
	if b ~= nil then
		self:mbSetState( "ksmCameraIsOn", b,  true ) 
	end
	local i = getXMLInt(xmlFile, key .. "#ksmExponent" )
	if i ~= nil then
		self:mbSetState( "ksmExponent", i,  true ) 
	end
	return BaseMission.VEHICLE_LOAD_OK;
end

function keyboardSteerMogli:scaleFx( fx, mi, ma )
	return Utils.clamp( 1 + self.ksmFactor * ( fx - 1 ), mi, ma )
end

function keyboardSteerMogli:newUpdateVehiclePhysics( superFunc, axisForward, axisForwardIsAnalog, axisSide, axisSideIsAnalog, dt)
	local backup1 = self.autoRotateBackSpeed
	local backup2 = self.minRotTime
	local backup3 = self.maxRotTime
	if self.ksmSteeringIsOn and not ( axisSideIsAnalog ) then
		local arbs = backup1 / 2
		
		if self.lastSpeed < 0.000278 then
			self.autoRotateBackSpeed = 0
		else
			self.autoRotateBackSpeed = self:ksmScaleFx( KSMGlobals.autoRotateBackFx:get( self.ksmSpeedFx ), 0.1, 3 ) * arbs
		end
		
		local f = self:ksmScaleFx( KSMGlobals.maxRotTimeFx:get( self.ksmSpeedFx ), 0, 1 )
		
		self.minRotTime = f * backup2
		self.maxRotTime = f * backup3
		
		axisSide = self:ksmScaleFx( KSMGlobals.axisSideFx:get( self.ksmSpeedFx ), 0.1, 3 ) * axisSide
		if axisSide > 0 and self.rotatedTime > 0 then
			axisSide = math.max( axisSide, self.autoRotateBackSpeed )
		end
		if axisSide < 0 and self.rotatedTime < 0 then
			axisSide = math.min( axisSide, -self.autoRotateBackSpeed )
		end
	end
	
	local state, result = pcall( superFunc, self, axisForward, axisForwardIsAnalog, axisSide, axisSideIsAnalog, dt )
	if not ( state ) then
		print("Error in updateVehiclePhysics :"..tostring(result))
	end

	self.autoRotateBackSpeed = backup1
	self.minRotTime          = backup2
	self.maxRotTime          = backup3
end

function keyboardSteerMogli:ksmOnSetCamera( old, new, noEventSend ) 
	self.ksmCameraIsOn = new
	if self.ksmCameraIsOn then
		self.ksmRotY = {}
		for i,c in pairs(self.cameras) do
			self.ksmRotY[i] = { zero = c.rotY, last = c.rotY, smooth = c.rotY }
		end
	end
end

function keyboardSteerMogli:ksmOnSetCamFwd( old, new, noEventSend ) 
	self.ksmCamFwd = new
	if self.ksmCameraIsOn and new ~= old then
		local pi2 = math.pi / 2
		for i,c in pairs(self.cameras) do
			if c.isRotatable then
				local diff = math.abs( keyboardSteerMogli.normalizeAngle( c.rotY - c.origRotY ) )
				if self.ksmCamFwd then
					if diff > pi2 then
						c.rotY = keyboardSteerMogli.normalizeAngle( c.rotY + math.pi )
					end
				else
					if diff < pi2 then
						c.rotY = keyboardSteerMogli.normalizeAngle( c.rotY + math.pi )
					end
				end
			end
		end
	end
end

function keyboardSteerMogli:ksmOnSetFactor( old, new, noEventSend )
	self.ksmExponent = new
	self.ksmFactor   = 1.1 ^ new
end

function keyboardSteerMogli:ksmOnSetWarningText( old, new, noEventSend )
	self.ksmWarningText  = new
  self.ksmWarningTimer = self.time + 2000
end