--@Author: Alex2009, Sven777b
--@Web: www.ls-landtechnik.de, www.alex2009.de

-- Umbau fr "PlaceableRepairTrigger" by rafftnix @date: 20.02.2013. Erlaubnis von Sven777b liegt vor.

PlaceableRepairTrigger = {};
PlaceableRepairTrigger_mt = Class(PlaceableRepairTrigger, Placeable);
InitObjectClass(PlaceableRepairTrigger, "PlaceableRepairTrigger");

function PlaceableRepairTrigger:new(isServer, isClient, customMt)
    local self = Placeable:new(isServer, isClient, PlaceableRepairTrigger_mt);
    registerObjectClassName(self, "PlaceableRepairTrigger");
    return self;
end;

function PlaceableRepairTrigger:delete()
    removeTrigger(self.triggerId);
    unregisterObjectClassName(self);
    PlaceableRepairTrigger:superClass().delete(self);
end;

function PlaceableRepairTrigger:deleteFinal()
    PlaceableRepairTrigger:superClass().deleteFinal(self);
end;

function PlaceableRepairTrigger:load(xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom)
    if not PlaceableRepairTrigger:superClass().load(self, xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom) then
        return false;
    end;
	if not moveMode then
		local xmlFile = loadXMLFile("TempXML", xmlFilename);
		self.triggerId = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, "placeable.repairTrigger#index"));
		addTrigger(self.triggerId, "repairTriggerCallback", self);
		delete(xmlFile);
	end;
    return true;
end;

function PlaceableRepairTrigger:update(dt)

end;

function PlaceableRepairTrigger:repairTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	local vehicle = g_currentMission.nodeToVehicle[otherId];
	if vehicle ~= nil then
		if onEnter then
			vehicle.isInRepairTrigger = true;
		end;
		if onLeave then
			vehicle.isInRepairTrigger = false;
		end;
	end;
end;

registerPlaceableType("PlaceableRepairTrigger", PlaceableRepairTrigger);