-- Manager.lua for damage mod managerment
-- @author: rafftnix
-- @date: August and September 2012
-- v1.0: initial Version (September 2012)
-- nderungen am Skript nur mit meiner Zustimmung!
-- Modification only with my permission!

SpecializationUtil.registerSpecialization("Damage", "Damage", g_currentModDirectory.."Damage.lua");

Manager = {};

function Manager:loadMap(name)
	if self.firstRun == nil then
		self.damageIgnoreList = {}

		self.texts = {}
		self.texts.could_not_attach_vehicle_because_of_damage = g_i18n:getText("could_not_attach_vehicle_because_of_damage");
		self.texts.damage = g_i18n:getText("damage");
		self.texts.deactivateDisplay = g_i18n:getText("deactivateDisplay");
		self.texts.activateRendering = g_i18n:getText("activateRendering");
		self.texts.cant_read_name = g_i18n:getText("cant_read_name");
	
		self.damageEvent = DamageEvent;
		
		self.firstRun = false;	
		self.renderDamageLevel = false;
		self.displayDamageLevel = true;
		self.kickOutWarning = 0;
		self.kickOutWarningTime = 4000;
		for k, v in pairs(VehicleTypeUtil.vehicleTypes) do
			if not SpecializationUtil.hasSpecialization(PathVehicle, v.specializations) then
				table.insert(v.specializations, SpecializationUtil.getSpecialization("Damage"));
			end;
		end;
		
		-- manure heap of animal husbandry
		for k, v in pairs(g_currentMission.onCreateLoadedObjectsToSave) do
			if v.manureHeap ~= nil then
				local movingId = v.manureHeap.movingId;
				if movingId ~= nil then
					for a=1, getNumOfChildren(movingId) do
						g_currentMission.damageIgnoreList[getChildAt(movingId, a-1)] = true;
					end;
				end;
			end;
		end;
	end;
	g_currentMission.damageMod = self;
end;

-- fix zweiter Klasse, aber besser als nichts
local oldBunkerSiloLoad = BunkerSilo.load;
BunkerSilo.load = function(self, nodeId)
	local result = oldBunkerSiloLoad(self, nodeId);
	
	if g_currentMission.damageIgnoreList == nil then
		g_currentMission.damageIgnoreList = {}
	end;
	
	local ignoreList = g_currentMission.damageIgnoreList;
	for a=1, table.getn(self.movingPlanes) do
		for i=1, getNumOfChildren(self.movingPlanes[a].nodeId) do
			ignoreList[getChildAt(self.movingPlanes[a].nodeId, i-1)] = true;
		end;
	end;
	
	return result;
end;

local oldSiloAmountMoverOnCreate = SiloAmountMover.onCreate;
SiloAmountMover.onCreate = function(self, id)
	oldSiloAmountMoverOnCreate(self, id);
	
	if g_currentMission.damageIgnoreList == nil then
		g_currentMission.damageIgnoreList = {}
	end;
	g_currentMission.damageIgnoreList[id] = true;
end;

function Manager:deleteMap()
	
end;

function Manager:keyEvent(unicode, sym, modifier, isDown)

end;

function Manager:mouseEvent(posX, posY, isDown, isUp, button)

end;

function Manager:update(dt)
	if InputBinding.isPressed(InputBinding.DAMAGEMODKEY) then
		if InputBinding.hasEvent(InputBinding.DAMAGEMOD_Render) then
			self.renderDamageLevel = not self.renderDamageLevel;
		end;
		if InputBinding.hasEvent(InputBinding.DAMAGEMOD_DISPLAY) then
			self.displayDamageLevel = not self.displayDamageLevel;
		end;
	end;
	if self.kickOutWarning > 0 then
		self.kickOutWarning = math.max(0, self.kickOutWarning - dt);
	end;
end;

function Manager:draw()
	if self.kickOutWarning > 0 then
		g_currentMission:addWarning(g_i18n:getText("kicked_out_of_vehicle"), 0.07+0.022, 0.019+0.029); 
	end;
end;

addModEventListener(Manager);