DamageEvent = {};
DamageEvent_mt = Class(DamageEvent, Event);
InitEventClass(DamageEvent, "DamageEvent");
function DamageEvent:emptyNew()
    local self = Event:new(DamageEvent_mt);
    self.className="DamageEvent";
    return self;
end;

function DamageEvent:new(object, damage)
    local self = DamageEvent:emptyNew(); 
    self.object = object; 
	self.damage = damage;
    return self;
end;

function DamageEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
    streamWriteInt8(streamId, self.damage);
end;

function DamageEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
    self.damage = streamReadInt8(streamId);
    self:run(connection);
end;

function DamageEvent:run(connection)
	self.object:setDamageLevel(self.damage);
end;

function DamageEvent.sendEvent(object, damage, noEventSend)
	g_server:broadcastEvent(DamageEvent:new(object, damage), nil, nil, object); 
end;