-- Damage specialization by rafftnix
-- @author: rafftnix
-- @date: 04.08.2012 
-- History FS 11: 
--          v1.0: initial Version (September 2012) 
--
-- History FS 13:
--			v1.0: convert to FS 13 and some fixes (November 2012)
--
-- nderungen am Skript nur mit meiner Zustimmung!
-- Modification only with my permission!

print("Damage mod by rafftnix loaded");

Damage = {};

function Damage.prerequisitesPresent(specializations)
    return true;
end;

function Damage:load(xmlFile)
	self.setDamageLevel = SpecializationUtil.callSpecializationsFunction("setDamageLevel");
	self.getSaveAttributesAndNodes = Utils.overwrittenFunction(self.getSaveAttributesAndNodes, Damage.getSaveAttributesAndNodes2);	
	self.playAttachSound = Utils.overwrittenFunction(self.playAttachSound, Damage.playAttachSound);		
	self.damageCallback = Damage.damageCallback;
	self.showAttachedVehiclesDamage = Damage.showAttachedVehiclesDamage;
	self.damageDeferralCallback = Damage.damageDeferralCallback;
	
	self.damageLevel = 0;
	self.lastUpdatedDamageLevel = 0;
	self.priceAtShop = 0;
	self.cantAttachWarning = 0;
	self.cantAttachWarningTime = 4000;
	self.repairTriggerTimer = 0;
	self.repairTriggerTimerTime = 2600;
	self.fuelUsageBackup = self.fuelUsage;
	self.damageDeferralGone = false;
	
	-- if you do not want this vehicle to get damage at all
	self.dontAllowDamage = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.dontAllowDamage"), false); 
	
	if not self.dontAllowDamage then
		for a=1, table.getn(self.components) do
			if not (self.contactReportNodes ~= nil and self.contactReportNodes[self.components[a].node] ~= nil) and not (self.contactReportNode ~= nil and self.components[a].node == self.contactReportNode) then 
				addContactReport(self.components[a].node, 0.0001, "damageCallback", self);
			end;
		end;
	end;
	
	for a=1, table.getn(StoreItemsUtil.storeItems) do
		if StoreItemsUtil.storeItems[a].xmlFilename == self.configFileName then
			self.priceAtShop = StoreItemsUtil.storeItems[a].price;
			break;
		end;
	end;

	local name = getXMLString(xmlFile, "vehicle.name.de");
	name = Utils.getNoNil(name, getXMLString(xmlFile, "vehicle.name.en"));
	name = Utils.getNoNil(getXMLString(xmlFile, "vehicle.name"), name);
	name = Utils.getNoNil(name, "can not read name");
	self.modName = name;
	
	local mass = 0;
	for a=1, table.getn(self.components) do
		local compMass = getMass(self.components[a].node);
		if compMass ~= nil and compMass > 0.001 then
			mass = mass + compMass;
		end;
	end;
	if mass < 0.001 then
		mass = 0.1;
	end;
	self.completeMass = mass;
	
	-- damage deferral to make sure the vehicle gets no damage while it is spawned 
	addTimer(2000, "damageDeferralCallback", self);
end;


function Damage:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local damageLevel = getXMLFloat(xmlFile, key.."#damageLevel");
	if damageLevel ~= nil then
		self:setDamageLevel(damageLevel);
	end;
	return BaseMission.VEHICLE_LOAD_OK;
end;

function Damage:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'damageLevel="'..tostring(math.floor(self.damageLevel))..'"';
	return attributes, nil;
end;

function Damage:getSaveAttributesAndNodes2(oldFunc, nodeIdent)
	if self.isBroken and self.damageLevel >= 100 then
		self.isBroken = false;
	end;
	
	local attributes, nodes = oldFunc(self, nodeIdent);
	
	if self.isBroken and self.damageLevel >= 100 then
		self.isBroken = true;
	end;
	
	return attributes, nodes;
end;

function Damage:readStream(streamId, connection)
	local damageLevel = streamReadInt8(streamId);
	self:setDamageLevel(damageLevel);
end;
  
function Damage:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.damageLevel);
end;

function Damage:delete()
end;

function Damage:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Damage:keyEvent(unicode, sym, modifier, isDown)
end;

function Damage:update(dt) 
	if not self:getIsActiveForInput(false) and g_currentMission.damageMod.renderDamageLevel and g_gui.currentGui == nil then
		local x, y, z = getWorldTranslation(self.components[1].node);
		local x1, y1, z1 = 0, 0, 0;
		if g_currentMission.player ~= nil then
			if g_currentMission.controlledVehicle ~= nil then
				x1, y1, z1 = getWorldTranslation(g_currentMission.controlledVehicle.cameras[g_currentMission.controlledVehicle.camIndex].cameraNode);
			else
				x1, y1, z1 = getWorldTranslation(g_currentMission.player.rootNode);
			end;
			if Utils.vector3Length(x-x1, y-y1, z-z1) < 50 then
				if self.nicknameRenderNodeOffset ~= nil and self.nicknameRenderNodeOffset[1] ~= nil then
					local xn, yn, zn = getWorldTranslation(self.nicknameRenderNode);
					x = xn + self.nicknameRenderNodeOffset[1];
					y = yn + self.nicknameRenderNodeOffset[2];
					z = zn + self.nicknameRenderNodeOffset[3];
				else
					y = y + 3;
				end;
				local sx,sy,sz = project(x,y,z);
				if sz <= 1 then
					setTextAlignment(RenderText.ALIGN_CENTER);
					setTextBold(false);
					setTextColor(0.0, 0.0, 0.0, 0.75);
					renderText(sx, sy + 0.05, 0.02, g_currentMission.damageMod.texts.damage..": "..tostring(math.floor(self.damageLevel)).."%");
					setTextColor(0.5, 1.0, 0.5, 1.0);
					renderText(sx, sy + 0.05, 0.02, g_currentMission.damageMod.texts.damage..": "..tostring(math.floor(self.damageLevel)).."%");
					setTextAlignment(RenderText.ALIGN_LEFT);
				end;
			end;
		end;
	end;
end;

function Damage:updateTick(dt)
	if self.damageLevel >= 100 and self.attacherVehicle ~= nil then
		self.attacherVehicle.cantAttachWarning = self.attacherVehicle.cantAttachWarningTime;
		if self.isServer then
			self.attacherVehicle:detachImplementByObject(self);
		end;
		if self.doJointSearch ~= nil then
			self.doJointSearch = nil;
		end;
	end;
	
	if self.cantAttachWarning > 0 then
		self.cantAttachWarning = math.max(0, self.cantAttachWarning - dt);
	end;
	
	if self.damageLevel >= 100 then
		if self.isEntered then
            g_currentMission:onLeaveVehicle();
			g_currentMission.damageMod.kickOutWarning = g_currentMission.damageMod.kickOutWarningTime;
		end;
	end;
	
	local xt, yt, zt = getTranslation(self.components[1].node);
    local deltaWater = yt - g_currentMission.waterY + 2.5;
	
	if deltaWater < 2 and not self.isBroken then
		self:setDamageLevel(self.damageLevel + (0.003 * dt));
	end;
	
	if self.isServer then
		if self.isInRepairTrigger and self.damageLevel > 0 then
			self.repairTriggerTimer = self.repairTriggerTimer - dt;
			if self.repairTriggerTimer <= 0 then
				self.repairTriggerTimer = self.repairTriggerTimerTime;
				self:setDamageLevel(math.max(self.damageLevel - 1, 0));
				g_currentMission:addSharedMoney(-self.priceAtShop * 0.0006 * g_currentMission.missionStats.difficulty);
			end;
		end;
	end;
end;

function Damage:draw()
	setTextBold(false);
	if self == g_currentMission.controlledVehicle and g_currentMission.damageMod.displayDamageLevel then
		if self.cantAttachWarning > 0 then
			g_currentMission:addWarning(g_currentMission.damageMod.texts.could_not_attach_vehicle_because_of_damage, 0.07+0.022, 0.019+0.029); 
		end;
		
		self.addedVehicles = 0;
		
		renderText(0.725, 0.83, 0.015, g_currentMission.damageMod.texts.damage.." "..self.modName..": "..tostring(math.floor(self.damageLevel)).."%"); 
		self.addedVehicles = self.addedVehicles + 1;
		
		self:showAttachedVehiclesDamage(self);
		
		renderText(0.725, 0.83 - (self.addedVehicles) * 0.0175, 0.015, g_currentMission.damageMod.texts.deactivateDisplay.." "..InputBinding.getKeyNamesOfDigitalAction(InputBinding.DAMAGEMODKEY).." + "..InputBinding.getKeyNamesOfDigitalAction(InputBinding.DAMAGEMOD_DISPLAY));
		renderText(0.725, 0.83 - (self.addedVehicles+1) * 0.0175, 0.015, g_currentMission.damageMod.texts.activateRendering.." "..InputBinding.getKeyNamesOfDigitalAction(InputBinding.DAMAGEMODKEY).." + "..InputBinding.getKeyNamesOfDigitalAction(InputBinding.DAMAGEMOD_Render));
	end;
end;

function Damage:showAttachedVehiclesDamage(vehicle)
	for a=1, table.getn(vehicle.attachedImplements) do
		local attachedVehicle = vehicle.attachedImplements[a].object;
		if not attachedVehicle.dontAllowDamage and attachedVehicle.damageLevel ~= nil then
			renderText(0.725, 0.83 - (self.addedVehicles * 0.0175), 0.015, g_currentMission.damageMod.texts.damage.." "..attachedVehicle.modName..": "..tostring(math.floor(attachedVehicle.damageLevel)).."%");
			self.addedVehicles = self.addedVehicles + 1;
		end;
		self:showAttachedVehiclesDamage(attachedVehicle);
	end;
end;

function Damage:playAttachSound(oldFunc)
	if g_currentMission.attachableInMountRange.damageLevel == nil or g_currentMission.attachableInMountRange.damageLevel <100 then
		oldFunc(self);
	end;
end;

function Damage:setDamageLevel(level)
	if self.dontAllowDamage then
		return;
	end;
	level = math.min(level, 100);
	level = math.max(level, 0);
	self.damageLevel = level;
	self.isBroken = self.damageLevel >= 100;
	if self.isServer then 
		if math.floor(level) ~= self.lastUpdatedDamageLevel then
			g_currentMission.damageMod.damageEvent.sendEvent(self, math.floor(level));
			self.lastUpdatedDamageLevel = math.floor(level);
			if self.fuelUsage ~= nil then
				self.fuelUsage = self.fuelUsageBackup + (self.fuelUsageBackup * (level * 0.015));
			end;
		end;
	end;
end;

function Damage:groundContactReport(objectId, otherObjectId, isStart, normalForce, tangentialForce)
	self:damageCallback(objectId, otherObjectId, isStart, normalForce, tangentialForce);
end;

function Damage:damageCallback(objectId, otherObjectId, isStart, normalForce, tangentialForce)
	if self.isServer and isStart and normalForce > 0 then
		local setDamage = self.damageDeferralGone;
		local vehicle = g_currentMission.nodeToVehicle[otherObjectId];
		
		-- interface, if you have a mod which triggers damage but it should not
		if self.stopDamageCalculation ~= nil and self.damageDeferralGone then
			setDamage = self:stopDamageCalculation(objectId, otherObjectId, isStart, normalForce, tangentialForce, vehicle);
		end;
		
		if vehicle ~= nil then
			if self.attacherVehicle ~= nil and self.attacherVehicle == vehicle then
				setDamage = false;
			end;
			if self.attachedImplements ~= nil then
				for k, v in pairs(self.attachedImplements) do
					if v ~= nil and v.object ~= nil and v.object == vehicle then
						setDamage = false;
					end;
				end;
			end;	
			if vehicle == self then
				setDamage = false;
			end;
		end;
		
		if otherObjectId == g_currentMission.terrainRootNode then
			setDamage = false;
		end;
		
		local object = g_currentMission:getNodeObject(otherObjectId);
		if object ~= nil then
			if object:isa(Bale) then
				setDamage = false;
			end;
		end;
		
		if g_currentMission.damageIgnoreList[otherObjectId] ~= nil then
			setDamage = false;
		end;
		
		if setDamage then
			local normalDamage = normalForce / 175;
			local tangentialDamage = math.min(tangentialForce * 125000, 9);
			local damage = math.min(normalDamage + tangentialDamage, 20);
			if vehicle ~= nil and vehicle.completeMass ~= nil then
				damage = 2.5 * damage + (damage * (self.completeMass/vehicle.completeMass) * 0.4);
			else
				damage = damage * 3;
			end;
			damage = math.min(damage, 15);
			damage = (damage + (damage * g_currentMission.missionStats.difficulty * 0.25)) * 0.5;

			
			self:setDamageLevel(self.damageLevel + damage);
		end;
	end;
end;

function Damage:damageDeferralCallback()
	self.damageDeferralGone = true;
	return false;
end;

local old_vehicle_attachImplement = Vehicle.attachImplement;
Vehicle.attachImplement = function(self, object, jointIndex, noEventSend, index)
	if object.damageLevel ~= nil and object.damageLevel >= 100 then
		self.cantAttachWarning = self.cantAttachWarningTime;
	else
		old_vehicle_attachImplement(self, object, jointIndex, noEventSend, index);
	end;
end;