-- Lulu88520
-- Script pour la tonne à eau Agram
-- Ls-Modteam-France
-- @date  21/03/2014
-- http://www.ls-modteam-france.com

agram = {};

function agram.prerequisitesPresent(specializations)
	  return SpecializationUtil.hasSpecialization(Trailer, specializations) and SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function agram:load(xmlFile)
	self.toggleSupport = SpecializationUtil.callSpecializationsFunction("toggleSupport");  
    self.manualSupportAnimation = getXMLString(xmlFile, "vehicle.manualSupport#animationName");
    self.supportRangeIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.manualSupport#rangeIndex"));
    self.isInRangeSupport = false;
    self.isSupportDown = true; 	
	
	self.playerinrangeCouvercle = false;
	self.couvercleNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.couvercleNode#index"));
end;

function agram:delete()
end;

function agram:readStream(streamId, connection)
   local isSupportDown = streamReadBool(streamId);
	self:toggleSupport(isSupportDown, true); 	
end;

function agram:writeStream(streamId, connection)
streamWriteBool(streamId, self.isSupportDown);
end;

function agram:mouseEvent(posX, posY, isDown, isUp, button)
end;

function agram:keyEvent(unicode, sym, modifier, isDown)
end;

function agram:update(dt)		

         if self:getIsActive() then		
		if self.isClient and self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() then
			-- Show warning about the support being down
			if self.isSupportDown then
				g_currentMission:addWarning(string.format(g_i18n:getText("BJR_SUPPORT_WARNING")), 0.018, 0.033);
			end;
		end;
	end;
         if self.supportRangeIndex then
		-- Manage key events for inrange support --
		if self.isInRangeSupport then
			if InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT) then
				if self.isSupportDown then
					self:toggleSupport(false);
				else
					self:toggleSupport(true);
				end;
			end;
			-- Display key when in range --
			if self.isSupportDown then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("BJR_RAISE_SUPPORT")), InputBinding.LOWER_IMPLEMENT);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("BJR_LOWER_SUPPORT")), InputBinding.LOWER_IMPLEMENT);
			end;
		end;
	end;	
	
	if (self.fillLevel > 0 and self.playerinrangeCouvercle) then	
		g_currentMission:addExtraPrintText(g_i18n:getText("REMPLISSAGE_ACTUELLE").." "..math.floor(self.fillLevel).." ("..math.floor(100*self.fillLevel/self.capacity).."%)");
	end;                  
end;

function agram:updateTick(dt)

 if self.supportRangeIndex then
		if g_currentMission.player ~= nil then
			-- Getting the distance between the player and the support
			local nearestDistance = 1.5; --max distance allowed
			local px, py, pz = getWorldTranslation(self.supportRangeIndex);
			local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
			local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
			if distance < nearestDistance then
				self.isInRangeSupport = true;
			else
				self.isInRangeSupport = false;
			end;
		end;
	else
		self.isInRangeSupport = false;
	end; 
	
	
	if g_currentMission.player ~= nil then
		local nearestDistance = 3.5;
		local px, py, pz = getWorldTranslation(self.couvercleNode);
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
		if distance < nearestDistance then
			self.playerinrangeCouvercle = true;
		else
			self.playerinrangeCouvercle = false;
		end;
	end;
end;

function agram:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local isSupportDown = Utils.getNoNil(getXMLBool(xmlFile, key .. "#isSupportDown"), false);
	self:toggleSupport(isSupportDown);	
	
    return BaseMission.VEHICLE_LOAD_OK;
end;

function agram:getSaveAttributesAndNodes(nodeIdent)
    local attributes = 'isSupportDown="' .. tostring(self.isSupportDown) .. '"';
    return attributes, nil;
end;
  
function agram:onDetach()
end;

function agram:draw() 
end;

function agram:toggleSupport(isSupportDown, noEventSend)
	ToggleSupportEvent.sendEvent(self, isSupportDown, noEventSend);	
	
	if not isSupportDown then
		if self.manualSupportAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.manualSupportAnimation, -1, nil, true);
		end;
	else
		if self.manualSupportAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.manualSupportAnimation, 1, nil, true);
		end;
	end;
	
	self.isSupportDown = isSupportDown;
end;
if g_currentModName ~= "tonne_eau_agram" then
	while g_currentModName ~= "tonne_eau_agram" do
	print("Error: The mod must not be renamed. It must be called tonne_eau_agram.zip");
		end;
end;
-- Support event

ToggleSupportEvent = {};
ToggleSupportEvent_mt = Class(ToggleSupportEvent, Event);

InitEventClass(ToggleSupportEvent, "ToggleSupportEvent");

function ToggleSupportEvent:emptyNew()
    local self = Event:new(ToggleSupportEvent_mt);
    return self;
end;

function ToggleSupportEvent:new(vehicle, isSupportDown)
    local self = ToggleSupportEvent:emptyNew()
    self.vehicle = vehicle;
	self.isSupportDown = isSupportDown;
    return self;
end;

function ToggleSupportEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.vehicle = networkGetObject(id);
	self.isSupportDown = streamReadBool(streamId);
    self:run(connection);
end;

function ToggleSupportEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteBool(streamId, self.isSupportDown);
end;

function ToggleSupportEvent:run(connection)
	self.vehicle:toggleSupport(self.isSupportDown, true);
end;

function ToggleSupportEvent.sendEvent(vehicle, isSupportDown, noEventSend)
	
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(ToggleSupportEvent:new(vehicle, isSupportDown), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(ToggleSupportEvent:new(vehicle, isSupportDown));
		end;
	end;
end;