--author: igor29381 Edit: werik

AutomaticHatches = {};

function AutomaticHatches.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function AutomaticHatches:load(xmlFile)
local rotationPartNoderightdoor = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rightdoor#index"));
    if rotationPartNoderightdoor ~= nil then
        self.rotationPartrightdoor = {};
        self.rotationPartrightdoor.node = rotationPartNoderightdoor;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rightdoor#minRot"));
        self.rotationPartrightdoor.minRot = {};
        self.rotationPartrightdoor.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartrightdoor.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartrightdoor.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rightdoor#maxRot"));
        self.rotationPartrightdoor.maxRot = {};
        self.rotationPartrightdoor.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartrightdoor.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartrightdoor.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartrightdoor.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rightdoor#rotTime"), 2)*1000;
        self.rotationPartrightdoor.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rightdoor#touchRotLimit"), 10));
    end;
local rotationPartNodeleftdoor = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.leftdoor#index"));
    if rotationPartNodeleftdoor ~= nil then
        self.rotationPartleftdoor = {};
        self.rotationPartleftdoor.node = rotationPartNodeleftdoor;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.leftdoor#minRot"));
        self.rotationPartleftdoor.minRot = {};
        self.rotationPartleftdoor.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartleftdoor.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartleftdoor.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.leftdoor#maxRot"));
        self.rotationPartleftdoor.maxRot = {};
        self.rotationPartleftdoor.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartleftdoor.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartleftdoor.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartleftdoor.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.leftdoor#rotTime"), 2)*1000;
        self.rotationPartleftdoor.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.leftdoor#touchRotLimit"), 10));
    end;
end;

function AutomaticHatches:delete()
end;

function AutomaticHatches:readStream(streamId, connection)
end;

function AutomaticHatches:writeStream(streamId, connection)
end;

function AutomaticHatches:mouseEvent(posX, posY, isDown, isUp, button)
end;

function AutomaticHatches:keyEvent(unicode, sym, modifier, isDown)
	if isDown and sym == Input.KEY_KP_multiply then
		if self.isServer then
		              self.helpPanel = not self.helpPanel;
			self.rotationMaxleftdoor = not self.rotationMaxleftdoor;
			self.rotationMaxrightdoor = not self.rotationMaxrightdoor;
			self:raiseDirtyFlags(self.movingFlag);
		else
			g_client:getServerConnection():sendEvent(AutomaticHatchesEvent:new(4, self));
		end;
    end;
end;

function AutomaticHatches:readUpdateStream(streamId, timestamp, connection)
	if connection:getIsServer() then
		self.rotationMaxrightdoor = streamReadBool(streamId);
		self.rotationMaxleftdoor = streamReadBool(streamId);
	end;
end;

function AutomaticHatches:writeUpdateStream(streamId, connection, dirtyMask)
	if not connection:getIsServer() then
		streamWriteBool(streamId, self.rotationMaxrightdoor);
		streamWriteBool(streamId, self.rotationMaxleftdoor);
	end;
end;

function AutomaticHatches:update(dt)
        if self.rotationPartrightdoor ~= nil then
		   local x, y, z = getRotation(self.rotationPartrightdoor.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartrightdoor.maxRot, self.rotationPartrightdoor.minRot, 3, self.rotationPartrightdoor.rotTime, dt, not self.rotationMaxrightdoor);
		   setRotation(self.rotationPartrightdoor.node, unpack(newRot));
        end;
        if self.rotationPartleftdoor ~= nil then
		   local x, y, z = getRotation(self.rotationPartleftdoor.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartleftdoor.maxRot, self.rotationPartleftdoor.minRot, 3, self.rotationPartleftdoor.rotTime, dt, not self.rotationMaxleftdoor);
		   setRotation(self.rotationPartleftdoor.node, unpack(newRot));
        end;
    end;

function AutomaticHatches:updateTick(dt)
end;

function AutomaticHatches:draw()
	if not self.helpPanel then
			g_currentMission:addExtraPrintText(g_i18n:getText("OpenDoor"));
		else
			g_currentMission:addExtraPrintText(g_i18n:getText("CloseDoor"));
		end;
end;

AutomaticHatchesEvent = {};
AutomaticHatchesEvent_mt = Class(AutomaticHatchesEvent, Event);

InitEventClass(AutomaticHatchesEvent, "AutomaticHatchesEvent");

function AutomaticHatchesEvent:emptyNew()
	local self = Event:new(AutomaticHatchesEvent_mt);
	print("emptyNew");
    return self;
end;

function AutomaticHatchesEvent:new(numKey, object)
	local self = AutomaticHatchesEvent:emptyNew();
	self.numKey = numKey;
	self.object = object;
	return self;
end;

function AutomaticHatchesEvent:readStream(streamId, connection)
	local numKey = streamReadInt8(streamId);
	local id = streamReadInt32(streamId);
    local object = networkGetObject(id);
	if object ~= nil then
		if numKey == 4 then object.rotationMaxrightdoor = not object.rotationMaxrightdoor; end;
		if numKey == 4 then object.rotationMaxleftdoor = not object.rotationMaxleftdoor; end;
	end;
end;

function AutomaticHatchesEvent:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.numKey);
	streamWriteInt32(streamId, networkGetObjectId(self.object));
end;