BorderSpreadingControlEvent = {};
BorderSpreadingControlEvent_mt = Class(BorderSpreadingControlEvent, Event);
InitEventClass(BorderSpreadingControlEvent, "BorderSpreadingControlEvent");

function BorderSpreadingControlEvent:emptyNew()
    local self = Event:new(BorderSpreadingControlEvent_mt);
    self.className = "BorderSpreadingControlEvent";
    return self;
end;

function BorderSpreadingControlEvent:new(vehicle, animTime)
    local self = BorderSpreadingControlEvent:emptyNew();
	self.vehicle = vehicle;
	self.animTime = animTime;
    return self;
end;

function BorderSpreadingControlEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	-- precision: 1 percent
	streamWriteInt8(streamId, math.floor(self.animTime*100));
end;

function BorderSpreadingControlEvent:readStream(streamId, connection)
	self.vehicle = networkGetObject(streamReadInt32(streamId));
	self.animTime = streamReadInt8(streamId)/100;
	self:run(connection);
end;

function BorderSpreadingControlEvent:run(connection)
	self.vehicle:setBSCAnimTime(self.animTime, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(BorderSpreadingControlEvent:new(self.vehicle, self.animTime), nil, connection, self.vehicle);
	end;
end;

function BorderSpreadingControlEvent.sendEvent(vehicle, animTime, noEventSend)
	if not noEventSend then
		if g_server ~= nil then
			g_server:broadcastEvent(BorderSpreadingControlEvent:new(vehicle, animTime), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(BorderSpreadingControlEvent:new(vehicle, animTime));
		end;
	end;
end;