--@Author: Alex2009, Sven777b
--@Web: www.alex2009.de, www.ls-landtechnik.de

fun = {};
fun.Dir = g_currentModDirectory;
fun_mt = Class(fun, Placeable);
InitObjectClass(fun, "fun");

function fun:new(isServer, isClient, customMt)
    local self = Placeable:new(isServer, isClient, fun_mt);
    registerObjectClassName(self, "fun");
    return self;
end;

function fun:delete()
    if self.FunScriptSound ~= nil then
        delete(self.FunScriptSound);
    end;
    removeTrigger(self.FunScriptTrigger);
    unregisterObjectClassName(self);
    fun:superClass().delete(self);
end;

function fun:deleteFinal()
    fun:superClass().deleteFinal(self);
end;

function fun:load(xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom)
    if not fun:superClass().load(self, xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom) then
        return false;
    end;
    local xmlFile = loadXMLFile("TempXML", xmlFilename);

    --Variabeln setzen...
    self.FunScriptActive = false;
    self.FunScriptCount = 50;
    
    --Ton Laden...
    local SoundFile = Utils.getFilename("Sound.ogg",fun.Dir);
    self.FunScriptSound = createSample("FunScriptSound");
    loadSample(self.FunScriptSound, SoundFile, false);

    --Baum Object suchen...
    self.FunScriptObject = getChildAt(self.nodeId, 1);
    
    --Trigger suchen...
    self.FunScriptTrigger = getChildAt(self.nodeId,2);
    addTrigger(self.FunScriptTrigger, "TriggerEvent", self);
    
    --Lichter laden...
    self.FunScriptLightTab = {};
    local count = 0;
    local maxcount = getNumOfChildren(getChildAt(getChildAt(self.nodeId,1),2)) - 1;
    while true do
        if count <= maxcount then
            local LightIndex = getChildAt(getChildAt(getChildAt(self.nodeId,1),2),count);
            if LightIndex == 0 or LightIndex == nil then
                break;
            end;
            self.FunScriptLightTab[count] = {index=LightIndex}
            count = count + 1;
        else
            break;
        end;
    end;
    self.FunScriptLoaded = true;
    for k,v in pairs(self.FunScriptLightTab) do
        local r=(math.random(0,1)*1);
        local g=(math.random(0,1)*1);
        local b=(math.random(0,1)*1);
        setShaderParameter(v.index, "partScale", r, g, b, 0, false)  
    end;   
    delete(xmlFile);
    return true;
end;

function fun:update(dt)
    if self.FunScriptActive then
        self.FunScriptCount=(self.FunScriptCount-1);
        rotate(self.FunScriptObject, 0, -0.0006*dt, 0);
        if(self.FunScriptCount <= 0) then
            for k,v in pairs(self.FunScriptLightTab) do
                local r=(math.random(0,1)*1);
                local g=(math.random(0,1)*1);
                local b=(math.random(0,1)*1);
                setShaderParameter(v.index, "partScale", r, g, b, 0, false)  
            end;
            self.FunScriptCount = 50;
        end;
    end;
end;

function fun:TriggerEvent(triggerId, otherId, onEnter, onLeave, onStay)
    if g_currentMission.player ~= nil and g_currentMission.player.rootNode == otherId and self.FunScriptLoaded then
        if onEnter then
            self.FunScriptActive = true;
            setSamplePitch(self.FunScriptSound, 1);
            playSample(self.FunScriptSound, 0, 0.6, 0);
        elseif onLeave then
            self.FunScriptActive = false;
            stopSample(self.FunScriptSound);
        end;
    end;
end;
registerPlaceableType("fun", fun);