-- 
-- placeableCarWash
-- platzierbare Waschanlage
--
-- @author schwaki|112TEC
-- @version v1.0
-- @date 31/03/2015
-- Modifikationen erst nach Rcksprache
-- Do not edit without my permission
-- 

placeableCarWash = {}; InitObjectClass(placeableCarWash, "placeableCarWash");  function placeableCarWash:new(isServer, isClient, customMt)  print("--- loading placeableCarWash - specialization for placeable car wash by 112TEC|schwaki");  if placeableCarWash_mt == nil then  placeableCarWash_mt = Class(placeableCarWash, Placeable);  end;  if mt == nil then  mt = placeableCarWash_mt;  end;  self = Placeable:new(isServer, isClient, mt);  registerObjectClassName(self, "placeableCarWash");  self.isServer=isServer;  self.isClient=isClient;  self.mt=mt;  self.nodeId=0;  self.trigHStId=nil;  self.trigHWaId=nil;  self.trigSStId=nil;  self.trigSWaId=nil;  self.trigInId=nil;  self.vehicleInRangeHSt=false;  self.playerInRangeSSt=false;  self.hallAnim = {};  self.swAnim = {};  self.vehiclesInHWA = {};  self.vehiclesInSWA = {};  self.countSST=0;  self.countHWA=0;  self.countSWA=0;  self.priceHWA=0;  self.priceSWA=0;  self.isActive=false;  self.justStarted = true;  self.isSunOn = false;  self.isNiceWeather = false;  return self; end;  function placeableCarWash:delete()  removeTrigger(self.trigHStId);  removeTrigger(self.trigHWaId);  removeTrigger(self.trigSStId);  removeTrigger(self.trigSWaId);  removeTrigger(self.trigInId);  unregisterObjectClassName(self);  placeableCarWash:superClass().delete(self); end;  function placeableCarWash:deleteFinal()  placeableCarWash:superClass().deleteFinal(self); end;  function placeableCarWash:load(xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom)  if not placeableCarWash:superClass().load(self, xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom) then  return false;  end;  if not moveMode then  self.lightOn = getChild(self.nodeId,"Licht", 0);  local trigHStId=Utils.getNoNil(getChild(self.nodeId,"hallenTrigger"),0);  if trigHStId ~= nil then  addTrigger(trigHStId, "triggerCallbackHST", self);  self.trigHStId=trigHStId;  self.hallAnim.speedScale = Utils.getNoNil(getUserAttribute(self.nodeId, "animationSpeed"),1);  self.hallAnim.animCharSet = 0;  local rootNode = getChildAt(trigHStId, 0);  self.hallAnim.animCharSet = getAnimCharacterSet(rootNode);  if self.hallAnim.animCharSet ~= 0 then  local clipSource = getUserAttribute(rootNode, "animationClip");  if clipSource ~= nil then  self.hallAnim.clip = getAnimClipIndex(self.hallAnim.animCharSet, clipSource);  if self.hallAnim.clip ~= nil then  if self.hallAnim.clip >= 0 then  assignAnimTrackClip(self.hallAnim.animCharSet, 0, self.hallAnim.clip);  setAnimTrackLoopState(self.hallAnim.animCharSet, 0, false);  setAnimTrackSpeedScale(self.hallAnim.animCharSet, 0, self.hallAnim.speedScale);  self.hallAnim.animDuration = getAnimClipDuration(self.hallAnim.animCharSet, self.hallAnim.clip);  else  print("Error:placeableCarWash.lua(85) clip for objectIndex "..tostring(rootNode).." is not usable");  end;  else  print("Error:placeableCarWash.lua(84) no clip named "..tostring(clipSource).." can be found in animation for objectIndex "..tostring(rootNode).."");  end;  else  print("Error:placeableCarWash.lua(82) no clip name assigned for objectIndex "..tostring(rootNode).."");  end;  else  print("Error:placeableCarWash.lua(80) no animation assigned for objectIndex "..tostring(rootNode).."");  end;  self.hallAnim.isEnabled = false;  self.hallAnim.trackTime = 0;  end;  local trigHWaId=Utils.getNoNil(getChild(self.nodeId,"WashtriggerHalle"),0);  if trigHWaId ~= nil then  addTrigger(trigHWaId, "triggerCallbackHWA", self);  self.trigHWaId=trigHWaId;  end;  local trigSStId=Utils.getNoNil(getChild(self.nodeId,"SWTrigger"),0);  if trigSStId ~= nil then  addTrigger(trigSStId, "triggerCallbackSST", self);  self.trigSStId=trigSStId;  self.swAnim.speedScale = Utils.getNoNil(getUserAttribute(self.nodeId, "animationSpeed"),1);  self.swAnim.animCharSet = 0;  local rootNode = getChildAt(trigSStId, 0)  self.swAnim.animCharSet = getAnimCharacterSet(rootNode);  if self.swAnim.animCharSet ~= 0 then  local clipSource = getUserAttribute(rootNode, "animationClip");  if clipSource ~= nil then  self.swAnim.clip = getAnimClipIndex(self.swAnim.animCharSet, clipSource);  if self.swAnim.clip ~= nil then  if self.swAnim.clip >= 0 then  assignAnimTrackClip(self.swAnim.animCharSet, 0, self.swAnim.clip);  setAnimTrackLoopState(self.swAnim.animCharSet, 0, false);  setAnimTrackSpeedScale(self.swAnim.animCharSet, 0, self.swAnim.speedScale);  self.swAnim.animDuration = getAnimClipDuration(self.swAnim.animCharSet, self.swAnim.clip);  else  print("Error:placeableCarWash.lua(132) clip for objectIndex "..tostring(rootNode).." is not usable");  end;  else  print("Error:placeableCarWash.lua(131) no clip named "..tostring(clipSource).." can be found in animation for objectIndex "..tostring(rootNode).."");  end;  else  print("Error:placeableCarWash.lua(129) no clip name assigned for objectIndex "..tostring(rootNode).."");  end;  else  print("Error:placeableCarWash.lua(127) no animation assigned for objectIndex "..tostring(rootNode).."");  end;  self.swAnim.isEnabled = false;  self.swAnim.trackTime = 0;  local defaultInputBinding = 'SWTRIGGER_ACTION'  if InputBinding[defaultInputBinding] == nil then  defaultInputBinding = 'IMPLEMENT_EXTRA3';  end;  local startTextID = Utils.getNoNil(getUserAttribute(rootNode,'startText'),'START');  local stopTextID = Utils.getNoNil(getUserAttribute(rootNode,'stopText'),'STOP');  self.startText = Utils.getNoNil(g_i18n:getText(startTextID),'starten');  self.stopText = Utils.getNoNil(g_i18n:getText(stopTextID),'stoppen');  self.inputBinding = Utils.getNoNil(getUserAttribute(rootNode,'inputBinding'),defaultInputBinding);  end;  local trigSWaId=Utils.getNoNil(getChild(self.nodeId,"WashtriggerSW"),0);  if trigSWaId ~= nil then  addTrigger(trigSWaId, "triggerCallbackSWA", self);  self.trigSWaId=trigSWaId;  end;  local trigInId=Utils.getNoNil(getChild(self.nodeId,"enterTrigger"),0);  if trigInId ~= nil then  addTrigger(trigInId, "triggerCallbackIN", self);  self.trigInId=trigInId;  end;  self.pricePerUnit = Utils.getNoNil(getUserAttribute(self.nodeId, "pricePerUnit"),0.005);  self.washPerSecond = Utils.getNoNil(getUserAttribute(self.nodeId, "washPerSecond"),0.02);  self.statName = Utils.getNoNil(getUserAttribute(self.nodeId, "statName"),"vehicleRunningCost");  end;  return true; end;  function placeableCarWash:readStream(streamId, connection)  placeableCarWash:superClass().readStream(self, streamId, connection);  end;  function placeableCarWash:writeStream(streamId, connection)  placeableCarWash:superClass().writeStream(self, streamId, connection)  end;  function placeableCarWash:readUpdateStream(streamId, timestamp, connection)  placeableCarWash:superClass().readUpdateStream(self, streamId, timestamp, connection); end;  function placeableCarWash:writeUpdateStream(streamId, connection, dirtyMask)  placeableCarWash:superClass().writeUpdateStream(self, streamId, connection, dirtyMask);  end;  function placeableCarWash:update(dt)  if self.vehicleInRangeHSt then  if not self.hallAnim.isEnabled and self.isActive then  enableAnimTrack(self.hallAnim.animCharSet, self.hallAnim.clip);  self.hallAnim.isEnabled = true;  end;  end;  if self.hallAnim.isEnabled then  self.hallAnim.trackTime = self.hallAnim.trackTime + dt * self.hallAnim.speedScale;  if self.pricePerUnit>0 then  self.priceHWA = math.floor((self.pricePerUnit * self.countHWA) + 0.5);  g_currentMission:addExtraPrintText(string.format(g_i18n:getText("COSTSHWA")..": "..g_i18n:formatMoney(self.priceHWA)));  end;  if self.hallAnim.trackTime > self.hallAnim.animDuration then  self.hallAnim.trackTime = 0;  setAnimTrackTime(self.hallAnim.animCharSet, self.hallAnim.clip, self.hallAnim.trackTime, true);  disableAnimTrack(self.hallAnim.animCharSet, self.hallAnim.clip);  self.hallAnim.isEnabled = false;  self.isActive = false;  self.countHWA = 0;  if self.isServer then  g_currentMission:addSharedMoney(-self.priceHWA, self.statName)  end;  end;  if table.getn(self.vehiclesInHWA) > 0 then  for _,vehicle in pairs(self.vehiclesInHWA) do  local vehicle = g_currentMission.nodeToVehicle[vehicle];  local removeAmount = self.washPerSecond/1000 * dt;  if vehicle.dirtAmount~=nil and vehicle.setDirtAmount~=nil then  if vehicle.dirtAmount>self.washPerSecond then  self.countHWA=self.countHWA + 1;  local newAmount = math.min(vehicle.dirtAmount, removeAmount);  vehicle:setDirtAmount(vehicle.dirtAmount - newAmount);  end;  end;  end;  end;  end;  local showHelpButton = false;  if self.playerInRangeSSt then  showHelpButton = true;  if InputBinding.hasEvent(InputBinding[self.inputBinding]) then  if self.countSST == 0 then  self.countSST = self.countSST + 1;  else  self.countSST = self.countSST - 1;  if self.countSST < 0 then  self.countSST = 0;  end;  end;  end;  if self.countSST > 0 then  g_currentMission:addHelpButtonText(self.stopText, InputBinding[self.inputBinding]);  else  g_currentMission:addHelpButtonText(self.startText, InputBinding[self.inputBinding]);  end;  end;  if self.countSST > 0 then  if self.swAnim.trackTime < self.swAnim.animDuration then  self.swAnim.trackTime = self.swAnim.trackTime + dt * self.swAnim.speedScale;  end;  if self.pricePerUnit>0 then  self.priceSWA = math.floor((self.pricePerUnit * self.countSWA) + 0.5)  g_currentMission:addExtraPrintText(string.format(g_i18n:getText("COSTSSWA")..": "..g_i18n:formatMoney(self.priceSWA)));  end;  self.swAnim.isEnabled = true;  if table.getn(self.vehiclesInSWA) > 0 then  for _,vehicle in pairs(self.vehiclesInSWA) do  local vehicle = g_currentMission.nodeToVehicle[vehicle];  local removeAmount = self.washPerSecond/1000 * dt;  if vehicle.dirtAmount~=nil and vehicle.setDirtAmount~=nil then  if vehicle.dirtAmount>self.washPerSecond then  self.countSWA=self.countSWA + 1;  local newAmount = math.min(vehicle.dirtAmount, removeAmount);  vehicle:setDirtAmount(vehicle.dirtAmount - newAmount);  end;  end;  end;  end;  else  if self.swAnim.trackTime > 0 then  self.swAnim.trackTime = self.swAnim.trackTime - dt * self.swAnim.speedScale;  end;  self.countSWA = 0  if self.swAnim.isEnabled then  if self.isServer then  g_currentMission:addSharedMoney(-self.priceSWA, self.statName);  end;  self.swAnim.isEnabled = false;  end;  end;  if self.swAnim.lastTrackTime ~= self.swAnim.trackTime then  enableAnimTrack(self.swAnim.animCharSet, self.swAnim.clip);  setAnimTrackTime(self.swAnim.animCharSet, self.swAnim.clip, self.swAnim.trackTime, true);  disableAnimTrack(self.swAnim.animCharSet, self.swAnim.clip);  self.swAnim.lastTrackTime = self.swAnim.trackTime;  end;  if self.justStarted or self.isSunOn ~= g_currentMission.environment.isSunOn or self.isNiceWeather ~= (g_currentMission.environment.currentRain == nil) then  self.isSunOn = g_currentMission.environment.isSunOn;  self.isNiceWeather = g_currentMission.environment.currentRain == nil;  self.justStarted = false;  setVisibility(self.lightOn, not (self.isSunOn and self.isNiceWeather));  end;  end;  function placeableCarWash:triggerCallbackHST(triggerId, otherId, onEnter, onLeave, onStay)  if onEnter then  self.vehicleInRangeHSt=true;  else  self.vehicleInRangeHSt=false;  end; end;  function placeableCarWash:triggerCallbackHWA(triggerId, otherId, onEnter, onLeave, onStay)  if onEnter then  table.insert(self.vehiclesInHWA, otherId);  elseif onLeave then  if table.getn(self.vehiclesInHWA) > 0 then  for x, y in pairs(self.vehiclesInHWA) do  if y == otherId then  table.remove(self.vehiclesInHWA,x);  end;  end;  end;  end;  end;  function placeableCarWash:triggerCallbackSST(triggerId, otherId, onEnter, onLeave, onStay)  if g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then  if onEnter then  self.playerInRangeSSt=true;  else  self.playerInRangeSSt = false;  end;  end; end;  function placeableCarWash:triggerCallbackSWA(triggerId, otherId, onEnter, onLeave, onStay)  if onEnter then  table.insert(self.vehiclesInSWA, otherId);  elseif onLeave then  if table.getn(self.vehiclesInSWA) > 0 then  for x, y in pairs(self.vehiclesInSWA) do  if y == otherId then  table.remove(self.vehiclesInSWA,x);  end;  end;  end;  end;  end;  function placeableCarWash:triggerCallbackIN(triggerId, otherId, onEnter, onLeave, onStay)  if onEnter then  self.isActive=true;  end; end;  registerPlaceableType("placeableCarWash", placeableCarWash); 