--[[
	BaleToStraw

	Autor: 	Ifko[nator]
	Date: 	08.10.2015
]]

BaleToStraw = {}

local BaleToStraw_mt = Class(BaleToStraw, Object);

function baleToStrawOnCreate(id)
	local trigger = BaleToStraw:new(g_server ~= nil, g_client ~= nil);
    local index = g_currentMission:addOnCreateLoadedObject(trigger);
    trigger:load(id);
    trigger:register(true);
end;

g_onCreateUtil.addOnCreateFunction("baleToStrawOnCreate", baleToStrawOnCreate);

function BaleToStraw:new(isServer, isClient)
	local self = Object:new(isServer, isClient, BaleToStraw_mt);
	self.className = "BaleToStraw";
	return self;
end;

function BaleToStraw:delete()
	removeTrigger(self.triggerId);
end;

function BaleToStraw:load(id)
	self.triggerId = id;
	addTrigger(self.triggerId, "triggerCallback", self);
end;

function BaleToStraw:update(dt)
end;

function BaleToStraw:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	if g_server ~= nil then
		local object = g_currentMission:getNodeObject(otherId)
		if object ~= nil and object:isa(Bale) and object.fillType == Fillable.FILLTYPE_BARLEY_WINDROW or object.fillType == Fillable.FILLTYPE_WHEAT_WINDROW then
			if not (object.isAttached ~= nil and object.isAttached) then
				object:delete();
				g_currentMission:setSiloAmount(Fillable.FILLTYPE_WHEAT_WINDROW, g_currentMission:getSiloAmount(Fillable.FILLTYPE_WHEAT_WINDROW) + object.fillLevel);
				--## Play PS? Maybe something for the future ..
			end;
		end;
	end;
end;