--[[
	BaleToCowManure

	Autor: 	Ifko[nator]
	Date: 	08.10.2015
]]

BaleToCowManure = {}

local BaleToCowManure_mt = Class(BaleToCowManure, Object);

function baleToCowManureOnCreate(id)
	local trigger = BaleToCowManure:new(g_server ~= nil, g_client ~= nil);
    local index = g_currentMission:addOnCreateLoadedObject(trigger);
    trigger:load(id);
    trigger:register(true);
end;

g_onCreateUtil.addOnCreateFunction("baleToCowManureOnCreate", baleToCowManureOnCreate);

function BaleToCowManure:new(isServer, isClient)
	local self = Object:new(isServer, isClient, BaleToCowManure_mt);
	self.className = "BaleToCowManure";
	return self;
end;

function BaleToCowManure:delete()
	removeTrigger(self.triggerId);
end;

function BaleToCowManure:load(id)
	self.triggerId = id;
	addTrigger(self.triggerId, "triggerCallback", self);
end;

function BaleToCowManure:update(dt)
end;

function BaleToCowManure:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	if g_server ~= nil then
		local object = g_currentMission:getNodeObject(otherId);
		local cowManure = g_currentMission:getNodeObject(g_currentMission.husbandries.cow.manureHeap.triggerId);
		if object ~= nil and object:isa(Bale) and object.fillType == Fillable.FILLTYPE_BARLEY_WINDROW or object.fillType == Fillable.FILLTYPE_WHEAT_WINDROW then
			if not (object.isAttached ~= nil and object.isAttached) then
				object:delete();
				cowManure:setFillLevel(g_currentMission.husbandries.cow.manureHeap.fillLevel + object.fillLevel);
				--## Play PS? Maybe something for the future ..
			end;
		end;
	end;
end;