local metadata = {
"## Interface: 2.0.0.9",
"## Title: Manure Mod",
"## Notes: Manure Mod add manurelayer to Spray",
"## Author: Marhu",
"## Version: 2.2.4",
"## Date: 01.02.2014"
}

local GMMFillTypes = {}

GMKM = {};

function GMKM:SprayerLoad(xmlFile)
	if Fillable.FILLTYPE_MANURE and GMMFillTypes[Fillable.FILLTYPE_MANURE] == nil then 
		GMMFillTypes[Fillable.FILLTYPE_MANURE] = FruitUtil.FRUITTYPE_MANURESOLID
		if Fillable.FILLTYPE_LIQUIDMANURE then GMMFillTypes[Fillable.FILLTYPE_LIQUIDMANURE] = FruitUtil.FRUITTYPE_MANURELIQUID end;
		if Fillable.FILLTYPE_KALK then GMMFillTypes[Fillable.FILLTYPE_KALK] = FruitUtil.FRUITTYPE_KALKSOLID end;
	end;
	if Fillable.FILLTYPE_KALK then
		if hasXMLProperty(xmlFile, "vehicle.typeDesc") then
			local typeDesc = getXMLString(xmlFile,"vehicle.typeDesc");
			if typeDesc == nil then
				typeDesc = getXMLString(xmlFile,"vehicle.typeDesc.en");
			end
			if typeDesc ~= nil and string.find(typeDesc,"FertilizerSpreader") then
				self.fillTypes[Fillable.FILLTYPE_KALK] = true;
			end
		end;
	end;
	self.FeldBegrenzung = true;
end;

function GMKM:SprayerUpdate(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.FeldBegrenzung) then
			self.FeldBegrenzung = not self.FeldBegrenzung;
			self:raiseDirtyFlags(self.sprayerDirtyFlag);
		end;
	end;
end;

function GMKM:SprayerDraw()
	if self.FeldBegrenzung then
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_off_OBJECT"), g_i18n:getText("FeldBegrenzung")),InputBinding.FeldBegrenzung);
	else
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_on_OBJECT"), g_i18n:getText("FeldBegrenzung")),InputBinding.FeldBegrenzung);
	end;
end;

function GMKM:SprayerReadStream(streamId, connection)
	self.FeldBegrenzung = streamReadBool(streamId);
end
function GMKM:SprayerWriteStream(streamId, connection)
	streamWriteBool(streamId,self.FeldBegrenzung);
end
function GMKM:SprayerReadUpdateStream(streamId, timestamp, connection)
	self.FeldBegrenzung = streamReadBool(streamId);
end
function GMKM:SprayerWriteUpdateStream(streamId, connection, dirtyMask)
	streamWriteBool(streamId,self.FeldBegrenzung);
end

Sprayer.load   = Utils.appendedFunction(Sprayer.load, GMKM.SprayerLoad);
Sprayer.update = Utils.appendedFunction(Sprayer.update, GMKM.SprayerUpdate);
Sprayer.draw   = Utils.appendedFunction(Sprayer.draw, GMKM.SprayerDraw);
Sprayer.readStream = Utils.appendedFunction(Sprayer.readStream, GMKM.SprayerReadStream);
Sprayer.writeStream = Utils.appendedFunction(Sprayer.writeStream, GMKM.SprayerWriteStream);
Sprayer.readUpdateStream = Utils.appendedFunction(Sprayer.readUpdateStream, GMKM.SprayerReadUpdateStream);
Sprayer.writeUpdateStream = Utils.appendedFunction(Sprayer.writeUpdateStream, GMKM.SprayerWriteUpdateStream);

local orgi_sprayerUpdateTick = Sprayer.updateTick
Sprayer.updateTick = function(self, dt)
	orgi_sprayerUpdateTick(self, dt);
	
	if self.isTurnedOn and self.fillLevel > 0 then
		local windrowId = nil;
		if GMMFillTypes[self.currentFillType] then
			if g_currentMission.fruits[GMMFillTypes[self.currentFillType]] then
				windrowId = g_currentMission.fruits[GMMFillTypes[self.currentFillType]].windrowId;
			end;
		end;
		if windrowId ~= nil then
			for _,workArea in pairs(self.workAreas) do
				if self:getIsAreaActive(workArea) then
					local x, y, z = getWorldTranslation(workArea.start)
					local x1, y1, z1 = getWorldTranslation(workArea.width)
					local x2, y2, z2 = getWorldTranslation(workArea.height)
					Utils.updateManureWindrowArea(windrowId, x, z, x1, z1, x2, z2, not self.FeldBegrenzung)
				end;
			end;
		end;
	end;
end;

Utils.updateManureWindrowArea = function(windrowId, x, z, x1, z1, x2, z2, force)
	
	local IDs,detailId = {},g_currentMission.terrainDetailId;
	local dx, dz, dwidthX, dwidthZ, dheightX, dheightZ = Utils.getXZWidthAndHeight(detailId, x, z, x1, z1, x2, z2);
	
	if force then
		setDensityParallelogram(windrowId, dx, dz, dwidthX, dwidthZ, dheightX, dheightZ, 0, g_currentMission.numWindrowChannels, g_currentMission.maxWindrowValue);
	else
		table.insert(IDs,g_currentMission.cultivatorChannel);
		table.insert(IDs,g_currentMission.sowingChannel);
		table.insert(IDs,g_currentMission.ploughChannel);
		table.insert(IDs,g_currentMission.terrainDetailTypeFirstChannel);
		
		for i = 1, table.getn(IDs) do
			setDensityMaskedParallelogram(windrowId, dx, dz, dwidthX, dwidthZ, dheightX, dheightZ, 0, 1, detailId, IDs[i], g_currentMission.terrainDetailTypeNumChannels, 1);
		end;
	end;
end;

Utils.DestroyManureWindrowArea = function(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ)
	local value = 0;
	for k, v in pairs(GMMFillTypes) do
		if g_currentMission.fruits[v] ~= nil then
			value = value + Utils.updateDensity(g_currentMission.fruits[v].windrowId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, 0);
		end;
	end
	return math.min(1,value);
end;

local orgi_UpdateDestroyCommonArea = Utils.updateDestroyCommonArea;
Utils.updateDestroyCommonArea = function(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, limitToField)
	orgi_UpdateDestroyCommonArea(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, limitToField);
	Utils.DestroyManureWindrowArea(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ);
end;

local orgi_cutFruitArea = Utils.cutFruitArea;
Utils.cutFruitArea =  function(fruitId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, destroySpray, destroySeedingWidth)
	local pixelsSum, numPixels, spraySum = orgi_cutFruitArea(fruitId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, destroySpray, destroySeedingWidth);
	if destroySpray then Utils.DestroyManureWindrowArea(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ); end;
	return pixelsSum, numPixels, spraySum;
end;

local orgi_updateSowingArea = Utils.updateSowingArea;
Utils.updateSowingArea = function(fruitId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, angle, useDirectPlanting)
	local numPixels, numDetailPixels = orgi_updateSowingArea(fruitId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, angle, useDirectPlanting);
	Utils.DestroyManureWindrowArea(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ);
	return numPixels, numDetailPixels;
end;
