-- author: rafftnix
-- date: 30.06.2015

-- note: rafftnixGUI2 needed!!

camerapipe = {};

function camerapipe.prerequisitesPresent(specializations)
    return RafftnixGUI2 ~= nil;
end;

function camerapipe:load(xmlFile)
	self.gui2 = RafftnixGUI2:new(nil, false, false);

	local posX = getXMLFloat(xmlFile, "vehicle.camerapipe.backGround#x");
	local posY = getXMLFloat(xmlFile, "vehicle.camerapipe.backGround#y");
	local width = getXMLFloat(xmlFile, "vehicle.camerapipe.backGround#width");
	local height = getXMLFloat(xmlFile, "vehicle.camerapipe.backGround#height");
	local fileName = getXMLString(xmlFile, "vehicle.camerapipe.backGround#fileName");
	self.gui2:createImage(self.gui2.baseElement, posX, posY, width, height, fileName);

	local cameraId = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.camerapipe#index"));
	local posX = getXMLFloat(xmlFile, "vehicle.camerapipe.position#x");
	local posY = getXMLFloat(xmlFile, "vehicle.camerapipe.position#y");
	local width = getXMLFloat(xmlFile, "vehicle.camerapipe.position#width");
	local height = getXMLFloat(xmlFile, "vehicle.camerapipe.position#height");
	self.gui2:createRenderOverlay(self.gui2.baseElement, posX, posY, width, height, cameraId, 128, 128, getScreenAspectRatio());
end;

function camerapipe:delete()
  
end;

function camerapipe:mouseEvent(posX, posY, isDown, isUp, button)
end;

function camerapipe:keyEvent(unicode, sym, modifier, isDown)
end;

function camerapipe:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.camerapipe) then
			local visibility = self.gui2.baseElement.visibility;
			visibility = not visibility;
			if visibility then
				self.gui2:open();
			else
				self.gui2:close();
			end;
		end;
	elseif self.gui2.baseElement.visibility then
		self.gui2:close();
	end;
end;

function camerapipe:draw()
	if self.gui2.baseElement.visibility then
		g_currentMission:addHelpButtonText(g_i18n:getText("deactivatecamerapipe"), InputBinding.camerapipe); 
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("activatecamerapipe"), InputBinding.camerapipe); 
	end;
end;