-- author: rafftnix
-- date: 30.06.2015

-- note: rafftnixGUI needed!!

cameraback = {};

function cameraback.prerequisitesPresent(specializations)
    return RafftnixGUI ~= nil;
end;

function cameraback:load(xmlFile)
	self.gui = RafftnixGUI:new(nil, false, false);

	local posX = getXMLFloat(xmlFile, "vehicle.cameraback.backGround#x");
	local posY = getXMLFloat(xmlFile, "vehicle.cameraback.backGround#y");
	local width = getXMLFloat(xmlFile, "vehicle.cameraback.backGround#width");
	local height = getXMLFloat(xmlFile, "vehicle.cameraback.backGround#height");
	local fileName = getXMLString(xmlFile, "vehicle.cameraback.backGround#fileName");
	self.gui:createImage(self.gui.baseElement, posX, posY, width, height, fileName);

	local cameraId = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.cameraback#index"));
	local posX = getXMLFloat(xmlFile, "vehicle.cameraback.position#x");
	local posY = getXMLFloat(xmlFile, "vehicle.cameraback.position#y");
	local width = getXMLFloat(xmlFile, "vehicle.cameraback.position#width");
	local height = getXMLFloat(xmlFile, "vehicle.cameraback.position#height");
	self.gui:createRenderOverlay(self.gui.baseElement, posX, posY, width, height, cameraId, 128, 128, getScreenAspectRatio());
end;

function cameraback:delete()
  
end;

function cameraback:mouseEvent(posX, posY, isDown, isUp, button)
end;

function cameraback:keyEvent(unicode, sym, modifier, isDown)
end;

function cameraback:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.cameraback) then
			local visibility = self.gui.baseElement.visibility;
			visibility = not visibility;
			if visibility then
				self.gui:open();
			else
				self.gui:close();
			end;
		end;
	elseif self.gui.baseElement.visibility then
		self.gui:close();
	end;
end;

function cameraback:draw()
	if self.gui.baseElement.visibility then
		g_currentMission:addHelpButtonText(g_i18n:getText("deactivatecameraback"), InputBinding.cameraback); 
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("activatecameraback"), InputBinding.cameraback); 
	end;
end;