-- animatedHydraulic
--
-- @author		madabub
--
-- @date:		08/04/14
-- @version:	v1.0
-- @history:	v1.0 - initial version
--
-- free for noncommercial-usage

animatedHydraulic = {}; 

function animatedHydraulic.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations); 
end;

function animatedHydraulic:load(xmlFile)
	self.animatedHydraulic = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.animatedHydraulic.hydraulic(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break; 
		end;
		local hydraulic = {}
		hydraulic.index = getXMLInt(xmlFile, key .. "#index");
        if hydraulic.index ~= nil then
			hydraulic.animationName = getXMLString(xmlFile, key .. "#animationName");
			table.insert(self.animatedHydraulic, hydraulic);
		end;
		i = i + 1;
	end;
	self.updateJoint = false;
end;

function animatedHydraulic:delete()
end;

function animatedHydraulic:mouseEvent(posX, posY, isDown, isUp, button)
end;

function animatedHydraulic:keyEvent(unicode, sym, modifier, isDown)
end;

function animatedHydraulic:update(dt)
end;

function animatedHydraulic:draw()
end;

function animatedHydraulic:attachImplement(implement)
	for k , hydraulic in pairs(self.animatedHydraulic) do
		if implement.jointDescIndex == hydraulic.index then
			if hydraulic.animationName ~= nil and self.playAnimation ~= nil then
				self:playAnimation(hydraulic.animationName, 1, nil, true);
			end;
		end
	end;
	self.updateJoint = true;
end;

function animatedHydraulic:detachImplement(implementIndex)
	for k , hydraulic in pairs(self.animatedHydraulic) do
		if self.attachedImplements[implementIndex].jointDescIndex == hydraulic.index then
			if hydraulic.animationName ~= nil and self.playAnimation ~= nil then
				self:playAnimation(hydraulic.animationName, -1, nil, true);
			end;
		end
	end;
end;

function animatedHydraulic:validateAttacherJoint(implement, jointDesc, dt)
	if self.updateJoint then
		self.updateJoint = false;
		return true;
	end;
	return false;
end;