--
-- manualUnloading Script
-- author: Patar
-- date: 26.11.2014
--
print("--- manualUnloading by Patar loaded! (V1.0)")
manualUnloading = {};

function manualUnloading.prerequisitesPresent(specializations)
    return true
end;

function manualUnloading:load(xmlFile)
	if self.capacity > 0 then
		self.canUnload = false;
		self.backupOverloadingCapacity = self.overloadingCapacity;
		self.overloadingCapacity = 0;
		self.trailerFound = 0;
	end;
end;

function manualUnloading:delete()
end;

function manualUnloading:mouseEvent(posX, posY, isDown, isUp, button)
end;

function manualUnloading:keyEvent(unicode, sym, modifier, isDown)
end;

function manualUnloading:update(dt)
	if self.capacity > 0 then
		if self.trailerFound > 0 and self.fillLevel > 0 and self.pipeStateIsUnloading[self.currentPipeState] and self:getIsPipeUnloadingAllowed() then
			self.canUnload = true;
		else
			self.canUnload = false;
		end;

		if self:getIsActiveForInput(false) then
			if (self.canUnload and not self.pipeIsUnloading and InputBinding.hasEvent(InputBinding.ACTIVATE_OBJECT)) or isHired then
				self.overloadingCapacity = self.backupOverloadingCapacity;
			elseif (self.canUnload and self.pipeIsUnloading and InputBinding.hasEvent(InputBinding.ACTIVATE_OBJECT)) or not self.canUnload then
				self.overloadingCapacity = 0;
			end;
		end;
	end;
end;

function manualUnloading:updateTick(dt)
end;

function manualUnloading:draw()
	if self.capacity > 0 then
		if self.canUnload and not self.pipeIsUnloading then
			g_currentMission:addHelpButtonText(g_i18n:getText("startUnloading"), InputBinding.ACTIVATE_OBJECT);
		end;
		if self.pipeIsUnloading then
			g_currentMission:addHelpButtonText(g_i18n:getText("stopUnloading"), InputBinding.ACTIVATE_OBJECT);
		end;
	end;
end;

function manualUnloading:onAttach(attacherVehicle)
end;

function manualUnloading:onDetach()
end;

function manualUnloading:onLeave()
end;

Combine.load  = Utils.prependedFunction(Combine.load, manualUnloading.load);
Combine.update  = Utils.appendedFunction(Combine.update, manualUnloading.update);
Combine.draw  = Utils.appendedFunction(Combine.draw, manualUnloading.draw);