Ripper = {};

  
function Ripper.prerequisitesPresent(specializations)
      return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Ripper:load(xmlFile)

        self.groundContactReport = SpecializationUtil.callSpecializationsFunction("groundContactReport");
        self.contactReportNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.contactReportNode#index"));
       if self.contactReportNode == nil then
            self.contactReportNode = self.components[3].node;
        end;

        self.groundReferenceThreshold = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.groundReferenceNode#threshold"), 0.2);
        self.groundReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.groundReferenceNode#index"));
        self.aiTerrainDetailChannel1 = g_currentMission.sowingChannel;
        self.aiTerrainDetailChannel2 = g_currentMission.cultivatorChannel;
        self.RipperHasGroundContact = false;
        self.RipperHasContactReport = false;
        self.translationMax = false;
        self.RipperContactReportsActive = false;
        self.RipperLimitToField = false;
        self.RipperGroundContactFlag = self.nextDirtyFlag;
        self.nextDirtyFlag = self.RipperGroundContactFlag*2;
        
        self.fillremplissage = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fillremplissage"), 500);
        
        self.point1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.ripper1#index"));
  		self.point2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.ripperr#index"));
  		self.fallOut = false;


   	self.numripAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.ripAreas#count"), 0);
    self.ripAreas = {}
    for i=1, self.numripAreas do
        self.ripAreas[i] = {};
        local areanamei = string.format("vehicle.ripAreas.ripArea%d", i);
        self.ripAreas[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
        self.ripAreas[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
        self.ripAreas[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
    end;
        
        

        
end;
  
function Ripper:delete()

       Ripper.removeContactReports(self);
end;
 
function Ripper:readStream(streamId, connection)
end;
 
function Ripper:writeStream(streamId, connection)
end;
 

function Ripper:readUpdateStream(streamId, timestamp, connection)
	if connection:getIsServer() then
		self.RipperHasGroundContact = streamReadBool(streamId);
	end;
end;

function Ripper:writeUpdateStream(streamId, connection, dirtyMask)
	if not connection:getIsServer() then
		streamWriteBool(streamId, self.RipperHasGroundContact);
	end;
end;

function Ripper:mouseEvent(posX, posY, isDown, isUp, button)
end;
 
function Ripper:keyEvent(unicode, sym, modifier, isDown)
end;
 
function Ripper:update(dt)
end;
 
function Ripper:updateTick(dt)
   Ripper.addContactReports(self);
   

   
    if self:getIsActiveForInput() then
        if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
        	self.translationMax = not self.translationMax;
        end;
    end;
   
    if self.isServer then
		local hasGroundContact = self.RipperHasContactReport;
		if not hasGroundContact then
         	if self.groundReferenceNode ~= nil then
            	local x,y,z = getWorldTranslation(self.groundReferenceNode);
                local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
                if terrainHeight+self.groundReferenceThreshold >= y then
                	hasGroundContact = true;
                end;
            end;
        end;
		if self.RipperHasGroundContact ~= hasGroundContact then
        	self:raiseDirtyFlags(self.RipperGroundContactFlag);
        end;
        self.RipperHasGroundContact = hasGroundContact;
	end;
	local hasGroundContact = self.RipperHasGroundContact;
   
	if hasGroundContact then
		if self.movingDirection == 1 then
			self.jumWheelsActive = true ;
		
		else
			self.jumWheelsActive = false ;
		
		end;
	end;
	
	
		if hasGroundContact then
			if self.isServer then
				local ripAreasSend = {};
				for k, ripArea in pairs(self.ripAreas) do
					if self:getIsAreaActive(ripArea) then
						local x,y,z = getWorldTranslation(ripArea.start);
						local x1,y1,z1 = getWorldTranslation(ripArea.width);
                    	local x2,y2,z2 = getWorldTranslation(ripArea.height);
                    	--Utils.updateCultivatorArea(x, z, x1, z1, x2, z2, not self.CultivatorLimitToField);
                    	table.insert(ripAreasSend, {x,z,x1,z1,x2,z2});
               		end;
				end;
            	if (table.getn(ripAreasSend) > 0) then
 					CultivatorAreaEvent.runLocally(ripAreasSend, limitToField);
             	   g_server:broadcastEvent(CultivatorAreaEvent:new(ripAreasSend, limitToField));
				end;
				end;
		end;

	

    
    			

	
	
	
	
end;
 

 
function Ripper:addContactReports()
	if not self.RipperContactReportsActive then
		addContactReport(self.contactReportNode, 0.0001, "groundContactReport", self);
		self.RipperContactReportsActive = true;
      
	end;
end;

function Ripper:removeContactReports()
	if self.RipperContactReportsActive then
		removeContactReport(self.contactReportNode);
		self.RipperHasContactReport = false;
		self.RipperContactReportsActive = false;
	
	end;
end;
 
function Ripper:groundContactReport(objectId, otherObjectId, isStart, normalForce, tangentialForce)
	if otherObjectId == g_currentMission.terrainRootNode then
		self.RipperHasContactReport = isStart or normalForce > 0 or tangentialForce > 0;
	end;
end;

function Ripper:draw()
end;
