--
-- otval
-- author: werik
--

otval = {};

function otval.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function otval:load(xmlFile)
	local rotationPartNodecenter = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.center#index"));
    if rotationPartNodecenter~= nil then
        self.rotationPartcenter = {};
        self.rotationPartcenter.node = rotationPartNodecenter;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartcenter#minRot"));
        self.rotationPartcenter.minRot = {};
        self.rotationPartcenter.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartcenter.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartcenter.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.center#maxRot"));
        self.rotationPartcenter.maxRot = {};
        self.rotationPartcenter.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartcenter.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartcenter.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartcenter.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.center#rotTime"), 2)*1000;
        self.rotationPartcenter.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.center#touchRotLimit"), 10));
    end;
end;

function otval:readStream(streamId, connection)
end;

function otval:writeStream(streamId, connection)
end;

function otval:delete()
end;

 
function otval:mouseEvent(posX, posY, isDown, isUp, button)
end;

function otval:keyEvent(unicode, sym, modifier, isDown)
	if isDown and sym == Input.KEY_v then 
		self.rotationMaxcenter = not self.rotationMaxcenter;
	end;
end;
 
function otval:update(dt)
	if self.rotationPartcenter  ~= nil then
		local x, y, z = getRotation(self.rotationPartcenter .node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartcenter.maxRot, self.rotationPartcenter.minRot, 3, self.rotationPartcenter.rotTime, dt, not self.rotationMaxcenter);
		setRotation(self.rotationPartcenter .node, unpack(newRot));
	end;
end;

function otval:onDetach()
      if self.deactivateOnDetach then
      otval.onDeactivate(self);
    end;
end;

function otval:onLeave()
end;

function otval:onDeactivate()
	self.rotationMaxcenter = false;
end;

function otval:draw()
end;
