--
-- @author rucafer
-- @date 23/03/2016
--

pickinghead = {};

function pickinghead.prerequisitesPresent(specializations)
	return true;
end;

function pickinghead:load(xmlFile)
	self.foot1animation = getXMLString(xmlFile, "vehicle.feet.foot1#anim");
	self.foot1Trigger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.feet.foot1#trigger"));
	addTrigger(self.foot1Trigger, "foot1Trigger", self);
	self.playerIsInFoot1Trigger = false;
	self.foot1visibility = true
	self.foot2animation = getXMLString(xmlFile, "vehicle.feet.foot2#anim");
	self.foot2Trigger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.feet.foot2#trigger"));
	addTrigger(self.foot2Trigger, "foot2Trigger", self);
	self.playerIsInFoot2Trigger = false;
	self.foot2visibility = true
	self.foot3animation = getXMLString(xmlFile, "vehicle.feet.foot3#anim");
	self.foot3Trigger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.feet.foot3#trigger"));
	addTrigger(self.foot3Trigger, "foot3Trigger", self);
	self.playerIsInFoot3Trigger = false;
	self.foot3visibility = true
	self.foot4animation = getXMLString(xmlFile, "vehicle.feet.foot4#anim");
	self.foot4Trigger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.feet.foot4#trigger"));
	addTrigger(self.foot4Trigger, "foot4Trigger", self);
	self.playerIsInFoot4Trigger = false;
	self.foot4visibility = true
	self.storagemode_anim = getXMLString(xmlFile, "vehicle.feet.storagemode#anim");
	self.storagemode = true
	self.isDetachAllowed = Utils.overwrittenFunction(self.isDetachAllowed, pickinghead.isDetachAllowed);
	self.turnedOnAnimation = getXMLString(xmlFile, "vehicle.turnedOnAnimation#anim");
	self.speed = getXMLInt(xmlFile, "vehicle.turnedOnAnimation#speed");
	self.turnedOnAnimation2 = getXMLString(xmlFile, "vehicle.turnedOnAnimation#anim2");
	self.turnedOnNode2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.turnedOnAnimation#node2"));
	self.hudBackground = Utils.getFilename("Texturas/fondo.dds", self.baseDirectory);
	self.hudBackgroundPoxX = 0.8265;
	self.hudBackgroundPoxY = 0.1715;
	self.hudBackgroundWidth = 0.18;
	self.hudBackgroundHeight = 0.2;
	self.hudBackgroundOverlay = Overlay:new("hudBackground", self.hudBackground, self.hudBackgroundPoxX, self.hudBackgroundPoxY, self.hudBackgroundWidth, self.hudBackgroundHeight);
	self.hudBinSelected = Utils.getFilename("Texturas/tolva_seleccionada.dds", self.baseDirectory);
	self.hudBinSelectedPoxX = 0.83;
	self.hudBinSelectedPoxY = 0.27;
	self.hudBinSelectedWidth = 0.075;
	self.hudBinSelectedHeight = 0.125;
	self.hudBinSelectedOverlay = Overlay:new("hudBinSelected", self.hudBinSelected, self.hudBinSelectedPoxX, self.hudBinSelectedPoxY, self.hudBinSelectedWidth, self.hudBinSelectedHeight);
	self.hudBinUnselected = Utils.getFilename("Texturas/tolva_deseleccionada.dds", self.baseDirectory);
	self.hudBinUnselectedPoxX = 0.83;
	self.hudBinUnselectedPoxY = 0.27;
	self.hudBinUnselectedWidth = 0.075;
	self.hudBinUnselectedHeight = 0.125;
	self.hudBinUnselectedOverlay = Overlay:new("hudBinUnselected", self.hudBinUnselected, self.hudBinUnselectedPoxX, self.hudBinUnselectedPoxY, self.hudBinUnselectedWidth, self.hudBinUnselectedHeight);
	self.hudBinSelected2 = Utils.getFilename("Texturas/tolva_seleccionada.dds", self.baseDirectory);
	self.hudBinSelected2PoxX = 0.92;
	self.hudBinSelected2PoxY = 0.27;
	self.hudBinSelected2Width = 0.075;
	self.hudBinSelected2Height = 0.125;
	self.hudBinSelected2Overlay = Overlay:new("hudBinSelected2", self.hudBinSelected2, self.hudBinSelected2PoxX, self.hudBinSelected2PoxY, self.hudBinSelected2Width, self.hudBinSelected2Height);
	self.hudBinUnselected2 = Utils.getFilename("Texturas/tolva_deseleccionada.dds", self.baseDirectory);
	self.hudBinUnselected2PoxX = 0.92;
	self.hudBinUnselected2PoxY = 0.27;
	self.hudBinUnselected2Width = 0.075;
	self.hudBinUnselected2Height = 0.125;
	self.hudBinUnselected2Overlay = Overlay:new("hudBinUnselected2", self.hudBinUnselected2, self.hudBinUnselected2PoxX, self.hudBinUnselected2PoxY, self.hudBinUnselected2Width, self.hudBinUnselected2Height);
	self.speedPercentage = 0
	self.turnedOnParticleSystems = {};
	local psName = "vehicle.testParticleSystem";
	local ps = "$data/vehicles/particleAnimations/shared/drivingParticleSystem.i3d";
	self.psNode =  Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.turnedOnParticles#node1"));
	Utils.loadParticleSystem(xmlFile, self.turnedOnParticleSystems, psName, self.psNode, false, ps, self.baseDirectory);
	self.turnedOnParticleSystems2 = {};
	local psName2 = "vehicle.testParticleSystem2";
	local ps2 = "Particle_system/eject.i3d";
	self.psNode2 =  Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.turnedOnParticles#node2"));
	Utils.loadParticleSystem(xmlFile, self.turnedOnParticleSystems2, psName2, self.psNode2, false, ps2, self.baseDirectory);
	self.turnedOnParticleSystems3 = {};
	local psName3 = "vehicle.testParticleSystem3";
	local ps3 = "$data/vehicles/particleAnimations/shared/drivingParticleSystem.i3d";
	self.psNode3 =  Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.turnedOnParticles#node3"));
	Utils.loadParticleSystem(xmlFile, self.turnedOnParticleSystems3, psName3, self.psNode3, false, ps3, self.baseDirectory);
	self.turnedOnParticleSystems4 = {};
	local psName4 = "vehicle.testParticleSystem4";
	local ps4 = "Particle_system/eject.i3d";
	self.psNode4 =  Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.turnedOnParticles#node4"));
	Utils.loadParticleSystem(xmlFile, self.turnedOnParticleSystems4, psName4, self.psNode4, false, ps4, self.baseDirectory);
	self.doorAnimation = getXMLString(xmlFile, "vehicle.doors#anim");
	self.doorNode =  Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.doors#node1"));
	self.doorNode2 =  Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.doors#node2"));
end;

function pickinghead:foot1Trigger(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	if g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
		if onEnter then
			self.playerIsInFoot1Trigger = true;
		elseif onLeave then
			self.playerIsInFoot1Trigger = false;
		end;
	end;
end;

function pickinghead:foot2Trigger(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	if g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
		if onEnter then
			self.playerIsInFoot2Trigger = true;
		elseif onLeave then
			self.playerIsInFoot2Trigger = false;
		end;
	end;
end;

function pickinghead:foot3Trigger(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	if g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
		if onEnter then
			self.playerIsInFoot3Trigger = true;
		elseif onLeave then
			self.playerIsInFoot3Trigger = false;
		end;
	end;
end;

function pickinghead:foot4Trigger(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	if g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
		if onEnter then
			self.playerIsInFoot4Trigger = true;
		elseif onLeave then
			self.playerIsInFoot4Trigger = false;
		end;
	end;
end;

function pickinghead:delete()
    Utils.deleteParticleSystem(self.turnedOnParticleSystems);
    Utils.deleteParticleSystem(self.turnedOnParticleSystems2);
    Utils.deleteParticleSystem(self.turnedOnParticleSystems3);
    Utils.deleteParticleSystem(self.turnedOnParticleSystems4);
	removeTrigger(self.foot1Trigger);
	removeTrigger(self.foot2Trigger);
	removeTrigger(self.foot3Trigger);
	removeTrigger(self.foot4Trigger);
end;

function pickinghead:mouseEvent(posX, posY, isDown, isUp, button)
end;

function pickinghead:keyEvent(unicode, sym, modifier, isDown)
end;

function pickinghead:update(dt)
	if self:getIsActiveForInput(false) then
		if self.storagemode == false then
			g_currentMission:addHelpButtonText(g_i18n:getText("storagemode"), InputBinding.storagemode);
			if InputBinding.hasEvent(InputBinding.storagemode) then
				self:playAnimation(self.storagemode_anim, 1);
				self.storagemode = true
			end;
		else g_currentMission:addHelpButtonText(g_i18n:getText("transportmode"), InputBinding.storagemode);
			if InputBinding.hasEvent(InputBinding.storagemode) then
				if self.foot1visibility ~= true and self.foot2visibility ~= true and self.foot3visibility ~= true and self.foot4visibility ~= true then
					self:playAnimation(self.storagemode_anim, -1);
					self.storagemode = false
				else  g_currentMission:showBlinkingWarning(g_i18n:getText("storagemode_warning"), 2000);
				end;
			end;
		end;
	end;


	if g_currentMission.player ~= nil and g_currentMission.player.isEntered then
		local px, py, pz = getWorldTranslation(g_currentMission.player.rootNode);
		local tx, ty, tz = getWorldTranslation(self.foot1Trigger);
		local t2x, t2y, t2z = getWorldTranslation(self.foot2Trigger);
		local t3x, t3y, t3z = getWorldTranslation(self.foot3Trigger);
		local t4x, t4y, t4z = getWorldTranslation(self.foot4Trigger);
		if Utils.vector3Length(px-tx, py-ty, pz-tz) < 1.5 then
			if self.foot1visibility == false then
				g_currentMission:addHelpButtonText(g_i18n:getText("trigger1_on"), InputBinding.trigger);
			else g_currentMission:addHelpButtonText(g_i18n:getText("trigger1_off"), InputBinding.trigger);
			end;
			if InputBinding.hasEvent(InputBinding.trigger) then
				if self.foot1visibility == true then
					if self.storagemode == true then
						self.foot1visibility = false
						self:playAnimation(self.foot1animation, 1);
					else g_currentMission:showBlinkingWarning(g_i18n:getText("transportmode_warning"), 2000);
					end
				elseif self.foot1visibility == false then
					if self.storagemode == true then
						self:playAnimation(self.foot1animation, -1);
						self.foot1visibility = true
					else g_currentMission:showBlinkingWarning(g_i18n:getText("transportmode_warning"), 2000);
					end
				end;
			end;
		elseif Utils.vector3Length(px-t2x, py-t2y, pz-t2z) < 1.5 then
			if self.foot2visibility == false then
				g_currentMission:addHelpButtonText(g_i18n:getText("trigger1_on"), InputBinding.trigger);
			else g_currentMission:addHelpButtonText(g_i18n:getText("trigger1_off"), InputBinding.trigger);
			end;
			if InputBinding.hasEvent(InputBinding.trigger) then
				if self.foot2visibility == true then
					if self.storagemode == true then
						self:playAnimation(self.foot2animation, 1);
						self.foot2visibility = false
					else g_currentMission:showBlinkingWarning(g_i18n:getText("transportmode_warning"), 2000);
					end
				elseif self.foot2visibility == false then
					if self.storagemode == true then
						self:playAnimation(self.foot2animation, -1);
						self.foot2visibility = true
					else g_currentMission:showBlinkingWarning(g_i18n:getText("transportmode_warning"), 2000);
					end
				end;
			end;
		elseif Utils.vector3Length(px-t3x, py-t3y, pz-t3z) < 1.5 then
			if self.foot3visibility == false then
				g_currentMission:addHelpButtonText(g_i18n:getText("trigger1_on"), InputBinding.trigger);
			else g_currentMission:addHelpButtonText(g_i18n:getText("trigger1_off"), InputBinding.trigger);
			end;
			if InputBinding.hasEvent(InputBinding.trigger) then
				if self.foot3visibility == true then
					if self.storagemode == true then
						self:playAnimation(self.foot3animation, 1);
						self.foot3visibility = false
					else g_currentMission:showBlinkingWarning(g_i18n:getText("transportmode_warning"), 2000);
					end
				elseif self.foot3visibility == false then
					if self.storagemode == true then
						self:playAnimation(self.foot3animation, -1);
						self.foot3visibility = true
					else g_currentMission:showBlinkingWarning(g_i18n:getText("transportmode_warning"), 2000);
					end
				end;
			end;
		elseif Utils.vector3Length(px-t4x, py-t4y, pz-t4z) < 1.5 then
			if self.foot4visibility == false then
				g_currentMission:addHelpButtonText(g_i18n:getText("trigger1_on"), InputBinding.trigger);
			else g_currentMission:addHelpButtonText(g_i18n:getText("trigger1_off"), InputBinding.trigger);
			end;
			if InputBinding.hasEvent(InputBinding.trigger) then
				if self.foot4visibility == true then
					if self.storagemode == true then
						self:playAnimation(self.foot4animation, 1);
						self.foot4visibility = false
					else g_currentMission:showBlinkingWarning(g_i18n:getText("transportmode_warning"), 2000);
					end
				elseif self.foot4visibility == false then
					if self.storagemode == true then
						self:playAnimation(self.foot4animation, -1);
						self.foot4visibility = true
					else g_currentMission:showBlinkingWarning(g_i18n:getText("transportmode_warning"), 2000);
					end
				end;
			end;
		end;
	end;

	if self:getIsActiveForInput(false) then
		if self.speed <= 7  and self.speed >=4 then
			if InputBinding.hasEvent(InputBinding.speedplus) then
				self.speed = self.speed + 1
			end;
		end;
	end;
	if self.speed <= 8 and self.speed > 4 then
		if InputBinding.hasEvent(InputBinding.speedless) then
			self.speed = self.speed - 1
		end;
	end

	if self.isTurnedOn then
		self.speedPercentage = (self.speed-3)/5 *100
	else
		self.speedPercentage = 0
	end
	if self:getIsActiveForInput(false) then
		local text = g_i18n:getText("speed");
		g_currentMission:addExtraPrintText(text);
	end;
end;

function pickinghead:updateTick(dt)
	if self:getIsActive() then
		if self.isTurnedOn then
			self:playAnimation(self.turnedOnAnimation, self.speed);
			self:playAnimation(self.turnedOnAnimation2, 5);
			Utils.setEmittingState(self.turnedOnParticleSystems, true)
			Utils.setEmittingState(self.turnedOnParticleSystems3, true)
			if self.combineIsFilling == true then
				Utils.setEmittingState(self.turnedOnParticleSystems2, true)
				Utils.setEmittingState(self.turnedOnParticleSystems4, true)
				self:playAnimation(self.doorAnimation, 1);
			elseif self.combineIsFilling == false or self.fillLevel >= self:getCapacity() then
				Utils.setEmittingState(self.turnedOnParticleSystems2, false)
				Utils.setEmittingState(self.turnedOnParticleSystems4, false)
				self:stopAnimation(self.doorAnimation);
				setRotation(self.doorNode, 0, 0, 0);
				setRotation(self.doorNode2, 0, 0, 0);
			end;
		else
			self:stopAnimation(self.turnedOnAnimation);
			self:stopAnimation(self.turnedOnAnimation2);
			setRotation( self.turnedOnNode2, 0, 0, 0);
			Utils.setEmittingState(self.turnedOnParticleSystems, false)
			Utils.setEmittingState(self.turnedOnParticleSystems3, false)
			Utils.setEmittingState(self.turnedOnParticleSystems2, false)
				Utils.setEmittingState(self.turnedOnParticleSystems4, false)
				self:stopAnimation(self.doorAnimation);
				setRotation(self.doorNode, 0, 0, 0);
				setRotation(self.doorNode2, 0, 0, 0);
		end;
	end;
end ;

function pickinghead:isDetachAllowed(superFunc)
	if self.foot1visibility == false or self.foot2visibility == false or self.foot3visibility == false or self.foot4visibility == false then
		return false;
    end;
	if superFunc ~= nil then
        return superFunc(self);
    end
    return true;
 end;

function pickinghead:draw()
	self.hudBackgroundOverlay:render();
	if self.chosenPipe == -1 then
		self.hudBinSelectedOverlay:render();
		self.hudBinUnselected2Overlay:render();
	elseif self.chosenPipe == 1 then
		self.hudBinUnselectedOverlay:render();
		self.hudBinSelected2Overlay:render();
	elseif self.chosenPipe == 0 then
		self.hudBinSelected2Overlay:render();
		self.hudBinSelectedOverlay:render();
	end;

	if self.lPercentage ~= nil then
		if self.lPercentage >= 100 then
			setTextColor(1, 0, 0, 1.0);
		else
			setTextColor(0, 0, 0, 1.0);
		end;
		setTextAlignment(RenderText.ALIGN_CENTER);
		setTextBold(true);
		renderText(0.867, 0.315, 0.027, (string.format("%5.2f%%", self.lPercentage)));
	end;
	if self.rPercentage ~= nil then
		if self.rPercentage >= 100 then
			setTextColor(1, 0, 0, 1.0);
		else
			setTextColor(0, 0, 0, 1.0);
		end;
		setTextAlignment(RenderText.ALIGN_CENTER);
		setTextBold(true);
		renderText(0.957, 0.315, 0.027, (string.format("%5.2f%%", self.rPercentage)));
	end;
	if self.speedPercentage ~= nil then
		setTextColor(0, 0, 0, 1.0);
		setTextAlignment(RenderText.ALIGN_CENTER);
		setTextBold(true);
		renderText(0.977, 0.215, 0.019, (string.format("%2.0f%%", self.speedPercentage)));
	end;
end;
