--
-- @author rucafer
-- @date 01/02/2013
--

gregoire_g8 = {};

function gregoire_g8.prerequisitesPresent(specializations)
	return true;
end;

function gregoire_g8:load(xmlFile)
	self.leanForward = {};
	self.leanForward.node = Utils.indexToObject( self.components, getXMLString(xmlFile, "vehicle.leanForward#node") );
	local x1,y1,z1 = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.leanForward#transMin"));
	local x2,y2,z2 = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.leanForward#transMax"));
	self.leanForward.transMin = {Utils.getNoNil(x1,0),Utils.getNoNil(y1,0),Utils.getNoNil(z1,0)};
	self.leanForward.transMax = {Utils.getNoNil(x2,0),Utils.getNoNil(y2,0),Utils.getNoNil(z2,0)};
	self.leanForward.moveTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.leanForward#moveTime"), 1)*1000;
	self.leanForward.camIndex = getXMLInt(xmlFile, "vehicle.leanForward#camIndex");
	self.joystick2 = {};
	self.joystick2.node = Utils.indexToObject( self.components, getXMLString(xmlFile, "vehicle.joystickAnimation#node") );
	self.joystick2.node2 = Utils.indexToObject( self.components, getXMLString(xmlFile, "vehicle.joystickAnimation#node2") );
	self.joystick2.rotLeft = math.rad( getXMLFloat(xmlFile, "vehicle.joystickAnimation#rotLeft") );
	self.joystick2.rotRight = math.rad( getXMLFloat(xmlFile, "vehicle.joystickAnimation#rotRight") );
	self.joystick2.button3 = Utils.indexToObject( self.components, getXMLString(xmlFile, "vehicle.joystickAnimation#button3") );
	self.joystick2.button4 = Utils.indexToObject( self.components, getXMLString(xmlFile, "vehicle.joystickAnimation#button4") );
	self.joystick2.button3_2 = Utils.indexToObject( self.components, getXMLString(xmlFile, "vehicle.joystickAnimation#button3.2") );
	self.joystick2.button4_2 = Utils.indexToObject( self.components, getXMLString(xmlFile, "vehicle.joystickAnimation#button4.2") );
end;

function gregoire_g8:delete()
end;

function gregoire_g8:mouseEvent(posX, posY, isDown, isUp, button)
end;

function gregoire_g8:keyEvent(unicode, sym, modifier, isDown)
end;

function gregoire_g8:update(dt)
	if self:getIsActiveForInput(false) then
		if InputBinding.isPressed(InputBinding.leanForward) and self.camIndex == self.leanForward.camIndex then
			self.leanForwardActive = true;
		else
			self.leanForwardActive = false;
		end;
	end;

	if self:getIsActiveForInput(false) and self.leanForward.node ~= nil then
		local curTrans = {getTranslation(self.leanForward.node)};
		local newTrans = Utils.getMovedLimitedValues(curTrans, self.leanForward.transMax, self.leanForward.transMin, 3, self.leanForward.moveTime, dt, not self.leanForwardActive);
		setTranslation(self.leanForward.node, unpack(newTrans));
	end;
	leftTrans = InputBinding.getDigitalInputAxis(InputBinding.AXIS_FRONTLOADER_ARM);
	rightTrans = InputBinding.getDigitalInputAxis(InputBinding.AXIS_FRONTLOADER_TOOL);

	if self:getIsActive() then
		if self.isClient then
			if rightTrans ~= 0 then
				setRotation( self.joystick2.node2, 0, 0, self.joystick2.rotRight);
			else
				setRotation( self.joystick2.node2, 0, 0, 0);
			end;


			if leftTrans ~= 0 then
				setRotation( self.joystick2.node, 0, 0, self.joystick2.rotLeft);
			else 
				setRotation( self.joystick2.node, 0, 0, 0);
			end;
			

			if rightTrans ==-1 or leftTrans ==1 then
				setTranslation( self.joystick2.button3, 0, 0, 0.004);
			elseif rightTrans ==1 or leftTrans ==-1 then
				setTranslation( self.joystick2.button4, 0, 0, 0.004);
			elseif rightTrans ==0 or leftTrans ==0 then
				setTranslation( self.joystick2.button4, 0, 0, 0);
				setTranslation( self.joystick2.button3, 0, 0, 0);
			elseif rightTrans ==1 and leftTrans ==1 then
				setTranslation( self.joystick2.button4, 0, 0, 0.004);
			elseif rightTrans ==-1 and leftTrans ==-1 then
				setTranslation( self.joystick2.button3, 0, 0, 0.004);
			end;
		end;
	end;
end;


function gregoire_g8:updateTick(dt)
end;

function gregoire_g8:draw()
	if self.camIndex == self.leanForward.camIndex then
		g_currentMission:addHelpButtonText(g_i18n:getText("leanForward"), InputBinding.leanForward);
	end;
end;
