--
-- @author rucafer
-- @date 13/04/2016

additionalPipe = {};

function additionalPipe.prerequisitesPresent(specializations)
	return true;
end;

function additionalPipe:load(xmlFile)
	self.rightPipeAnimation = getXMLString(xmlFile, "vehicle.additionalPipe.right#anim");
	self.leftPipeAnimation = getXMLString(xmlFile, "vehicle.additionalPipe.left#anim");
	self.bothPipeAnimation = getXMLString(xmlFile, "vehicle.additionalPipe.both#anim");
	self.pipeCapacity = self:getCapacity() / 2
	self.chosenPipe = 0      -- 1 right 0 both -1 left
	self.rightActive = false
	self.leftActive = false
	self.bothActive = false
	self.curFilllevelR = 0
	self.curFilllevelL = 0
	self.lastFillLevelDelta = 0
	self.rPercentage =	0
	self.lPercentage = 	0
	self.curfillType = 	nil
	self.type1 = getXMLString(xmlFile, "vehicle.additionalPipe.filltypes.filltype1#type");
	self.type2 = getXMLString(xmlFile, "vehicle.additionalPipe.filltypes.filltype2#type");
	self.type3 = getXMLString(xmlFile, "vehicle.additionalPipe.filltypes.filltype3#type");
	self.curFilllevelAnimR = nil
	self.curFilllevelAnimL = nil
	self.fillRAnimation1 =	getXMLString(xmlFile, "vehicle.additionalPipe.filltypes.filltype1#animationRight");
	self.fillRAnimation2 =	getXMLString(xmlFile, "vehicle.additionalPipe.filltypes.filltype2#animationRight");
	self.fillRAnimation3 =	getXMLString(xmlFile, "vehicle.additionalPipe.filltypes.filltype3#animationRight");
	self.fillLAnimation1 =	getXMLString(xmlFile, "vehicle.additionalPipe.filltypes.filltype1#animationLeft");
	self.fillLAnimation2 =	getXMLString(xmlFile, "vehicle.additionalPipe.filltypes.filltype2#animationLeft");
	self.fillLAnimation3 =	getXMLString(xmlFile, "vehicle.additionalPipe.filltypes.filltype3#animationLeft");
	self.animTimeL = 0
	self.rPartNode = Utils.indexToObject( self.components, getXMLString(xmlFile, "vehicle.additionalPipe.right#particle_node") );
	self.lPartNode = Utils.indexToObject( self.components, getXMLString(xmlFile, "vehicle.additionalPipe.left#particle_node") );
end;

function additionalPipe:delete()
end;

function additionalPipe:mouseEvent(posX, posY, isDown, isUp, button)
end;

function additionalPipe:keyEvent(unicode, sym, modifier, isDown)
end;

function additionalPipe:update(dt)
	if self:getIsActiveForInput(false) then
		if self.rightActive == false and self.leftActive == false and self.bothActive ==  false then
			g_currentMission:addHelpButtonText(g_i18n:getText("changePipe"), InputBinding.changePipe);
			if self.chosenPipe == 0 then
				if InputBinding.hasEvent(InputBinding.changePipe) then
					self.chosenPipe = 1
				end;
			elseif self.chosenPipe == 1 then
				if InputBinding.hasEvent(InputBinding.changePipe) then
					self.chosenPipe = -1
				end;
			elseif self.chosenPipe == -1 or self.chosenPipe == 0 then
				if InputBinding.hasEvent(InputBinding.changePipe) then
					self.chosenPipe = 0
				end;
			end;
		end;
	end;

	if self:getIsActiveForInput(false) then
	if self.chosenPipe ==1 then
		if self.rightActive == false then
			g_currentMission:addHelpButtonText(g_i18n:getText("rightActive"), InputBinding.pipe);
			if InputBinding.hasEvent(InputBinding.pipe) then
				self.rightActive = true
				self:playAnimation(self.rightPipeAnimation, 0.5);
			end;
		elseif self.rightActive == true then
			g_currentMission:addHelpButtonText(g_i18n:getText("rightInactive"), InputBinding.pipe);
			if InputBinding.hasEvent(InputBinding.pipe) then
				self.rightActive = false
				self:playAnimation(self.rightPipeAnimation, -0.5);
			end;
		end;
	end;

	if self.chosenPipe ==-1 then
		if self.leftActive == false then
			g_currentMission:addHelpButtonText(g_i18n:getText("leftActive"), InputBinding.pipe);
			if InputBinding.hasEvent(InputBinding.pipe) then
				self.leftActive = true
				self:playAnimation(self.leftPipeAnimation, 0.5);
			end;
		elseif self.leftActive == true then
			g_currentMission:addHelpButtonText(g_i18n:getText("leftInactive"), InputBinding.pipe);
			if InputBinding.hasEvent(InputBinding.pipe) then
				self.leftActive = false
				self:playAnimation(self.leftPipeAnimation, -0.5);
			end;
		end;
	end

	if self.chosenPipe ==0 then
		if self.bothActive == false then
			g_currentMission:addHelpButtonText(g_i18n:getText("bothActive"), InputBinding.pipe);
			if InputBinding.hasEvent(InputBinding.pipe) then
				self.bothActive = true
				self:playAnimation(self.bothPipeAnimation, 0.5);
			end;
		elseif self.bothActive == true then
			g_currentMission:addHelpButtonText(g_i18n:getText("bothInactive"), InputBinding.pipe);
			if InputBinding.hasEvent(InputBinding.pipe) then
				self.bothActive = false
				self:playAnimation(self.bothPipeAnimation, -0.5);
			end;
		end;
	end;
	end;
	self.rPercentage =	self.curFilllevelR/(self:getCapacity()/2)*100
	self.lPercentage =  self.curFilllevelL/(self:getCapacity()/2)*100

	if self.rPercentage > 100 then
		self.rPercentage = 100
	end;
	if self.lPercentage > 100 then
		self.lPercentage = 100
	end;

	self.curfillType = Fillable.fillTypeIntToName[self.currentFillType]

	if  self.curfillType == self.type1 then
		self.curFilllevelAnimR = self.fillRAnimation1
		self.curFilllevelAnimL = self.fillLAnimation1
	elseif  self.curfillType == self.type2 then
		self.curFilllevelAnimR = self.fillRAnimation2
		self.curFilllevelAnimL = self.fillLAnimation2
	elseif  self.curfillType == self.type3 then
		self.curFilllevelAnimR = self.fillRAnimation3
		self.curFilllevelAnimL = self.fillLAnimation3
	end
	self.animTimeL = self.curFilllevelL/(self:getCapacity()/2)
	self.animTimeR = self.curFilllevelR/(self:getCapacity()/2)
	if self.curFilllevelAnimL ~= nil and self.curFilllevelAnimR ~= nil then
		self:setAnimationTime(self.curFilllevelAnimL, self.animTimeL, true)
		self:setAnimationTime(self.curFilllevelAnimR, self.animTimeR, true)
	elseif self.curfillType == "unknown" then
		self:setAnimationTime(self.curFilllevelAnimL, 0, true)
		self:setAnimationTime(self.curFilllevelAnimR, 0, true)
	end;
	if self.rightActive == true then
		setVisibility(self.rPartNode, true);
		setVisibility(self.lPartNode, false);
	elseif self.leftActive == true then
		setVisibility(self.lPartNode, true);
		setVisibility(self.rPartNode, false);
	elseif self.bothActive == true then
		if self. curFilllevelL == 0 then
			setVisibility(self.lPartNode, false);
		else
			setVisibility(self.lPartNode, true);
		end;
		if self. curFilllevelR == 0 then
			setVisibility(self.rPartNode, false);
		else
			setVisibility(self.rPartNode, true);
		end;
	end;
		if (self.rightActive == true or self.leftActive == true or self.bothActive == true) and self:getIsAnimationPlaying(self.bothPipeAnimation)==false and self:getIsAnimationPlaying(self.leftPipeAnimation) == false and self:getIsAnimationPlaying(self.rightPipeAnimation)==false and self:getIsAnimationPlaying(self.leftPipeAnimation)==false and self:getIsAnimationPlaying(self.bothPipeAnimationipeAnimation)==false then
		self:setPipeState(2);
	else self:setPipeState(1);
	end;
end;

function additionalPipe:updateTick(dt)

		local delta = self.fillLevel - self.lastFillLevelDelta;

		self.lastFillLevelDelta = self.fillLevel;

	if self.pipeIsUnloading==false then
		if self.curFilllevelR < self:getCapacity()/2 and self.curFilllevelL < self:getCapacity()/2 then
			self.curFilllevelR = self.curFilllevelR + (delta/2)
			self.curFilllevelL = self.curFilllevelL + (delta/2)
		elseif self.curFilllevelR >= self:getCapacity()/2 then
			self.curFilllevelL = self.curFilllevelL + delta
		elseif self.curFilllevelL >= self:getCapacity()/2 then
			self.curFilllevelR = self.curFilllevelR + delta
		end;
	end

	--print("self.curFilllevelL  "..self.curFilllevelL.."   self.curFilllevelR   "..self.curFilllevelR)

	if self.pipeIsUnloading == true then
		local dischargeDelta = self.overloadingCapacity*dt/1000.0
		if self.rightActive == true then
			if self.fillLevel >0 then
				self.curFilllevelR = self.curFilllevelR - math.min(dischargeDelta, self.curFilllevelR)
			else
				self.curFilllevelR = 0
			end
		elseif self.leftActive == true then
			if self.fillLevel >0 then
				self.curFilllevelL = self.curFilllevelL -  math.min(dischargeDelta, self.curFilllevelL)
			else
				self.curFilllevelL = 0
			end
		elseif self.bothActive == true then
			if self.fillLevel >0 then
				if self.curFilllevelL > 0 then
					self.curFilllevelL = self.curFilllevelL - math.min(dischargeDelta/2, self.curFilllevelL)
				end
				if self.curFilllevelR > 0 then
					self.curFilllevelR = self.curFilllevelR - math.min(dischargeDelta/2, self.curFilllevelR)
				end;
			else
				self.curFilllevelR = 0
				self.curFilllevelL = 0
			end
		end;
	end;

	if self.rightActive == true then
		if self.curFilllevelR <= 0 then
			self:setPipeState(1);
		else self:setPipeState(2);
		end;
	elseif self.leftActive == true then
		if self.curFilllevelL <= 0 then
			self:setPipeState(1);
		else self:setPipeState(2);
		end;
	elseif self.bothActive == true then
		if self.curFilllevelL <= 0 and self.curFilllevelR <= 0 then
			self:setPipeState(1);
		else self:setPipeState(2);
		end;
	end;
end

function additionalPipe:draw()
end;
