--
-- IH 86 series
-- Specialization class for IH 86 series
--
-- @author  PeterJ - euroDZN
-- @date  2/10/2012
--
-- http://eurodzn.wordpress.com/
--
-- Copyright (C) euroDZN, Confidential, All Rights Reserved.

IH86 = {};

function IH86.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function IH86:load(xmlFile)
	self.hasNeedles = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.needles#hasNeedle"), false);
	local rotationPartFuel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.needles.fuel#index"));
    if rotationPartFuel ~= nil then
        self.rotationFuel = {};
        self.rotationFuel.node = rotationPartFuel;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.needles.fuel#minRot"));
        self.rotationFuel.minRot = {};
        self.rotationFuel.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationFuel.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationFuel.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.needles.fuel#maxRot"));
        self.rotationFuel.maxRot = {};
        self.rotationFuel.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationFuel.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationFuel.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
	end;
	local rotationPartNode9 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.needles.battery#index"));
    if rotationPartNode9 ~= nil then
        self.rotationPart9 = {};
        self.rotationPart9.node = rotationPartNode9;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.needles.battery#minRot"));
        self.rotationPart9.minRot = {};
        self.rotationPart9.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart9.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart9.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.needles.battery#maxRot"));
        self.rotationPart9.maxRot = {};
        self.rotationPart9.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart9.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart9.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart9.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.needles.battery#rotTime"), 2)*1000;
    end;
	local rotationPartNode10 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.needles.temperature#index"));
    if rotationPartNode10 ~= nil then
        self.rotationPart10 = {};
        self.rotationPart10.node = rotationPartNode10;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.needles.temperature#minRot"));
        self.rotationPart10.minRot = {};
        self.rotationPart10.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart10.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart10.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.needles.temperature#maxRot"));
        self.rotationPart10.maxRot = {};
        self.rotationPart10.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart10.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart10.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart10.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.needles.temperature#rotTime"), 2)*1000;
    end;
	local rotationPartNode11 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.needles.pressure#index"));
    if rotationPartNode11 ~= nil then
        self.rotationPart11 = {};
        self.rotationPart11.node = rotationPartNode11;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.needles.pressure#minRot"));
        self.rotationPart11.minRot = {};
        self.rotationPart11.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart11.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart11.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.needles.pressure#maxRot"));
        self.rotationPart11.maxRot = {};
        self.rotationPart11.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart11.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart11.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart11.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.needles.pressure#rotTime"), 2)*1000;
    end;
	self.unloadBack = getXMLString(xmlFile, "vehicle.unloadBack#animationName");
	self.tahometr = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.needles.rpmNeedle#index"));
	self.speed = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.needles.speedNeedle#index"));
	self.povorotnyk = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.povorotnyk#index"));
end;

function IH86:delete()
end;

function IH86:mouseEvent(posX, posY, isDown, isUp, button)
end;

function IH86:keyEvent(unicode, sym, modifier, isDown)
end;

function IH86:update(dt)
	if self:getIsActive() then
		if self.hasNeedles then
			if self.isMotorStarted then
				local x, y, z = getRotation(self.rotationFuel.node);
				x = (self.rotationFuel.maxRot[1] - self.rotationFuel.minRot[1]) * (self.fuelFillLevel/self.fuelCapacity);
				y = (self.rotationFuel.maxRot[2] - self.rotationFuel.minRot[2]) * (self.fuelFillLevel/self.fuelCapacity);
				z = (self.rotationFuel.maxRot[3] - self.rotationFuel.minRot[3]) * (self.fuelFillLevel/self.fuelCapacity);
				setRotation(self.rotationFuel.node, x, y, z);
				self.operateNeedles = true;
--				if not self.isHired then
--					self.steeringEnabled = true;
--				end;
				local kmh = math.min(100, math.max(0, self.lastSpeed*self.speedDisplayScale*3600));
				local rotateTahometr = (((kmh / 30)*35) -330);
				local rotateSpeed = (((kmh / 50)*110) -0);
				if self.tahometr then
					setRotation(self.tahometr, 0, Utils.degToRad( - rotateTahometr), 0);
					setRotation(self.speed, 0, Utils.degToRad( - rotateSpeed), 0);
				end;
			else
				setRotation(self.rotationFuel.node, self.rotationFuel.minRot[1], self.rotationFuel.minRot[2], self.rotationFuel.minRot[3]);
				self.operateNeedles = false;
--				if not self.isHired then
--					self.steeringEnabled = false;
--				end;
				setRotation(self.tahometr, 0, 0, 0);
				setRotation(self.speed, 0, 0, 0);
			end;
			local x, y, z = getRotation(self.rotationPart9.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart9.maxRot, self.rotationPart9.minRot, 3, self.rotationPart9.rotTime, dt, not self.operateNeedles);
			setRotation(self.rotationPart9.node, unpack(newRot));
			
			local x, y, z = getRotation(self.rotationPart10.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart10.maxRot, self.rotationPart10.minRot, 3, self.rotationPart10.rotTime, dt, not self.operateNeedles);
			setRotation(self.rotationPart10.node, unpack(newRot));
			
			local x, y, z = getRotation(self.rotationPart11.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart11.maxRot, self.rotationPart11.minRot, 3, self.rotationPart11.rotTime, dt, not self.operateNeedles);
			setRotation(self.rotationPart11.node, unpack(newRot));
		end;
	end;
	if self.povorotnyk ~= nil then
		if not self.B3.wl then
			if self.B3.dirRight[1].a then
				setRotation(self.povorotnyk, 0, math.rad(-20), 0);
			elseif self.B3.dirLeft[1].a then
				setRotation(self.povorotnyk, 0, math.rad(20), 0);
			else
				setRotation(self.povorotnyk, 0, 0, 0);
			end;
		else
			setRotation(self.povorotnyk, 0, 0, 0);
		end;
	end;
end;

function IH86:updateTick(dt)
end;

function IH86:draw()
end;

function IH86:onEnter()
end;

function IH86:onLeave()
end;

function IH86:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;

function IH86:attachImplement(implement)
	local jointType = implement.object.attacherJoint.jointType;

	if jointType == Vehicle.JOINTTYPE_TRAILER then
		if self.unloadBack ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.unloadBack, 1, nil, true);
			self.trailerAttached = true;
		end;
	elseif jointType == Vehicle.JOINTTYPE_TRAILERLOW then	
		if self.unloadBack ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.unloadBack, 1, nil, true);
			self.trailerAttached = true;
		end;
	end;
end;

function IH86:detachImplement(implementIndex)
	local implement = self.attachedImplements[implementIndex];
	local jointType = implement.object.attacherJoint.jointType;

	if jointType == Vehicle.JOINTTYPE_TRAILER or jointType == Vehicle.JOINTTYPE_TRAILERLOW then
		if self.unloadBack ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.unloadBack, -1, nil, true);
			self.trailerAttached = false;
		end;
	end;
end;
